/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.contracts.asset;

import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.Issued;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.AnonymousParty;
import net.corda.finance.contracts.asset.Obligation;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aV\u0010\u0000\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u00040\u0001\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00052\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000b0\n\u001a^\u0010\f\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00060\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00040\u0001\"\b\b\u0000\u0010\u0006*\u00020\u0003\"\b\b\u0001\u0010\r*\u00020\u00072$\u0010\u000e\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00060\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00040\u0001\u001aL\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00100\u0001\"\b\b\u0000\u0010\u0006*\u00020\u0003\"\b\b\u0001\u0010\r*\u00020\u00072$\u0010\u000e\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00060\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00040\u0001\u001a+\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0000\u0010\r*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0004\u001a7\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0000\u0010\r*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002H\u0086\u0004\u001a+\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0000\u0010\r*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0004\u001a(\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0000\u0010\r*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u0017\u001a\u00020\u0019\u001a+\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0000\u0010\r*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u001b\u001a\u00020\u0003H\u0086\u0004\u001a(\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0000\u0010\r*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u001b\u001a\u00020\u0003\u00a8\u0006\u001d"}, d2={"extractAmountsDue", "", "Lkotlin/Pair;", "Lnet/corda/core/identity/AbstractParty;", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/finance/contracts/asset/Obligation$Terms;", "P", "", "product", "states", "", "Lnet/corda/finance/contracts/asset/Obligation$State;", "netAmountsDue", "T", "balances", "sumAmountsDue", "", "at", "dueBefore", "Ljava/time/Instant;", "between", "parties", "issued by", "party", "issuedBy", "Lnet/corda/core/identity/AnonymousParty;", "owned by", "owner", "ownedBy", "contracts"})
public final class ObligationKt {
    @NotNull
    public static final <P> Map<Pair<AbstractParty, AbstractParty>, Amount<Obligation.Terms<P>>> extractAmountsDue(@NotNull Obligation.Terms<P> product, @NotNull Iterable<Obligation.State<P>> states) {
        Intrinsics.checkParameterIsNotNull(product, (String)"product");
        Intrinsics.checkParameterIsNotNull(states, (String)"states");
        HashMap balances = new HashMap();
        Iterable<Obligation.State<P>> $receiver$iv = states;
        for (Obligation.State<P> element$iv : $receiver$iv) {
            Obligation.State<P> state = element$iv;
            Pair key = new Pair((Object)state.getObligor(), (Object)state.getBeneficiary());
            Amount amount = (Amount)balances.get(key);
            if (amount == null) {
                amount = new Amount(0L, product);
            }
            Amount balance = amount;
            Map map = balances;
            Amount amount2 = balance.plus(new Amount(state.getAmount().getQuantity(), ((Issued)state.getAmount().getToken()).getProduct()));
            map.put(key, amount2);
        }
        return balances;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <P extends AbstractParty, T> Map<Pair<P, P>, Amount<T>> netAmountsDue(@NotNull Map<Pair<P, P>, Amount<T>> balances) {
        Map<Pair<P, P>, Amount<T>> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(balances, (String)"balances");
        HashMap nettedBalances = new HashMap();
        Map<Pair<P, P>, Amount<T>> map = $receiver$iv = balances;
        Iterator<Map.Entry<Pair<P, P>, Amount<T>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Amount amount;
            Map map2;
            Amount opposite;
            void obligor;
            Map.Entry<Pair<P, P>, Amount<T>> element$iv;
            Map.Entry<Pair<P, P>, Amount<T>> balance = element$iv = iterator.next();
            Pair<P, P> pair = balance.getKey();
            AbstractParty abstractParty = (AbstractParty)pair.component1();
            AbstractParty beneficiary = (AbstractParty)pair.component2();
            Pair oppositeKey = new Pair((Object)beneficiary, (Object)obligor);
            Amount amount2 = balances.get(oppositeKey);
            if (amount2 == null) {
                amount2 = opposite = new Amount(0L, balance.getValue().getToken());
            }
            if (balance.getValue().compareTo(opposite) > 0) {
                map2 = nettedBalances;
                amount = balance.getKey();
                Amount amount3 = balance.getValue().minus(opposite);
                map2.put(amount, amount3);
                continue;
            }
            if (opposite.compareTo(balance.getValue()) <= 0) continue;
            map2 = nettedBalances;
            amount = opposite.minus(balance.getValue());
            map2.put(oppositeKey, amount);
        }
        return nettedBalances;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <P extends AbstractParty, T> Map<P, Long> sumAmountsDue(@NotNull Map<Pair<P, P>, Amount<T>> balances) {
        Object object;
        Object object2;
        Object element$iv;
        Intrinsics.checkParameterIsNotNull(balances, (String)"balances");
        HashMap sum = new HashMap();
        Object $receiver$iv = balances.keySet();
        Object object3 = $receiver$iv.iterator();
        while (object3.hasNext()) {
            element$iv = object3.next();
            Pair it = (Pair)element$iv;
            object2 = sum;
            Object object4 = it.getFirst();
            object = 0L;
            object2.put(object4, object);
            object2 = sum;
            object4 = it.getSecond();
            object = 0L;
            object2.put(object4, object);
        }
        element$iv = balances;
        object3 = element$iv.entrySet().iterator();
        while (object3.hasNext()) {
            void obligor;
            object2 = $receiver$iv = (Map.Entry)object3.next();
            Pair key = (Pair)object2.getKey();
            object2 = $receiver$iv;
            Amount amount = (Amount)object2.getValue();
            object = key;
            object2 = (AbstractParty)object.component1();
            AbstractParty beneficiary = (AbstractParty)object.component2();
            object = sum;
            Object v = sum.get(obligor);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            Long l = ((Number)v).longValue() - amount.getQuantity();
            object.put(obligor, l);
            object = sum;
            Object v2 = sum.get(beneficiary);
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            l = ((Number)v2).longValue() + amount.getQuantity();
            object.put(beneficiary, l);
        }
        object3 = sum;
        Iterator iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            long amount = ((Number)iterator.next().getValue()).longValue();
            if (amount != 0L) continue;
            iterator.remove();
        }
        return sum;
    }

    @NotNull
    public static final <T> Obligation.State<T> at(@NotNull Obligation.State<T> $receiver, @NotNull Instant dueBefore) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)dueBefore, (String)"dueBefore");
        return Obligation.State.copy$default($receiver, null, null, Obligation.Terms.copy$default($receiver.getTemplate(), null, null, dueBefore, null, 11, null), 0L, null, 27, null);
    }

    @NotNull
    public static final <T> Obligation.State<T> between(@NotNull Obligation.State<T> $receiver, @NotNull Pair<? extends AbstractParty, ? extends AbstractParty> parties) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(parties, (String)"parties");
        return Obligation.State.copy$default($receiver, null, (AbstractParty)parties.getFirst(), null, 0L, (AbstractParty)parties.getSecond(), 13, null);
    }

    @NotNull
    public static final <T> Obligation.State<T> owned by(@NotNull Obligation.State<T> $receiver, @NotNull AbstractParty owner) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return Obligation.State.copy$default($receiver, null, null, null, 0L, owner, 15, null);
    }

    @NotNull
    public static final <T> Obligation.State<T> issued by(@NotNull Obligation.State<T> $receiver, @NotNull AbstractParty party) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
        return Obligation.State.copy$default($receiver, null, party, null, 0L, null, 29, null);
    }

    @NotNull
    public static final <T> Obligation.State<T> ownedBy(@NotNull Obligation.State<T> $receiver, @NotNull AbstractParty owner) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return Obligation.State.copy$default($receiver, null, null, null, 0L, owner, 15, null);
    }

    @NotNull
    public static final <T> Obligation.State<T> issuedBy(@NotNull Obligation.State<T> $receiver, @NotNull AnonymousParty party) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
        return Obligation.State.copy$default($receiver, null, (AbstractParty)party, null, 0L, null, 29, null);
    }
}

