/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.contracts;

import java.math.BigDecimal;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.TokenizableAssetInfo;
import net.corda.core.serialization.CordaSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lnet/corda/finance/contracts/Commodity;", "Lnet/corda/core/contracts/TokenizableAssetInfo;", "commodityCode", "", "displayName", "defaultFractionDigits", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "getCommodityCode", "()Ljava/lang/String;", "getDefaultFractionDigits", "()I", "getDisplayName", "displayTokenSize", "Ljava/math/BigDecimal;", "getDisplayTokenSize", "()Ljava/math/BigDecimal;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "Companion", "contracts"})
public final class Commodity
implements TokenizableAssetInfo {
    @NotNull
    private final String commodityCode;
    @NotNull
    private final String displayName;
    private final int defaultFractionDigits;
    private static final Map<String, Commodity> registry;
    public static final Companion Companion;

    @NotNull
    public BigDecimal getDisplayTokenSize() {
        BigDecimal bigDecimal = BigDecimal.ONE.scaleByPowerOfTen(-this.defaultFractionDigits);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"BigDecimal.ONE.scaleByPo\u2026n(-defaultFractionDigits)");
        return bigDecimal;
    }

    @NotNull
    public final String getCommodityCode() {
        return this.commodityCode;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    public final int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public Commodity(@NotNull String commodityCode, @NotNull String displayName, int defaultFractionDigits) {
        Intrinsics.checkParameterIsNotNull((Object)commodityCode, (String)"commodityCode");
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        this.commodityCode = commodityCode;
        this.displayName = displayName;
        this.defaultFractionDigits = defaultFractionDigits;
    }

    public /* synthetic */ Commodity(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(string, string2, n);
    }

    static {
        Companion = new Companion(null);
        registry = MapsKt.mapOf((Pair)new Pair((Object)"FCOJ", (Object)new Commodity("FCOJ", "Frozen concentrated orange juice", 0, 4, null)));
    }

    @NotNull
    public final String component1() {
        return this.commodityCode;
    }

    @NotNull
    public final String component2() {
        return this.displayName;
    }

    public final int component3() {
        return this.defaultFractionDigits;
    }

    @NotNull
    public final Commodity copy(@NotNull String commodityCode, @NotNull String displayName, int defaultFractionDigits) {
        Intrinsics.checkParameterIsNotNull((Object)commodityCode, (String)"commodityCode");
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        return new Commodity(commodityCode, displayName, defaultFractionDigits);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Commodity copy$default(Commodity commodity, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = commodity.commodityCode;
        }
        if ((n2 & 2) != 0) {
            string2 = commodity.displayName;
        }
        if ((n2 & 4) != 0) {
            n = commodity.defaultFractionDigits;
        }
        return commodity.copy(string, string2, n);
    }

    @NotNull
    public String toString() {
        return "Commodity(commodityCode=" + this.commodityCode + ", displayName=" + this.displayName + ", defaultFractionDigits=" + this.defaultFractionDigits + ")";
    }

    public int hashCode() {
        String string = this.commodityCode;
        String string2 = this.displayName;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Integer.hashCode(this.defaultFractionDigits);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Commodity)) break block3;
                Commodity commodity = (Commodity)object;
                if (!Intrinsics.areEqual((Object)this.commodityCode, (Object)commodity.commodityCode) || !Intrinsics.areEqual((Object)this.displayName, (Object)commodity.displayName) || !(this.defaultFractionDigits == commodity.defaultFractionDigits)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/corda/finance/contracts/Commodity$Companion;", "", "()V", "registry", "", "", "Lnet/corda/finance/contracts/Commodity;", "getInstance", "commodityCode", "contracts"})
    public static final class Companion {
        @Nullable
        public final Commodity getInstance(@NotNull String commodityCode) {
            Intrinsics.checkParameterIsNotNull((Object)commodityCode, (String)"commodityCode");
            return (Commodity)registry.get(commodityCode);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

