/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.ClassWriter;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.concurrent.util.MapUtil;
import co.paralleluniverse.fibers.instrument.Log;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.QuasarInstrumentor;
import co.paralleluniverse.fibers.instrument.Retransform;
import co.paralleluniverse.fibers.instrument.SuspendableHelper;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Set;

public class JavaAgent {
    private static final String USAGE = "Usage: vdmcbx(exclusion;...)l(exclusion;...) (verbose, debug, allow monitors, check class, allow blocking)";
    private static volatile boolean ACTIVE;
    private static final Set<WeakReference<ClassLoader>> classLoaders;

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        if (!instrumentation.isRetransformClassesSupported()) {
            System.err.println("Retransforming classes is not supported!");
        }
        QuasarInstrumentor instrumentor = new QuasarInstrumentor(false);
        ACTIVE = true;
        SuspendableHelper.javaAgent = true;
        if (agentArguments != null) {
            block9: for (int i = 0; i < agentArguments.length(); ++i) {
                char c = agentArguments.charAt(i);
                switch (c) {
                    case 'v': {
                        instrumentor.setVerbose(true);
                        continue block9;
                    }
                    case 'd': {
                        instrumentor.setDebug(true);
                        continue block9;
                    }
                    case 'm': {
                        instrumentor.setAllowMonitors(true);
                        continue block9;
                    }
                    case 'c': {
                        instrumentor.setCheck(true);
                        continue block9;
                    }
                    case 'b': {
                        instrumentor.setAllowBlocking(true);
                        continue block9;
                    }
                    case 'x': {
                        String[] exclusions;
                        c = agentArguments.charAt(++i);
                        if (c != '(') {
                            throw new IllegalStateException(USAGE);
                        }
                        StringBuilder sb = new StringBuilder();
                        while ((c = agentArguments.charAt(++i)) != ')') {
                            sb.append(c);
                        }
                        for (String x : exclusions = sb.toString().split(";")) {
                            instrumentor.addExcludedPackage(x);
                        }
                        continue block9;
                    }
                    case 'l': {
                        String[] classLoaderExclusions;
                        int j;
                        c = agentArguments.charAt(++i);
                        if (c != '(') {
                            throw new IllegalStateException(USAGE);
                        }
                        if ((j = agentArguments.indexOf(41, ++i)) == -1) {
                            throw new IllegalStateException(USAGE);
                        }
                        for (String x : classLoaderExclusions = agentArguments.substring(i, j).split(";", 0)) {
                            instrumentor.addExcludedClassLoader(x);
                        }
                        i = j;
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException(USAGE);
                    }
                }
            }
        }
        instrumentor.setLog(new Log(){

            @Override
            public void log(LogLevel level, String msg, Object ... args) {
                System.err.println("[quasar] " + (Object)((Object)level) + ": " + String.format(msg, args));
            }

            @Override
            public void error(String msg, Throwable exc) {
                System.err.println("[quasar] ERROR: " + msg);
                exc.printStackTrace(System.err);
            }
        });
        Retransform.instrumentation = instrumentation;
        Retransform.instrumentor = instrumentor;
        Retransform.classLoaders = classLoaders;
        instrumentation.addTransformer(new Transformer(instrumentor), true);
    }

    public static void agentmain(String agentArguments, Instrumentation instrumentation) {
        JavaAgent.premain(agentArguments, instrumentation);
    }

    public static boolean isActive() {
        return ACTIVE;
    }

    public static byte[] crazyClojureOnceDisable(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!Boolean.parseBoolean(System.getProperty("co.paralleluniverse.pulsar.disableOnce", "false"))) {
            return classfileBuffer;
        }
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(cr, 0);
        ClassVisitor cv = new ClassVisitor(327680, cw){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

                    @Override
                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof String && cst.equals("once")) {
                            super.visitLdcInsn("once$disabled-by-pulsar");
                        } else {
                            super.visitLdcInsn(cst);
                        }
                    }
                };
            }
        };
        cr.accept(cv, 0);
        return cw.toByteArray();
    }

    static {
        classLoaders = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
    }

    private static class Transformer
    implements ClassFileTransformer {
        private final QuasarInstrumentor instrumentor;

        public Transformer(QuasarInstrumentor instrumentor) {
            this.instrumentor = instrumentor;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (!this.instrumentor.shouldInstrument(loader)) {
                return null;
            }
            if (className != null && className.startsWith("clojure/lang/Compiler")) {
                return JavaAgent.crazyClojureOnceDisable(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            }
            if (!this.instrumentor.shouldInstrument(className)) {
                return null;
            }
            Retransform.beforeTransform(className, classBeingRedefined, classfileBuffer);
            classLoaders.add(new WeakReference<ClassLoader>(loader));
            try {
                byte[] transformed = this.instrumentor.instrumentClass(loader, className, classfileBuffer);
                if (transformed != null) {
                    Retransform.afterTransform(className, classBeingRedefined, transformed);
                }
                return transformed;
            }
            catch (Throwable t) {
                this.instrumentor.error("while transforming " + className + ": " + t.getMessage(), t);
                return null;
            }
        }
    }
}

