#region License and Terms
// MoreLINQ - Extensions to LINQ to Objects
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
#endregion

// This code was generated by a tool. Any changes made manually will be lost
// the next time this code is regenerated.

namespace MoreLinq.Extensions
{
    using System;
    using System.CodeDom.Compiler;
    using System.Collections.Generic;
    using System.Linq;
    using System.Collections;

    /// <summary><c>Acquire</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class AcquireExtension
    {
        /// <summary>
        /// Ensures that a source sequence of <see cref="IDisposable"/>
        /// objects are all acquired successfully. If the acquisition of any
        /// one <see cref="IDisposable"/> fails then those successfully
        /// acquired till that point are disposed.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <param name="source">Source sequence of <see cref="IDisposable"/> objects.</param>
        /// <returns>
        /// Returns an array of all the acquired <see cref="IDisposable"/>
        /// objects in source order.
        /// </returns>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TSource[] Acquire<TSource>(this IEnumerable<TSource> source)
            where TSource : IDisposable
            => MoreEnumerable.Acquire(source);

    }

    /// <summary><c>Aggregate</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class AggregateExtension
    {
        /// <summary>
        /// Applies two accumulators sequentially in a single pass over a
        /// sequence.
        /// </summary>
        /// <typeparam name="T">The type of elements in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TAccumulate1">The type of first accumulator value.</typeparam>
        /// <typeparam name="TAccumulate2">The type of second accumulator value.</typeparam>
        /// <typeparam name="TResult">The type of the accumulated result.</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="seed1">The seed value for the first accumulator.</param>
        /// <param name="accumulator1">The first accumulator.</param>
        /// <param name="seed2">The seed value for the second accumulator.</param>
        /// <param name="accumulator2">The second accumulator.</param>
        /// <param name="resultSelector">
        /// A function that projects a single result given the result of each
        /// accumulator.</param>
        /// <returns>The value returned by <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TResult Aggregate<T, TAccumulate1, TAccumulate2, TResult>(
            this IEnumerable<T> source,
            TAccumulate1 seed1, Func<TAccumulate1, T, TAccumulate1> accumulator1,
            TAccumulate2 seed2, Func<TAccumulate2, T, TAccumulate2> accumulator2,
            Func<TAccumulate1, TAccumulate2, TResult> resultSelector)
            => MoreEnumerable.Aggregate(source, seed1, accumulator1, seed2, accumulator2, resultSelector);
        /// <summary>
        /// Applies three accumulators sequentially in a single pass over a
        /// sequence.
        /// </summary>
        /// <typeparam name="T">The type of elements in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TAccumulate1">The type of first accumulator value.</typeparam>
        /// <typeparam name="TAccumulate2">The type of second accumulator value.</typeparam>
        /// <typeparam name="TAccumulate3">The type of third accumulator value.</typeparam>
        /// <typeparam name="TResult">The type of the accumulated result.</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="seed1">The seed value for the first accumulator.</param>
        /// <param name="accumulator1">The first accumulator.</param>
        /// <param name="seed2">The seed value for the second accumulator.</param>
        /// <param name="accumulator2">The second accumulator.</param>
        /// <param name="seed3">The seed value for the third accumulator.</param>
        /// <param name="accumulator3">The third accumulator.</param>
        /// <param name="resultSelector">
        /// A function that projects a single result given the result of each
        /// accumulator.</param>
        /// <returns>The value returned by <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TResult Aggregate<T, TAccumulate1, TAccumulate2, TAccumulate3, TResult>(
            this IEnumerable<T> source,
            TAccumulate1 seed1, Func<TAccumulate1, T, TAccumulate1> accumulator1,
            TAccumulate2 seed2, Func<TAccumulate2, T, TAccumulate2> accumulator2,
            TAccumulate3 seed3, Func<TAccumulate3, T, TAccumulate3> accumulator3,
            Func<TAccumulate1, TAccumulate2, TAccumulate3, TResult> resultSelector)
            => MoreEnumerable.Aggregate(source, seed1, accumulator1, seed2, accumulator2, seed3, accumulator3, resultSelector);
        /// <summary>
        /// Applies four accumulators sequentially in a single pass over a
        /// sequence.
        /// </summary>
        /// <typeparam name="T">The type of elements in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TAccumulate1">The type of first accumulator value.</typeparam>
        /// <typeparam name="TAccumulate2">The type of second accumulator value.</typeparam>
        /// <typeparam name="TAccumulate3">The type of third accumulator value.</typeparam>
        /// <typeparam name="TAccumulate4">The type of fourth accumulator value.</typeparam>
        /// <typeparam name="TResult">The type of the accumulated result.</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="seed1">The seed value for the first accumulator.</param>
        /// <param name="accumulator1">The first accumulator.</param>
        /// <param name="seed2">The seed value for the second accumulator.</param>
        /// <param name="accumulator2">The second accumulator.</param>
        /// <param name="seed3">The seed value for the third accumulator.</param>
        /// <param name="accumulator3">The third accumulator.</param>
        /// <param name="seed4">The seed value for the fourth accumulator.</param>
        /// <param name="accumulator4">The fourth accumulator.</param>
        /// <param name="resultSelector">
        /// A function that projects a single result given the result of each
        /// accumulator.</param>
        /// <returns>The value returned by <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TResult Aggregate<T, TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TResult>(
            this IEnumerable<T> source,
            TAccumulate1 seed1, Func<TAccumulate1, T, TAccumulate1> accumulator1,
            TAccumulate2 seed2, Func<TAccumulate2, T, TAccumulate2> accumulator2,
            TAccumulate3 seed3, Func<TAccumulate3, T, TAccumulate3> accumulator3,
            TAccumulate4 seed4, Func<TAccumulate4, T, TAccumulate4> accumulator4,
            Func<TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TResult> resultSelector)
            => MoreEnumerable.Aggregate(source, seed1, accumulator1, seed2, accumulator2, seed3, accumulator3, seed4, accumulator4, resultSelector);
        /// <summary>
        /// Applies five accumulators sequentially in a single pass over a
        /// sequence.
        /// </summary>
        /// <typeparam name="T">The type of elements in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TAccumulate1">The type of first accumulator value.</typeparam>
        /// <typeparam name="TAccumulate2">The type of second accumulator value.</typeparam>
        /// <typeparam name="TAccumulate3">The type of third accumulator value.</typeparam>
        /// <typeparam name="TAccumulate4">The type of fourth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate5">The type of fifth accumulator value.</typeparam>
        /// <typeparam name="TResult">The type of the accumulated result.</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="seed1">The seed value for the first accumulator.</param>
        /// <param name="accumulator1">The first accumulator.</param>
        /// <param name="seed2">The seed value for the second accumulator.</param>
        /// <param name="accumulator2">The second accumulator.</param>
        /// <param name="seed3">The seed value for the third accumulator.</param>
        /// <param name="accumulator3">The third accumulator.</param>
        /// <param name="seed4">The seed value for the fourth accumulator.</param>
        /// <param name="accumulator4">The fourth accumulator.</param>
        /// <param name="seed5">The seed value for the fifth accumulator.</param>
        /// <param name="accumulator5">The fifth accumulator.</param>
        /// <param name="resultSelector">
        /// A function that projects a single result given the result of each
        /// accumulator.</param>
        /// <returns>The value returned by <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TResult Aggregate<T, TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TAccumulate5, TResult>(
            this IEnumerable<T> source,
            TAccumulate1 seed1, Func<TAccumulate1, T, TAccumulate1> accumulator1,
            TAccumulate2 seed2, Func<TAccumulate2, T, TAccumulate2> accumulator2,
            TAccumulate3 seed3, Func<TAccumulate3, T, TAccumulate3> accumulator3,
            TAccumulate4 seed4, Func<TAccumulate4, T, TAccumulate4> accumulator4,
            TAccumulate5 seed5, Func<TAccumulate5, T, TAccumulate5> accumulator5,
            Func<TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TAccumulate5, TResult> resultSelector)
            => MoreEnumerable.Aggregate(source, seed1, accumulator1, seed2, accumulator2, seed3, accumulator3, seed4, accumulator4, seed5, accumulator5, resultSelector);
        /// <summary>
        /// Applies six accumulators sequentially in a single pass over a
        /// sequence.
        /// </summary>
        /// <typeparam name="T">The type of elements in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TAccumulate1">The type of first accumulator value.</typeparam>
        /// <typeparam name="TAccumulate2">The type of second accumulator value.</typeparam>
        /// <typeparam name="TAccumulate3">The type of third accumulator value.</typeparam>
        /// <typeparam name="TAccumulate4">The type of fourth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate5">The type of fifth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate6">The type of sixth accumulator value.</typeparam>
        /// <typeparam name="TResult">The type of the accumulated result.</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="seed1">The seed value for the first accumulator.</param>
        /// <param name="accumulator1">The first accumulator.</param>
        /// <param name="seed2">The seed value for the second accumulator.</param>
        /// <param name="accumulator2">The second accumulator.</param>
        /// <param name="seed3">The seed value for the third accumulator.</param>
        /// <param name="accumulator3">The third accumulator.</param>
        /// <param name="seed4">The seed value for the fourth accumulator.</param>
        /// <param name="accumulator4">The fourth accumulator.</param>
        /// <param name="seed5">The seed value for the fifth accumulator.</param>
        /// <param name="accumulator5">The fifth accumulator.</param>
        /// <param name="seed6">The seed value for the sixth accumulator.</param>
        /// <param name="accumulator6">The sixth accumulator.</param>
        /// <param name="resultSelector">
        /// A function that projects a single result given the result of each
        /// accumulator.</param>
        /// <returns>The value returned by <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TResult Aggregate<T, TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TAccumulate5, TAccumulate6, TResult>(
            this IEnumerable<T> source,
            TAccumulate1 seed1, Func<TAccumulate1, T, TAccumulate1> accumulator1,
            TAccumulate2 seed2, Func<TAccumulate2, T, TAccumulate2> accumulator2,
            TAccumulate3 seed3, Func<TAccumulate3, T, TAccumulate3> accumulator3,
            TAccumulate4 seed4, Func<TAccumulate4, T, TAccumulate4> accumulator4,
            TAccumulate5 seed5, Func<TAccumulate5, T, TAccumulate5> accumulator5,
            TAccumulate6 seed6, Func<TAccumulate6, T, TAccumulate6> accumulator6,
            Func<TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TAccumulate5, TAccumulate6, TResult> resultSelector)
            => MoreEnumerable.Aggregate(source, seed1, accumulator1, seed2, accumulator2, seed3, accumulator3, seed4, accumulator4, seed5, accumulator5, seed6, accumulator6, resultSelector);
        /// <summary>
        /// Applies seven accumulators sequentially in a single pass over a
        /// sequence.
        /// </summary>
        /// <typeparam name="T">The type of elements in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TAccumulate1">The type of first accumulator value.</typeparam>
        /// <typeparam name="TAccumulate2">The type of second accumulator value.</typeparam>
        /// <typeparam name="TAccumulate3">The type of third accumulator value.</typeparam>
        /// <typeparam name="TAccumulate4">The type of fourth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate5">The type of fifth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate6">The type of sixth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate7">The type of seventh accumulator value.</typeparam>
        /// <typeparam name="TResult">The type of the accumulated result.</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="seed1">The seed value for the first accumulator.</param>
        /// <param name="accumulator1">The first accumulator.</param>
        /// <param name="seed2">The seed value for the second accumulator.</param>
        /// <param name="accumulator2">The second accumulator.</param>
        /// <param name="seed3">The seed value for the third accumulator.</param>
        /// <param name="accumulator3">The third accumulator.</param>
        /// <param name="seed4">The seed value for the fourth accumulator.</param>
        /// <param name="accumulator4">The fourth accumulator.</param>
        /// <param name="seed5">The seed value for the fifth accumulator.</param>
        /// <param name="accumulator5">The fifth accumulator.</param>
        /// <param name="seed6">The seed value for the sixth accumulator.</param>
        /// <param name="accumulator6">The sixth accumulator.</param>
        /// <param name="seed7">The seed value for the seventh accumulator.</param>
        /// <param name="accumulator7">The seventh accumulator.</param>
        /// <param name="resultSelector">
        /// A function that projects a single result given the result of each
        /// accumulator.</param>
        /// <returns>The value returned by <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TResult Aggregate<T, TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TAccumulate5, TAccumulate6, TAccumulate7, TResult>(
            this IEnumerable<T> source,
            TAccumulate1 seed1, Func<TAccumulate1, T, TAccumulate1> accumulator1,
            TAccumulate2 seed2, Func<TAccumulate2, T, TAccumulate2> accumulator2,
            TAccumulate3 seed3, Func<TAccumulate3, T, TAccumulate3> accumulator3,
            TAccumulate4 seed4, Func<TAccumulate4, T, TAccumulate4> accumulator4,
            TAccumulate5 seed5, Func<TAccumulate5, T, TAccumulate5> accumulator5,
            TAccumulate6 seed6, Func<TAccumulate6, T, TAccumulate6> accumulator6,
            TAccumulate7 seed7, Func<TAccumulate7, T, TAccumulate7> accumulator7,
            Func<TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TAccumulate5, TAccumulate6, TAccumulate7, TResult> resultSelector)
            => MoreEnumerable.Aggregate(source, seed1, accumulator1, seed2, accumulator2, seed3, accumulator3, seed4, accumulator4, seed5, accumulator5, seed6, accumulator6, seed7, accumulator7, resultSelector);
        /// <summary>
        /// Applies eight accumulators sequentially in a single pass over a
        /// sequence.
        /// </summary>
        /// <typeparam name="T">The type of elements in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TAccumulate1">The type of first accumulator value.</typeparam>
        /// <typeparam name="TAccumulate2">The type of second accumulator value.</typeparam>
        /// <typeparam name="TAccumulate3">The type of third accumulator value.</typeparam>
        /// <typeparam name="TAccumulate4">The type of fourth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate5">The type of fifth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate6">The type of sixth accumulator value.</typeparam>
        /// <typeparam name="TAccumulate7">The type of seventh accumulator value.</typeparam>
        /// <typeparam name="TAccumulate8">The type of eighth accumulator value.</typeparam>
        /// <typeparam name="TResult">The type of the accumulated result.</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="seed1">The seed value for the first accumulator.</param>
        /// <param name="accumulator1">The first accumulator.</param>
        /// <param name="seed2">The seed value for the second accumulator.</param>
        /// <param name="accumulator2">The second accumulator.</param>
        /// <param name="seed3">The seed value for the third accumulator.</param>
        /// <param name="accumulator3">The third accumulator.</param>
        /// <param name="seed4">The seed value for the fourth accumulator.</param>
        /// <param name="accumulator4">The fourth accumulator.</param>
        /// <param name="seed5">The seed value for the fifth accumulator.</param>
        /// <param name="accumulator5">The fifth accumulator.</param>
        /// <param name="seed6">The seed value for the sixth accumulator.</param>
        /// <param name="accumulator6">The sixth accumulator.</param>
        /// <param name="seed7">The seed value for the seventh accumulator.</param>
        /// <param name="accumulator7">The seventh accumulator.</param>
        /// <param name="seed8">The seed value for the eighth accumulator.</param>
        /// <param name="accumulator8">The eighth accumulator.</param>
        /// <param name="resultSelector">
        /// A function that projects a single result given the result of each
        /// accumulator.</param>
        /// <returns>The value returned by <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TResult Aggregate<T, TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TAccumulate5, TAccumulate6, TAccumulate7, TAccumulate8, TResult>(
            this IEnumerable<T> source,
            TAccumulate1 seed1, Func<TAccumulate1, T, TAccumulate1> accumulator1,
            TAccumulate2 seed2, Func<TAccumulate2, T, TAccumulate2> accumulator2,
            TAccumulate3 seed3, Func<TAccumulate3, T, TAccumulate3> accumulator3,
            TAccumulate4 seed4, Func<TAccumulate4, T, TAccumulate4> accumulator4,
            TAccumulate5 seed5, Func<TAccumulate5, T, TAccumulate5> accumulator5,
            TAccumulate6 seed6, Func<TAccumulate6, T, TAccumulate6> accumulator6,
            TAccumulate7 seed7, Func<TAccumulate7, T, TAccumulate7> accumulator7,
            TAccumulate8 seed8, Func<TAccumulate8, T, TAccumulate8> accumulator8,
            Func<TAccumulate1, TAccumulate2, TAccumulate3, TAccumulate4, TAccumulate5, TAccumulate6, TAccumulate7, TAccumulate8, TResult> resultSelector)
            => MoreEnumerable.Aggregate(source, seed1, accumulator1, seed2, accumulator2, seed3, accumulator3, seed4, accumulator4, seed5, accumulator5, seed6, accumulator6, seed7, accumulator7, seed8, accumulator8, resultSelector);

    }

    /// <summary><c>AggregateRight</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class AggregateRightExtension
    {
        /// <summary>
        /// Applies a right-associative accumulator function over a sequence.
        /// This operator is the right-associative version of the
        /// <see cref="Enumerable.Aggregate{TSource}(IEnumerable{TSource}, Func{TSource, TSource, TSource})"/> LINQ operator.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of source.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="func">A right-associative accumulator function to be invoked on each element.</param>
        /// <returns>The final accumulator value.</returns>
        /// <example>
        /// <code><![CDATA[
        /// string result = Enumerable.Range(1, 5).Select(i => i.ToString()).AggregateRight((a, b) => string.Format("({0}/{1})", a, b));
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>"(1/(2/(3/(4/5))))"</c>.
        /// </example>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TSource AggregateRight<TSource>(this IEnumerable<TSource> source, Func<TSource, TSource, TSource> func)
            => MoreEnumerable.AggregateRight(source, func);

        /// <summary>
        /// Applies a right-associative accumulator function over a sequence.
        /// The specified seed value is used as the initial accumulator value.
        /// This operator is the right-associative version of the
        /// <see cref="Enumerable.Aggregate{TSource, TAccumulate}(IEnumerable{TSource}, TAccumulate, Func{TAccumulate, TSource, TAccumulate})"/> LINQ operator.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of source.</typeparam>
        /// <typeparam name="TAccumulate">The type of the accumulator value.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="seed">The initial accumulator value.</param>
        /// <param name="func">A right-associative accumulator function to be invoked on each element.</param>
        /// <returns>The final accumulator value.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = Enumerable.Range(1, 5);
        /// string result = numbers.AggregateRight("6", (a, b) => string.Format("({0}/{1})", a, b));
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>"(1/(2/(3/(4/(5/6)))))"</c>.
        /// </example>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TAccumulate AggregateRight<TSource, TAccumulate>(this IEnumerable<TSource> source, TAccumulate seed, Func<TSource, TAccumulate, TAccumulate> func)
            => MoreEnumerable.AggregateRight(source, seed, func);

        /// <summary>
        /// Applies a right-associative accumulator function over a sequence.
        /// The specified seed value is used as the initial accumulator value,
        /// and the specified function is used to select the result value.
        /// This operator is the right-associative version of the
        /// <see cref="Enumerable.Aggregate{TSource, TAccumulate, TResult}(IEnumerable{TSource}, TAccumulate, Func{TAccumulate, TSource, TAccumulate}, Func{TAccumulate, TResult})"/> LINQ operator.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of source.</typeparam>
        /// <typeparam name="TAccumulate">The type of the accumulator value.</typeparam>
        /// <typeparam name="TResult">The type of the resulting value.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="seed">The initial accumulator value.</param>
        /// <param name="func">A right-associative accumulator function to be invoked on each element.</param>
        /// <param name="resultSelector">A function to transform the final accumulator value into the result value.</param>
        /// <returns>The transformed final accumulator value.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = Enumerable.Range(1, 5);
        /// int result = numbers.AggregateRight("6", (a, b) => string.Format("({0}/{1})", a, b), str => str.Length);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>21</c>.
        /// </example>
        /// <remarks>
        /// This operator executes immediately.
        /// </remarks>

        public static TResult AggregateRight<TSource, TAccumulate, TResult>(this IEnumerable<TSource> source, TAccumulate seed, Func<TSource, TAccumulate, TAccumulate> func, Func<TAccumulate, TResult> resultSelector)
            => MoreEnumerable.AggregateRight(source, seed, func, resultSelector);

    }

    /// <summary><c>Append</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class AppendExtension
    {
        /// <summary>
        /// Returns a sequence consisting of the head elements and the given tail element.
        /// </summary>
        /// <typeparam name="T">Type of sequence</typeparam>
        /// <param name="head">All elements of the head. Must not be null.</param>
        /// <param name="tail">Tail element of the new sequence.</param>
        /// <returns>A sequence consisting of the head elements and the given tail element.</returns>
        /// <remarks>This operator uses deferred execution and streams its results.</remarks>

        public static IEnumerable<T> Append<T>(this IEnumerable<T> head, T tail)
            => MoreEnumerable.Append(head, tail);

    }

    /// <summary><c>Assert</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class AssertExtension
    {
        /// <summary>
        /// Asserts that all elements of a sequence meet a given condition
        /// otherwise throws an <see cref="Exception"/> object.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="predicate">Function that asserts an element of the <paramref name="source"/> sequence for a condition.</param>
        /// <returns>
        /// Returns the original sequence.
        /// </returns>
        /// <exception cref="InvalidOperationException">The input sequence
        /// contains an element that does not meet the condition being
        /// asserted.</exception>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TSource> Assert<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate)
            => MoreEnumerable.Assert(source, predicate);

        /// <summary>
        /// Asserts that all elements of a sequence meet a given condition
        /// otherwise throws an <see cref="Exception"/> object.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="predicate">Function that asserts an element of the input sequence for a condition.</param>
        /// <param name="errorSelector">Function that returns the <see cref="Exception"/> object to throw.</param>
        /// <returns>
        /// Returns the original sequence.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TSource> Assert<TSource>(this IEnumerable<TSource> source,
            Func<TSource, bool> predicate, Func<TSource, Exception> errorSelector)
            => MoreEnumerable.Assert(source, predicate, errorSelector);

    }

    /// <summary><c>AssertCount</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class AssertCountExtension
    {

        /// <summary>
        /// Asserts that a source sequence contains a given count of elements.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="count">Count to assert.</param>
        /// <returns>
        /// Returns the original sequence as long it is contains the
        /// number of elements specified by <paramref name="count"/>.
        /// Otherwise it throws <see cref="Exception" />.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TSource> AssertCount<TSource>(this IEnumerable<TSource> source, int count)             => MoreEnumerable.AssertCount(source, count);

        /// <summary>
        /// Asserts that a source sequence contains a given count of elements.
        /// A parameter specifies the exception to be thrown.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="count">Count to assert.</param>
        /// <param name="errorSelector">
        /// Function that receives a comparison (a negative integer if actual
        /// count is less than <paramref name="count"/> and a positive integer
        /// if actual count is greater than <paramref name="count"/>) and
        /// <paramref name="count"/> as arguments and which returns the
        /// <see cref="Exception"/> object to throw.</param>
        /// <returns>
        /// Returns the original sequence as long it is contains the
        /// number of elements specified by <paramref name="count"/>.
        /// Otherwise it throws the <see cref="Exception" /> object
        /// returned by calling <paramref name="errorSelector"/>.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TSource> AssertCount<TSource>(this IEnumerable<TSource> source,
            int count, Func<int, int, Exception> errorSelector)             => MoreEnumerable.AssertCount(source, count, errorSelector);

    }

    /// <summary><c>AtLeast</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class AtLeastExtension
    {
        /// <summary>
        /// Determines whether or not the number of elements in the sequence is greater than
        /// or equal to the given integer.
        /// </summary>
        /// <typeparam name="T">Element type of sequence</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="count">The minimum number of items a sequence must have for this
        /// function to return true</param>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentOutOfRangeException"><paramref name="count"/> is negative</exception>
        /// <returns><c>true</c> if the number of elements in the sequence is greater than
        /// or equal to the given integer or <c>false</c> otherwise.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 123, 456, 789 };
        /// var result = numbers.AtLeast(2);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>true</c>.
        /// </example>

        public static bool AtLeast<T>(this IEnumerable<T> source, int count)
            => MoreEnumerable.AtLeast(source, count);

    }

    /// <summary><c>AtMost</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class AtMostExtension
    {

        /// <summary>
        /// Determines whether or not the number of elements in the sequence is lesser than
        /// or equal to the given integer.
        /// </summary>
        /// <typeparam name="T">Element type of sequence</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="count">The maximun number of items a sequence must have for this
        /// function to return true</param>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentOutOfRangeException"><paramref name="count"/> is negative</exception>
        /// <returns><c>true</c> if the number of elements in the sequence is lesser than
        /// or equal to the given integer or <c>false</c> otherwise.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 123, 456, 789 };
        /// var result = numbers.AtMost(2);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>false</c>.
        /// </example>

        public static bool AtMost<T>(this IEnumerable<T> source, int count)
            => MoreEnumerable.AtMost(source, count);

    }

    /// <summary><c>Backsert</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class BacksertExtension
    {
        /// <summary>
        /// Inserts the elements of a sequence into another sequence at a
        /// specified index from the tail of the sequence, where zero always
        /// represents the last position, one represents the second-last
        /// element, two represents the third-last element and so on.
        /// </summary>
        /// <typeparam name="T">
        /// Type of elements in all sequences.</typeparam>
        /// <param name="first">The source sequence.</param>
        /// <param name="second">The sequence that will be inserted.</param>
        /// <param name="index">
        /// The zero-based index from the end of <paramref name="first"/> where
        /// elements from <paramref name="second"/> should be inserted.
        /// <paramref name="second"/>.</param>
        /// <returns>
        /// A sequence that contains the elements of <paramref name="first"/>
        /// plus the elements of <paramref name="second"/> inserted at
        /// the given index from the end of <paramref name="first"/>.
        /// </returns>
        /// <exception cref="ArgumentNullException"><paramref name="first"/> is null.</exception>
        /// <exception cref="ArgumentNullException"><paramref name="second"/> is null.</exception>
        /// <exception cref="ArgumentOutOfRangeException">
        /// Thrown if <paramref name="index"/> is negative.
        /// </exception>
        /// <exception cref="ArgumentOutOfRangeException">
        /// Thrown lazily if <paramref name="index"/> is greater than the
        /// length of <paramref name="first"/>. The validation occurs when
        /// the resulting sequence is iterated.
        /// </exception>
        /// <remarks>
        /// This method uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<T> Backsert<T>(this IEnumerable<T> first, IEnumerable<T> second, int index)
            => MoreEnumerable.Backsert(first, second, index);

    }

    /// <summary><c>Batch</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class BatchExtension
    {
        /// <summary>
        /// Batches the source sequence into sized buckets.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="size">Size of buckets.</param>
        /// <returns>A sequence of equally sized buckets containing elements of the source collection.</returns>
        /// <remarks>
        /// <para>
        /// This operator uses deferred execution and streams its results
        /// (buckets are streamed but their content buffered).</para>
        /// <para>
        /// When more than one bucket is streamed, all buckets except the last
        /// is guaranteed to have <paramref name="size"/> elements. The last
        /// bucket may be smaller depending on the remaining elements in the
        /// <paramref name="source"/> sequence.</para>
        /// <para>
        /// Each bucket is pre-allocated to <paramref name="size"/> elements.
        /// If <paramref name="size"/> is set to a very large value, e.g.
        /// <see cref="int.MaxValue"/> to effectively disable batching by just
        /// hoping for a single bucket, then it can lead to memory exhaustion
        /// (<see cref="OutOfMemoryException"/>).
        /// </para>
        /// </remarks>

        public static IEnumerable<IEnumerable<TSource>> Batch<TSource>(this IEnumerable<TSource> source, int size)
            => MoreEnumerable.Batch(source, size);

        /// <summary>
        /// Batches the source sequence into sized buckets and applies a projection to each bucket.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <typeparam name="TResult">Type of result returned by <paramref name="resultSelector"/>.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="size">Size of buckets.</param>
        /// <param name="resultSelector">The projection to apply to each bucket.</param>
        /// <returns>A sequence of projections on equally sized buckets containing elements of the source collection.</returns>
        /// <para>
        /// This operator uses deferred execution and streams its results
        /// (buckets are streamed but their content buffered).</para>
        /// <para>
        /// <para>
        /// When more than one bucket is streamed, all buckets except the last
        /// is guaranteed to have <paramref name="size"/> elements. The last
        /// bucket may be smaller depending on the remaining elements in the
        /// <paramref name="source"/> sequence.</para>
        /// Each bucket is pre-allocated to <paramref name="size"/> elements.
        /// If <paramref name="size"/> is set to a very large value, e.g.
        /// <see cref="int.MaxValue"/> to effectively disable batching by just
        /// hoping for a single bucket, then it can lead to memory exhaustion
        /// (<see cref="OutOfMemoryException"/>).
        /// </para>

        public static IEnumerable<TResult> Batch<TSource, TResult>(this IEnumerable<TSource> source, int size,
            Func<IEnumerable<TSource>, TResult> resultSelector)
            => MoreEnumerable.Batch(source, size, resultSelector);

    }

    /// <summary><c>Cartesian</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class CartesianExtension
    {
        /// <summary>
        /// Returns the Cartesian product of two sequences by enumerating all
        /// possible combinations of one item from each sequence, and applying
        /// a user-defined projection to the items in a given combination.
        /// </summary>
        /// <typeparam name="T1">
        /// The type of the elements of <paramref name="first"/>.</typeparam>
        /// <typeparam name="T2">
        /// The type of the elements of <paramref name="second"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the elements of the result sequence.</typeparam>
        /// <param name="first">The first sequence of elements.</param>
        /// <param name="second">The second sequence of elements.</param>
        /// <param name="resultSelector">A projection function that combines
        /// elements from all of the sequences.</param>
        /// <returns>A sequence of elements returned by
        /// <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// <para>
        /// The method returns items in the same order as a nested foreach
        /// loop, but all sequences except for <paramref name="first"/> are
        /// cached when iterated over. The cache is then re-used for any
        /// subsequent iterations.</para>
        /// <para>
        /// This method uses deferred execution and stream its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> Cartesian<T1, T2, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            Func<T1, T2, TResult> resultSelector)
            => MoreEnumerable.Cartesian(first, second, resultSelector);

        /// <summary>
        /// Returns the Cartesian product of three sequences by enumerating all
        /// possible combinations of one item from each sequence, and applying
        /// a user-defined projection to the items in a given combination.
        /// </summary>
        /// <typeparam name="T1">
        /// The type of the elements of <paramref name="first"/>.</typeparam>
        /// <typeparam name="T2">
        /// The type of the elements of <paramref name="second"/>.</typeparam>
        /// <typeparam name="T3">
        /// The type of the elements of <paramref name="third"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the elements of the result sequence.</typeparam>
        /// <param name="first">The first sequence of elements.</param>
        /// <param name="second">The second sequence of elements.</param>
        /// <param name="third">The third sequence of elements.</param>
        /// <param name="resultSelector">A projection function that combines
        /// elements from all of the sequences.</param>
        /// <returns>A sequence of elements returned by
        /// <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// <para>
        /// The method returns items in the same order as a nested foreach
        /// loop, but all sequences except for <paramref name="first"/> are
        /// cached when iterated over. The cache is then re-used for any
        /// subsequent iterations.</para>
        /// <para>
        /// This method uses deferred execution and stream its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> Cartesian<T1, T2, T3, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            Func<T1, T2, T3, TResult> resultSelector)
            => MoreEnumerable.Cartesian(first, second, third, resultSelector);

        /// <summary>
        /// Returns the Cartesian product of four sequences by enumerating all
        /// possible combinations of one item from each sequence, and applying
        /// a user-defined projection to the items in a given combination.
        /// </summary>
        /// <typeparam name="T1">
        /// The type of the elements of <paramref name="first"/>.</typeparam>
        /// <typeparam name="T2">
        /// The type of the elements of <paramref name="second"/>.</typeparam>
        /// <typeparam name="T3">
        /// The type of the elements of <paramref name="third"/>.</typeparam>
        /// <typeparam name="T4">
        /// The type of the elements of <paramref name="fourth"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the elements of the result sequence.</typeparam>
        /// <param name="first">The first sequence of elements.</param>
        /// <param name="second">The second sequence of elements.</param>
        /// <param name="third">The third sequence of elements.</param>
        /// <param name="fourth">The fourth sequence of elements.</param>
        /// <param name="resultSelector">A projection function that combines
        /// elements from all of the sequences.</param>
        /// <returns>A sequence of elements returned by
        /// <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// <para>
        /// The method returns items in the same order as a nested foreach
        /// loop, but all sequences except for <paramref name="first"/> are
        /// cached when iterated over. The cache is then re-used for any
        /// subsequent iterations.</para>
        /// <para>
        /// This method uses deferred execution and stream its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> Cartesian<T1, T2, T3, T4, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            IEnumerable<T4> fourth,
            Func<T1, T2, T3, T4, TResult> resultSelector)
            => MoreEnumerable.Cartesian(first, second, third, fourth, resultSelector);

        /// <summary>
        /// Returns the Cartesian product of five sequences by enumerating all
        /// possible combinations of one item from each sequence, and applying
        /// a user-defined projection to the items in a given combination.
        /// </summary>
        /// <typeparam name="T1">
        /// The type of the elements of <paramref name="first"/>.</typeparam>
        /// <typeparam name="T2">
        /// The type of the elements of <paramref name="second"/>.</typeparam>
        /// <typeparam name="T3">
        /// The type of the elements of <paramref name="third"/>.</typeparam>
        /// <typeparam name="T4">
        /// The type of the elements of <paramref name="fourth"/>.</typeparam>
        /// <typeparam name="T5">
        /// The type of the elements of <paramref name="fifth"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the elements of the result sequence.</typeparam>
        /// <param name="first">The first sequence of elements.</param>
        /// <param name="second">The second sequence of elements.</param>
        /// <param name="third">The third sequence of elements.</param>
        /// <param name="fourth">The fourth sequence of elements.</param>
        /// <param name="fifth">The fifth sequence of elements.</param>
        /// <param name="resultSelector">A projection function that combines
        /// elements from all of the sequences.</param>
        /// <returns>A sequence of elements returned by
        /// <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// <para>
        /// The method returns items in the same order as a nested foreach
        /// loop, but all sequences except for <paramref name="first"/> are
        /// cached when iterated over. The cache is then re-used for any
        /// subsequent iterations.</para>
        /// <para>
        /// This method uses deferred execution and stream its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> Cartesian<T1, T2, T3, T4, T5, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            IEnumerable<T4> fourth,
            IEnumerable<T5> fifth,
            Func<T1, T2, T3, T4, T5, TResult> resultSelector)
            => MoreEnumerable.Cartesian(first, second, third, fourth, fifth, resultSelector);

        /// <summary>
        /// Returns the Cartesian product of six sequences by enumerating all
        /// possible combinations of one item from each sequence, and applying
        /// a user-defined projection to the items in a given combination.
        /// </summary>
        /// <typeparam name="T1">
        /// The type of the elements of <paramref name="first"/>.</typeparam>
        /// <typeparam name="T2">
        /// The type of the elements of <paramref name="second"/>.</typeparam>
        /// <typeparam name="T3">
        /// The type of the elements of <paramref name="third"/>.</typeparam>
        /// <typeparam name="T4">
        /// The type of the elements of <paramref name="fourth"/>.</typeparam>
        /// <typeparam name="T5">
        /// The type of the elements of <paramref name="fifth"/>.</typeparam>
        /// <typeparam name="T6">
        /// The type of the elements of <paramref name="sixth"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the elements of the result sequence.</typeparam>
        /// <param name="first">The first sequence of elements.</param>
        /// <param name="second">The second sequence of elements.</param>
        /// <param name="third">The third sequence of elements.</param>
        /// <param name="fourth">The fourth sequence of elements.</param>
        /// <param name="fifth">The fifth sequence of elements.</param>
        /// <param name="sixth">The sixth sequence of elements.</param>
        /// <param name="resultSelector">A projection function that combines
        /// elements from all of the sequences.</param>
        /// <returns>A sequence of elements returned by
        /// <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// <para>
        /// The method returns items in the same order as a nested foreach
        /// loop, but all sequences except for <paramref name="first"/> are
        /// cached when iterated over. The cache is then re-used for any
        /// subsequent iterations.</para>
        /// <para>
        /// This method uses deferred execution and stream its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> Cartesian<T1, T2, T3, T4, T5, T6, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            IEnumerable<T4> fourth,
            IEnumerable<T5> fifth,
            IEnumerable<T6> sixth,
            Func<T1, T2, T3, T4, T5, T6, TResult> resultSelector)
            => MoreEnumerable.Cartesian(first, second, third, fourth, fifth, sixth, resultSelector);

        /// <summary>
        /// Returns the Cartesian product of seven sequences by enumerating all
        /// possible combinations of one item from each sequence, and applying
        /// a user-defined projection to the items in a given combination.
        /// </summary>
        /// <typeparam name="T1">
        /// The type of the elements of <paramref name="first"/>.</typeparam>
        /// <typeparam name="T2">
        /// The type of the elements of <paramref name="second"/>.</typeparam>
        /// <typeparam name="T3">
        /// The type of the elements of <paramref name="third"/>.</typeparam>
        /// <typeparam name="T4">
        /// The type of the elements of <paramref name="fourth"/>.</typeparam>
        /// <typeparam name="T5">
        /// The type of the elements of <paramref name="fifth"/>.</typeparam>
        /// <typeparam name="T6">
        /// The type of the elements of <paramref name="sixth"/>.</typeparam>
        /// <typeparam name="T7">
        /// The type of the elements of <paramref name="seventh"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the elements of the result sequence.</typeparam>
        /// <param name="first">The first sequence of elements.</param>
        /// <param name="second">The second sequence of elements.</param>
        /// <param name="third">The third sequence of elements.</param>
        /// <param name="fourth">The fourth sequence of elements.</param>
        /// <param name="fifth">The fifth sequence of elements.</param>
        /// <param name="sixth">The sixth sequence of elements.</param>
        /// <param name="seventh">The seventh sequence of elements.</param>
        /// <param name="resultSelector">A projection function that combines
        /// elements from all of the sequences.</param>
        /// <returns>A sequence of elements returned by
        /// <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// <para>
        /// The method returns items in the same order as a nested foreach
        /// loop, but all sequences except for <paramref name="first"/> are
        /// cached when iterated over. The cache is then re-used for any
        /// subsequent iterations.</para>
        /// <para>
        /// This method uses deferred execution and stream its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> Cartesian<T1, T2, T3, T4, T5, T6, T7, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            IEnumerable<T4> fourth,
            IEnumerable<T5> fifth,
            IEnumerable<T6> sixth,
            IEnumerable<T7> seventh,
            Func<T1, T2, T3, T4, T5, T6, T7, TResult> resultSelector)
            => MoreEnumerable.Cartesian(first, second, third, fourth, fifth, sixth, seventh, resultSelector);

        /// <summary>
        /// Returns the Cartesian product of eight sequences by enumerating all
        /// possible combinations of one item from each sequence, and applying
        /// a user-defined projection to the items in a given combination.
        /// </summary>
        /// <typeparam name="T1">
        /// The type of the elements of <paramref name="first"/>.</typeparam>
        /// <typeparam name="T2">
        /// The type of the elements of <paramref name="second"/>.</typeparam>
        /// <typeparam name="T3">
        /// The type of the elements of <paramref name="third"/>.</typeparam>
        /// <typeparam name="T4">
        /// The type of the elements of <paramref name="fourth"/>.</typeparam>
        /// <typeparam name="T5">
        /// The type of the elements of <paramref name="fifth"/>.</typeparam>
        /// <typeparam name="T6">
        /// The type of the elements of <paramref name="sixth"/>.</typeparam>
        /// <typeparam name="T7">
        /// The type of the elements of <paramref name="seventh"/>.</typeparam>
        /// <typeparam name="T8">
        /// The type of the elements of <paramref name="eighth"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the elements of the result sequence.</typeparam>
        /// <param name="first">The first sequence of elements.</param>
        /// <param name="second">The second sequence of elements.</param>
        /// <param name="third">The third sequence of elements.</param>
        /// <param name="fourth">The fourth sequence of elements.</param>
        /// <param name="fifth">The fifth sequence of elements.</param>
        /// <param name="sixth">The sixth sequence of elements.</param>
        /// <param name="seventh">The seventh sequence of elements.</param>
        /// <param name="eighth">The eighth sequence of elements.</param>
        /// <param name="resultSelector">A projection function that combines
        /// elements from all of the sequences.</param>
        /// <returns>A sequence of elements returned by
        /// <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// <para>
        /// The method returns items in the same order as a nested foreach
        /// loop, but all sequences except for <paramref name="first"/> are
        /// cached when iterated over. The cache is then re-used for any
        /// subsequent iterations.</para>
        /// <para>
        /// This method uses deferred execution and stream its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> Cartesian<T1, T2, T3, T4, T5, T6, T7, T8, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            IEnumerable<T4> fourth,
            IEnumerable<T5> fifth,
            IEnumerable<T6> sixth,
            IEnumerable<T7> seventh,
            IEnumerable<T8> eighth,
            Func<T1, T2, T3, T4, T5, T6, T7, T8, TResult> resultSelector)
            => MoreEnumerable.Cartesian(first, second, third, fourth, fifth, sixth, seventh, eighth, resultSelector);

    }

    /// <summary><c>Choose</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ChooseExtension
    {
        /// <summary>
        /// Applies a function to each element of the source sequence and
        /// returns a new sequence of result elements for source elements
        /// where the function returns a couple (2-tuple) having a <c>true</c>
        /// as its first element and result as the second.
        /// </summary>
        /// <typeparam name="T">
        /// The type of the elements in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the elements in the returned sequence.</typeparam>
        /// <param name="source"> The source sequence.</param>
        /// <param name="chooser">The function that is applied to each source
        /// element.</param>
        /// <returns>A sequence <typeparamref name="TResult"/> elements.</returns>
        /// <remarks>
        /// This method uses deferred execution semantics and streams its
        /// results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// var str = "O,l,2,3,4,S,6,7,B,9";
        /// var xs = str.Split(',').Choose(s => (int.TryParse(s, out var n), n));
        /// ]]></code>
        /// The <c>xs</c> variable will be a sequence of the integers 2, 3, 4,
        /// 6, 7 and 9.
        /// </example>

        public static IEnumerable<TResult> Choose<T, TResult>(this IEnumerable<T> source,
            Func<T, (bool, TResult)> chooser)
            => MoreEnumerable.Choose(source, chooser);

    }

    /// <summary><c>CompareCount</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class CompareCountExtension
    {

        /// <summary>
        /// Compares two sequences and returns an integer that indicates whether the first sequence
        /// has fewer, the same or more elements than the second sequence.
        /// </summary>
        /// <typeparam name="TFirst">Element type of the first sequence</typeparam>
        /// <typeparam name="TSecond">Element type of the second sequence</typeparam>
        /// <param name="first">The first sequence</param>
        /// <param name="second">The second sequence</param>
        /// <exception cref="ArgumentNullException"><paramref name="first"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="second"/> is null</exception>
        /// <returns><c>-1</c> if the first sequence has the fewest elements, <c>0</c> if the two sequences have the same number of elements
        /// or <c>1</c> if the first sequence has the most elements.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var first = new[] { 123, 456 };
        /// var second = new[] { 789 };
        /// var result = first.CompareCount(second);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>1</c>.
        /// </example>

        public static int CompareCount<TFirst, TSecond>(this IEnumerable<TFirst> first, IEnumerable<TSecond> second)
            => MoreEnumerable.CompareCount(first, second);

    }

    /// <summary><c>Consume</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ConsumeExtension
    {
        /// <summary>
        /// Completely consumes the given sequence. This method uses immediate execution,
        /// and doesn't store any data during execution.
        /// </summary>
        /// <typeparam name="T">Element type of the sequence</typeparam>
        /// <param name="source">Source to consume</param>

        public static void Consume<T>(this IEnumerable<T> source)
            => MoreEnumerable.Consume(source);

    }

    /// <summary><c>CountBetween</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class CountBetweenExtension
    {

        /// <summary>
        /// Determines whether or not the number of elements in the sequence is between
        /// an inclusive range of minimum and maximum integers.
        /// </summary>
        /// <typeparam name="T">Element type of sequence</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="min">The minimum number of items a sequence must have for this
        /// function to return true</param>
        /// <param name="max">The maximun number of items a sequence must have for this
        /// function to return true</param>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentOutOfRangeException"><paramref name="min"/> is negative or <paramref name="max"/> is less than min</exception>
        /// <returns><c>true</c> if the number of elements in the sequence is between (inclusive)
        /// the min and max given integers or <c>false</c> otherwise.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 123, 456, 789 };
        /// var result = numbers.CountBetween(1, 2);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>false</c>.
        /// </example>

        public static bool CountBetween<T>(this IEnumerable<T> source, int min, int max)
            => MoreEnumerable.CountBetween(source, min, max);

    }

    /// <summary><c>CountBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class CountByExtension
    {
        /// <summary>
        /// Applies a key-generating function to each element of a sequence and returns a sequence of
        /// unique keys and their number of occurrences in the original sequence.
        /// </summary>
        /// <typeparam name="TSource">Type of the elements of the source sequence.</typeparam>
        /// <typeparam name="TKey">Type of the projected element.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="keySelector">Function that transforms each item of source sequence into a key to be compared against the others.</param>
        /// <returns>A sequence of unique keys and their number of occurrences in the original sequence.</returns>

        public static IEnumerable<KeyValuePair<TKey, int>> CountBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector)
            => MoreEnumerable.CountBy(source, keySelector);

        /// <summary>
        /// Applies a key-generating function to each element of a sequence and returns a sequence of
        /// unique keys and their number of occurrences in the original sequence.
        /// An additional argument specifies a comparer to use for testing equivalence of keys.
        /// </summary>
        /// <typeparam name="TSource">Type of the elements of the source sequence.</typeparam>
        /// <typeparam name="TKey">Type of the projected element.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="keySelector">Function that transforms each item of source sequence into a key to be compared against the others.</param>
        /// <param name="comparer">The equality comparer to use to determine whether or not keys are equal.
        /// If null, the default equality comparer for <typeparamref name="TSource"/> is used.</param>
        /// <returns>A sequence of unique keys and their number of occurrences in the original sequence.</returns>

        public static IEnumerable<KeyValuePair<TKey, int>> CountBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer)
            => MoreEnumerable.CountBy(source, keySelector, comparer);

    }

    /// <summary><c>CountDown</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class CountDownExtension
    {
        /// <summary>
        /// Provides a countdown counter for a given count of elements at the
        /// tail of the sequence where zero always represents the last element,
        /// one represents the second-last element, two represents the
        /// third-last element and so on.
        /// </summary>
        /// <typeparam name="T">
        /// The type of elements of <paramref name="source"/></typeparam>
        /// <typeparam name="TResult">
        /// The type of elements of the resulting sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="count">Count of tail elements of
        /// <paramref name="source"/> to count down.</param>
        /// <param name="resultSelector">
        /// A function that receives the element and the current countdown
        /// value for the element and which returns those mapped to a
        /// result returned in the resulting sequence. For elements before
        /// the last <paramref name="count"/>, the coundown value is
        /// <c>null</c>.</param>
        /// <returns>
        /// A sequence of results returned by
        /// <paramref name="resultSelector"/>.</returns>
        /// <remarks>
        /// This method uses deferred execution semantics and streams its
        /// results. At most, <paramref name="count"/> elements of the source
        /// sequence may be buffered at any one time unless
        /// <paramref name="source"/> is a collection or a list.
        /// </remarks>

        public static IEnumerable<TResult> CountDown<T, TResult>(this IEnumerable<T> source,
            int count, Func<T, int?, TResult> resultSelector)
            => MoreEnumerable.CountDown(source, count, resultSelector);

    }

    /// <summary><c>DistinctBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class DistinctByExtension
    {
        /// <summary>
        /// Returns all distinct elements of the given source, where "distinctness"
        /// is determined via a projection and the default equality comparer for the projected type.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution and streams the results, although
        /// a set of already-seen keys is retained. If a key is seen multiple times,
        /// only the first element with that key is returned.
        /// </remarks>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <typeparam name="TKey">Type of the projected element</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="keySelector">Projection for determining "distinctness"</param>
        /// <returns>A sequence consisting of distinct elements from the source sequence,
        /// comparing them by the specified key projection.</returns>

        public static IEnumerable<TSource> DistinctBy<TSource, TKey>(this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector)
            => MoreEnumerable.DistinctBy(source, keySelector);

        /// <summary>
        /// Returns all distinct elements of the given source, where "distinctness"
        /// is determined via a projection and the specified comparer for the projected type.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution and streams the results, although
        /// a set of already-seen keys is retained. If a key is seen multiple times,
        /// only the first element with that key is returned.
        /// </remarks>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <typeparam name="TKey">Type of the projected element</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="keySelector">Projection for determining "distinctness"</param>
        /// <param name="comparer">The equality comparer to use to determine whether or not keys are equal.
        /// If null, the default equality comparer for <c>TSource</c> is used.</param>
        /// <returns>A sequence consisting of distinct elements from the source sequence,
        /// comparing them by the specified key projection.</returns>

        public static IEnumerable<TSource> DistinctBy<TSource, TKey>(this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer)
            => MoreEnumerable.DistinctBy(source, keySelector, comparer);

    }

    /// <summary><c>EndsWith</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class EndsWithExtension
    {
        /// <summary>
        /// Determines whether the end of the first sequence is equivalent to
        /// the second sequence, using the default equality comparer.
        /// </summary>
        /// <typeparam name="T">Type of elements.</typeparam>
        /// <param name="first">The sequence to check.</param>
        /// <param name="second">The sequence to compare to.</param>
        /// <returns>
        /// <c>true</c> if <paramref name="first" /> ends with elements
        /// equivalent to <paramref name="second" />.
        /// </returns>
        /// <remarks>
        /// This is the <see cref="IEnumerable{T}" /> equivalent of
        /// <see cref="string.EndsWith(string)" /> and
        /// it calls <see cref="IEqualityComparer{T}.Equals(T,T)" /> using
        /// <see cref="EqualityComparer{T}.Default" /> on pairs of elements at
        /// the same index.
        /// </remarks>

        public static bool EndsWith<T>(this IEnumerable<T> first, IEnumerable<T> second)
            => MoreEnumerable.EndsWith(first, second);

        /// <summary>
        /// Determines whether the end of the first sequence is equivalent to
        /// the second sequence, using the specified element equality comparer.
        /// </summary>
        /// <typeparam name="T">Type of elements.</typeparam>
        /// <param name="first">The sequence to check.</param>
        /// <param name="second">The sequence to compare to.</param>
        /// <param name="comparer">Equality comparer to use.</param>
        /// <returns>
        /// <c>true</c> if <paramref name="first" /> ends with elements
        /// equivalent to <paramref name="second" />.
        /// </returns>
        /// <remarks>
        /// This is the <see cref="IEnumerable{T}" /> equivalent of
        /// <see cref="string.EndsWith(string)" /> and it calls
        /// <see cref="IEqualityComparer{T}.Equals(T,T)" /> on pairs of
        /// elements at the same index.
        /// </remarks>

        public static bool EndsWith<T>(this IEnumerable<T> first, IEnumerable<T> second, IEqualityComparer<T> comparer)
            => MoreEnumerable.EndsWith(first, second, comparer);

    }

    /// <summary><c>EquiZip</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class EquiZipExtension
    {
        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. An exception is thrown
        /// if the input sequences are of different lengths.
        /// </summary>
        /// <typeparam name="TFirst">Type of elements in first sequence.</typeparam>
        /// <typeparam name="TSecond">Type of elements in second sequence.</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence.</typeparam>
        /// <param name="first">The first sequence.</param>
        /// <param name="second">The second sequence.</param>
        /// <param name="resultSelector">
        /// Function to apply to each pair of elements.</param>
        /// <returns>
        /// A sequence that contains elements of the two input sequences,
        /// combined by <paramref name="resultSelector"/>.
        /// </returns>
        /// <exception cref="InvalidOperationException">
        /// The input sequences are of different lengths.
        /// </exception>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 1, 2, 3, 4 };
        /// var letters = new[] { "A", "B", "C", "D" };
        /// var zipped  = numbers.EquiZip(letters, (n, l) => n + l);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield "1A",
        /// "2B", "3C", "4D" in turn.
        /// </example>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TResult> EquiZip<TFirst, TSecond, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TSecond, TResult> resultSelector)
            => MoreEnumerable.EquiZip(first, second, resultSelector);

        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. An exception is thrown
        /// if the input sequences are of different lengths.
        /// </summary>
        /// <typeparam name="T1">Type of elements in first sequence.</typeparam>
        /// <typeparam name="T2">Type of elements in second sequence.</typeparam>
        /// <typeparam name="T3">Type of elements in third sequence.</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence.</typeparam>
        /// <param name="first">The first sequence.</param>
        /// <param name="second">The second sequence.</param>
        /// <param name="third">The third sequence.</param>
        /// <param name="resultSelector">
        /// Function to apply to each triplet of elements.</param>
        /// <returns>
        /// A sequence that contains elements of the three input sequences,
        /// combined by <paramref name="resultSelector"/>.
        /// </returns>
        /// <exception cref="InvalidOperationException">
        /// The input sequences are of different lengths.
        /// </exception>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 1, 2, 3, 4 };
        /// var letters = new[] { "A", "B", "C", "D" };
        /// var chars   = new[] { 'a', 'b', 'c', 'd' };
        /// var zipped  = numbers.EquiZip(letters, chars, (n, l, c) => n + l + c);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield "1Aa",
        /// "2Bb", "3Cc", "4Dd" in turn.
        /// </example>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TResult> EquiZip<T1, T2, T3, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second, IEnumerable<T3> third,
            Func<T1, T2, T3, TResult> resultSelector)
            => MoreEnumerable.EquiZip(first, second, third, resultSelector);

        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. An exception is thrown
        /// if the input sequences are of different lengths.
        /// </summary>
        /// <typeparam name="T1">Type of elements in first sequence</typeparam>
        /// <typeparam name="T2">Type of elements in second sequence</typeparam>
        /// <typeparam name="T3">Type of elements in third sequence</typeparam>
        /// <typeparam name="T4">Type of elements in fourth sequence</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence</typeparam>
        /// <param name="first">The first sequence.</param>
        /// <param name="second">The second sequence.</param>
        /// <param name="third">The third sequence.</param>
        /// <param name="fourth">The fourth sequence.</param>
        /// <param name="resultSelector">
        /// Function to apply to each quadruplet of elements.</param>
        /// <returns>
        /// A sequence that contains elements of the four input sequences,
        /// combined by <paramref name="resultSelector"/>.
        /// </returns>
        /// <exception cref="InvalidOperationException">
        /// The input sequences are of different lengths.
        /// </exception>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 1, 2, 3, 4 };
        /// var letters = new[] { "A", "B", "C", "D" };
        /// var chars   = new[] { 'a', 'b', 'c', 'd' };
        /// var flags   = new[] { true, false, true, false };
        /// var zipped = numbers.EquiZip(letters, chars, flags, (n, l, c, f) => n + l + c + f);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield "1AaTrue",
        /// "2BbFalse", "3CcTrue", "4DdFalse" in turn.
        /// </example>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TResult> EquiZip<T1, T2, T3, T4, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second, IEnumerable<T3> third, IEnumerable<T4> fourth,
            Func<T1, T2, T3, T4, TResult> resultSelector)
            => MoreEnumerable.EquiZip(first, second, third, fourth, resultSelector);

    }

    /// <summary><c>Evaluate</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class EvaluateExtension
    {
        /// <summary>
        /// Returns a sequence containing the values resulting from invoking (in order) each function in the source sequence of functions.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution and streams the results.
        /// If the resulting sequence is enumerated multiple times, the functions will be
        /// evaluated multiple times too.
        /// </remarks>
        /// <typeparam name="T">The type of the object returned by the functions.</typeparam>
        /// <param name="functions">The functions to evaluate.</param>
        /// <returns>A sequence with results from invoking <paramref name="functions"/>.</returns>
        /// <exception cref="ArgumentNullException">When <paramref name="functions"/> is <c>null</c>.</exception>

        public static IEnumerable<T> Evaluate<T>(this IEnumerable<Func<T>> functions)             => MoreEnumerable.Evaluate(functions);

    }

    /// <summary><c>Exactly</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ExactlyExtension
    {

        /// <summary>
        /// Determines whether or not the number of elements in the sequence is equals to the given integer.
        /// </summary>
        /// <typeparam name="T">Element type of sequence</typeparam>
        /// <param name="source">The source sequence</param>
        /// <param name="count">The exactly number of items a sequence must have for this
        /// function to return true</param>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentOutOfRangeException"><paramref name="count"/> is negative</exception>
        /// <returns><c>true</c> if the number of elements in the sequence is equals
        /// to the given integer or <c>false</c> otherwise.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 123, 456, 789 };
        /// var result = numbers.Exactly(3);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>true</c>.
        /// </example>

        public static bool Exactly<T>(this IEnumerable<T> source, int count)
            => MoreEnumerable.Exactly(source, count);

    }

    /// <summary><c>ExceptBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ExceptByExtension
    {
        /// <summary>
        /// Returns the set of elements in the first sequence which aren't
        /// in the second sequence, according to a given key selector.
        /// </summary>
        /// <remarks>
        /// This is a set operation; if multiple elements in <paramref name="first"/> have
        /// equal keys, only the first such element is returned.
        /// This operator uses deferred execution and streams the results, although
        /// a set of keys from <paramref name="second"/> is immediately selected and retained.
        /// </remarks>
        /// <typeparam name="TSource">The type of the elements in the input sequences.</typeparam>
        /// <typeparam name="TKey">The type of the key returned by <paramref name="keySelector"/>.</typeparam>
        /// <param name="first">The sequence of potentially included elements.</param>
        /// <param name="second">The sequence of elements whose keys may prevent elements in
        /// <paramref name="first"/> from being returned.</param>
        /// <param name="keySelector">The mapping from source element to key.</param>
        /// <returns>A sequence of elements from <paramref name="first"/> whose key was not also a key for
        /// any element in <paramref name="second"/>.</returns>

        public static IEnumerable<TSource> ExceptBy<TSource, TKey>(this IEnumerable<TSource> first,
            IEnumerable<TSource> second,
            Func<TSource, TKey> keySelector)
            => MoreEnumerable.ExceptBy(first, second, keySelector);

        /// <summary>
        /// Returns the set of elements in the first sequence which aren't
        /// in the second sequence, according to a given key selector.
        /// </summary>
        /// <remarks>
        /// This is a set operation; if multiple elements in <paramref name="first"/> have
        /// equal keys, only the first such element is returned.
        /// This operator uses deferred execution and streams the results, although
        /// a set of keys from <paramref name="second"/> is immediately selected and retained.
        /// </remarks>
        /// <typeparam name="TSource">The type of the elements in the input sequences.</typeparam>
        /// <typeparam name="TKey">The type of the key returned by <paramref name="keySelector"/>.</typeparam>
        /// <param name="first">The sequence of potentially included elements.</param>
        /// <param name="second">The sequence of elements whose keys may prevent elements in
        /// <paramref name="first"/> from being returned.</param>
        /// <param name="keySelector">The mapping from source element to key.</param>
        /// <param name="keyComparer">The equality comparer to use to determine whether or not keys are equal.
        /// If null, the default equality comparer for <c>TSource</c> is used.</param>
        /// <returns>A sequence of elements from <paramref name="first"/> whose key was not also a key for
        /// any element in <paramref name="second"/>.</returns>

        public static IEnumerable<TSource> ExceptBy<TSource, TKey>(this IEnumerable<TSource> first,
            IEnumerable<TSource> second,
            Func<TSource, TKey> keySelector,
            IEqualityComparer<TKey> keyComparer)
            => MoreEnumerable.ExceptBy(first, second, keySelector, keyComparer);

    }

    /// <summary><c>Exclude</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ExcludeExtension
    {
        /// <summary>
        /// Excludes a contiguous number of elements from a sequence starting
        /// at a given index.
        /// </summary>
        /// <typeparam name="T">The type of the elements of the sequence</typeparam>
        /// <param name="sequence">The sequence to exclude elements from</param>
        /// <param name="startIndex">The zero-based index at which to begin excluding elements</param>
        /// <param name="count">The number of elements to exclude</param>
        /// <returns>A sequence that excludes the specified portion of elements</returns>

        public static IEnumerable<T> Exclude<T>(this IEnumerable<T> sequence, int startIndex, int count)
            => MoreEnumerable.Exclude(sequence, startIndex, count);

    }

    /// <summary><c>FallbackIfEmpty</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FallbackIfEmptyExtension
    {
        /// <summary>
        /// Returns the elements of the specified sequence or the specified
        /// value in a singleton collection if the sequence is empty.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequences.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="fallback">The value to return in a singleton
        /// collection if <paramref name="source"/> is empty.</param>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> that contains <paramref name="fallback"/>
        /// if <paramref name="source"/> is empty; otherwise, <paramref name="source"/>.
        /// </returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 123, 456, 789 };
        /// var result = numbers.Where(x => x == 100).FallbackIfEmpty(-1).Single();
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>-1</c>.
        /// </example>

        public static IEnumerable<T> FallbackIfEmpty<T>(this IEnumerable<T> source, T fallback)
            => MoreEnumerable.FallbackIfEmpty(source, fallback);

        /// <summary>
        /// Returns the elements of a sequence, but if it is empty then
        /// returns an alternate sequence of values.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequences.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="fallback">The alternate sequence that is returned
        /// if <paramref name="source"/> is empty.</param>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> that containing fallback values
        /// if <paramref name="source"/> is empty; otherwise, <paramref name="source"/>.
        /// </returns>

        public static IEnumerable<T> FallbackIfEmpty<T>(this IEnumerable<T> source, IEnumerable<T> fallback)
            => MoreEnumerable.FallbackIfEmpty(source, fallback);

        /// <summary>
        /// Returns the elements of a sequence, but if it is empty then
        /// returns an alternate sequence from an array of values.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequences.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="fallback">The array that is returned as the alternate
        /// sequence if <paramref name="source"/> is empty.</param>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> that containing fallback values
        /// if <paramref name="source"/> is empty; otherwise, <paramref name="source"/>.
        /// </returns>

        public static IEnumerable<T> FallbackIfEmpty<T>(this IEnumerable<T> source, params T[] fallback)
            => MoreEnumerable.FallbackIfEmpty(source, fallback);

        /// <summary>
        /// Returns the elements of a sequence, but if it is empty then
        /// returns an alternate sequence of values.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequences.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="fallback1">First value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <param name="fallback2">Second value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> that containing fallback values
        /// if <paramref name="source"/> is empty; otherwise, <paramref name="source"/>.
        /// </returns>

        public static IEnumerable<T> FallbackIfEmpty<T>(this IEnumerable<T> source, T fallback1, T fallback2)
            => MoreEnumerable.FallbackIfEmpty(source, fallback1, fallback2);

        /// <summary>
        /// Returns the elements of a sequence, but if it is empty then
        /// returns an alternate sequence of values.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequences.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="fallback1">First value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <param name="fallback2">Second value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <param name="fallback3">Third value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> that containing fallback values
        /// if <paramref name="source"/> is empty; otherwise, <paramref name="source"/>.
        /// </returns>

        public static IEnumerable<T> FallbackIfEmpty<T>(this IEnumerable<T> source, T fallback1, T fallback2, T fallback3)
            => MoreEnumerable.FallbackIfEmpty(source, fallback1, fallback2, fallback3);

        /// <summary>
        /// Returns the elements of a sequence, but if it is empty then
        /// returns an alternate sequence of values.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequences.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="fallback1">First value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <param name="fallback2">Second value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <param name="fallback3">Third value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <param name="fallback4">Fourth value of the alternate sequence that
        /// is returned if <paramref name="source"/> is empty.</param>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> that containing fallback values
        /// if <paramref name="source"/> is empty; otherwise, <paramref name="source"/>.
        /// </returns>

        public static IEnumerable<T> FallbackIfEmpty<T>(this IEnumerable<T> source, T fallback1, T fallback2, T fallback3, T fallback4)
            => MoreEnumerable.FallbackIfEmpty(source, fallback1, fallback2, fallback3, fallback4);

    }

    /// <summary><c>FillBackward</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FillBackwardExtension
    {
        /// <summary>
        /// Returns a sequence with each null reference or value in the source
        /// replaced with the following non-null reference or value in
        /// that sequence.
        /// </summary>
        /// <param name="source">The source sequence.</param>
        /// <typeparam name="T">Type of the elements in the source sequence.</typeparam>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> with null references or values
        /// replaced.
        /// </returns>
        /// <remarks>
        /// This method uses deferred execution semantics and streams its
        /// results. If references or values are null at the end of the
        /// sequence then they remain null.
        /// </remarks>

        public static IEnumerable<T> FillBackward<T>(this IEnumerable<T> source)
            => MoreEnumerable.FillBackward(source);

        /// <summary>
        /// Returns a sequence with each missing element in the source replaced
        /// with the following non-missing element in that sequence. An
        /// additional parameter specifies a function used to determine if an
        /// element is considered missing or not.
        /// </summary>
        /// <param name="source">The source sequence.</param>
        /// <param name="predicate">The function used to determine if
        /// an element in the sequence is considered missing.</param>
        /// <typeparam name="T">Type of the elements in the source sequence.</typeparam>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> with missing values replaced.
        /// </returns>
        /// <remarks>
        /// This method uses deferred execution semantics and streams its
        /// results. If elements are missing at the end of the sequence then
        /// they remain missing.
        /// </remarks>

        public static IEnumerable<T> FillBackward<T>(this IEnumerable<T> source, Func<T, bool> predicate)
            => MoreEnumerable.FillBackward(source, predicate);

        /// <summary>
        /// Returns a sequence with each missing element in the source replaced
        /// with the following non-missing element in that sequence. Additional
        /// parameters specifiy two functions, one used to determine if an
        /// element is considered missing or not and another to provide the
        /// replacement for the missing element.
        /// </summary>
        /// <param name="source">The source sequence.</param>
        /// <param name="predicate">The function used to determine if
        /// an element in the sequence is considered missing.</param>
        /// <param name="fillSelector">The function used to produce the element
        /// that will replace the missing one. Its first argument receives the
        /// current element considered missing while the second argument
        /// receives the next non-missing element.</param>
        /// <typeparam name="T">Type of the elements in the source sequence.</typeparam>
        /// An <see cref="IEnumerable{T}"/> with missing values replaced.
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> with missing elements filled.
        /// </returns>
        /// <remarks>
        /// This method uses deferred execution semantics and streams its
        /// results. If elements are missing at the end of the sequence then
        /// they remain missing.
        /// </remarks>

        public static IEnumerable<T> FillBackward<T>(this IEnumerable<T> source, Func<T, bool> predicate, Func<T, T, T> fillSelector)
            => MoreEnumerable.FillBackward(source, predicate, fillSelector);

    }

    /// <summary><c>FillForward</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FillForwardExtension
    {
        /// <summary>
        /// Returns a sequence with each null reference or value in the source
        /// replaced with the previous non-null reference or value seen in
        /// that sequence.
        /// </summary>
        /// <param name="source">The source sequence.</param>
        /// <typeparam name="T">Type of the elements in the source sequence.</typeparam>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> with null references or values
        /// replaced.
        /// </returns>
        /// <remarks>
        /// This method uses deferred execution semantics and streams its
        /// results. If references or values are null at the start of the
        /// sequence then they remain null.
        /// </remarks>

        public static IEnumerable<T> FillForward<T>(this IEnumerable<T> source)
            => MoreEnumerable.FillForward(source);

        /// <summary>
        /// Returns a sequence with each missing element in the source replaced
        /// with the previous non-missing element seen in that sequence. An
        /// additional parameter specifies a function used to determine if an
        /// element is considered missing or not.
        /// </summary>
        /// <param name="source">The source sequence.</param>
        /// <param name="predicate">The function used to determine if
        /// an element in the sequence is considered missing.</param>
        /// <typeparam name="T">Type of the elements in the source sequence.</typeparam>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> with missing values replaced.
        /// </returns>
        /// <remarks>
        /// This method uses deferred execution semantics and streams its
        /// results. If elements are missing at the start of the sequence then
        /// they remain missing.
        /// </remarks>

        public static IEnumerable<T> FillForward<T>(this IEnumerable<T> source, Func<T, bool> predicate)
            => MoreEnumerable.FillForward(source, predicate);

        /// <summary>
        /// Returns a sequence with each missing element in the source replaced
        /// with one based on the previous non-missing element seen in that
        /// sequence. Additional parameters specifiy two functions, one used to
        /// determine if an element is considered missing or not and another
        /// to provide the replacement for the missing element.
        /// </summary>
        /// <param name="source">The source sequence.</param>
        /// <param name="predicate">The function used to determine if
        /// an element in the sequence is considered missing.</param>
        /// <param name="fillSelector">The function used to produce the element
        /// that will replace the missing one. Its first argument receives the
        /// current element considered missing while the second argument
        /// receives the previous non-missing element.</param>
        /// <typeparam name="T">Type of the elements in the source sequence.</typeparam>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> with missing values replaced.
        /// </returns>
        /// <remarks>
        /// This method uses deferred execution semantics and streams its
        /// results. If elements are missing at the start of the sequence then
        /// they remain missing.
        /// </remarks>

        public static IEnumerable<T> FillForward<T>(this IEnumerable<T> source, Func<T, bool> predicate, Func<T, T, T> fillSelector)
            => MoreEnumerable.FillForward(source, predicate, fillSelector);

    }

    /// <summary><c>First</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FirstExtension
    {
        /// <summary>
        /// Returns the first element of a sequence.
        /// </summary>
        /// <typeparam name="T">
        /// The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The input sequence.</param>
        /// <exception cref="InvalidOperationException">
        /// The input sequence is empty.</exception>
        /// <returns>
        /// The first element of the input sequence.
        /// </returns>

        public static T First<T>(this IExtremaEnumerable<T> source)
            => MoreEnumerable.First(source);

    }

    /// <summary><c>FirstOrDefault</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FirstOrDefaultExtension
    {

        /// <summary>
        /// Returns the first element of a sequence, or a default value if the
        /// sequence contains no elements.
        /// </summary>
        /// <typeparam name="T">
        /// The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The input sequence.</param>
        /// <returns>
        /// Default value of type <typeparamref name="T"/> if source is empty;
        /// otherwise, the first element in source.
        /// </returns>

        public static T FirstOrDefault<T>(this IExtremaEnumerable<T> source)
            => MoreEnumerable.FirstOrDefault(source);

    }

    /// <summary><c>Flatten</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FlattenExtension
    {
        /// <summary>
        /// Flattens a sequence containing arbitrarily-nested sequences.
        /// </summary>
        /// <param name="source">The sequence that will be flattened.</param>
        /// <returns>
        /// A sequence that contains the elements of <paramref name="source"/>
        /// and all nested sequences (except strings).
        /// </returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null.</exception>

        public static IEnumerable<object> Flatten(this IEnumerable source)             => MoreEnumerable.Flatten(source);

        /// <summary>
        /// Flattens a sequence containing arbitrarily-nested sequences. An
        /// additional parameter specifies a predicate function used to
        /// determine whether a nested <see cref="IEnumerable"/> should be
        /// flattened or not.
        /// </summary>
        /// <param name="source">The sequence that will be flattened.</param>
        /// <param name="predicate">
        /// A function that receives each element that implements
        /// <see cref="IEnumerable"/> and indicates if its elements should be
        /// recursively flattened into the resulting sequence.
        /// </param>
        /// <returns>
        /// A sequence that contains the elements of <paramref name="source"/>
        /// and all nested sequences for which the predicate function
        /// returned <c>true</c>.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> is <c>null</c>.</exception>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="predicate"/> is <c>null</c>.</exception>

        public static IEnumerable<object> Flatten(this IEnumerable source, Func<IEnumerable, bool> predicate)
            => MoreEnumerable.Flatten(source, predicate);

        /// <summary>
        /// Flattens a sequence containing arbitrarily-nested sequences. An
        /// additional parameter specifies a function that projects an inner
        /// sequence via a property of an object.
        /// </summary>
        /// <param name="source">The sequence that will be flattened.</param>
        /// <param name="selector">
        /// A function that receives each element of the sequence as an object
        /// and projects an inner sequence to be flattened. If the function
        /// returns <c>null</c> then the object argument is considered a leaf
        /// of the flattening process.
        /// </param>
        /// <returns>
        /// A sequence that contains the elements of <paramref name="source"/>
        /// and all nested sequences projected via the
        /// <paramref name="selector"/> function.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> is <c>null</c>.</exception>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="selector"/> is <c>null</c>.</exception>

        public static IEnumerable<object> Flatten(this IEnumerable source, Func<object, IEnumerable> selector)
            => MoreEnumerable.Flatten(source, selector);

    }

    /// <summary><c>Fold</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FoldExtension
    {
        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 1 element.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 1 element</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 2 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 2 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 3 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 3 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 4 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 4 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 5 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 5 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 6 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 6 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 7 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 7 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 8 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 8 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 9 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 9 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 10 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 10 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 11 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 11 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 12 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 12 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 13 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 13 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 14 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 14 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 15 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 15 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

        /// <summary>
        /// Returns the result of applying a function to a sequence of
        /// 16 elements.
        /// </summary>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers
        /// as many items of the source sequence as necessary.
        /// </remarks>
        /// <typeparam name="T">Type of element in the source sequence</typeparam>
        /// <typeparam name="TResult">Type of the result</typeparam>
        /// <param name="source">The sequence of items to fold.</param>
        /// <param name="folder">Function to apply to the elements in the sequence.</param>
        /// <returns>The folded value returned by <paramref name="folder"/>.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <exception cref="ArgumentNullException"><paramref name="folder"/> is null</exception>
        /// <exception cref="InvalidOperationException"><paramref name="source"/> does not contain exactly 16 elements</exception>

        public static TResult Fold<T, TResult>(this IEnumerable<T> source, Func<T, T, T, T, T, T, T, T, T, T, T, T, T, T, T, T, TResult> folder)
            => MoreEnumerable.Fold(source, folder);

    }

    /// <summary><c>ForEach</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ForEachExtension
    {
        /// <summary>
        /// Immediately executes the given action on each element in the source sequence.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="source">The sequence of elements</param>
        /// <param name="action">The action to execute on each element</param>

        public static void ForEach<T>(this IEnumerable<T> source, Action<T> action)
            => MoreEnumerable.ForEach(source, action);

        /// <summary>
        /// Immediately executes the given action on each element in the source sequence.
        /// Each element's index is used in the logic of the action.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="source">The sequence of elements</param>
        /// <param name="action">The action to execute on each element; the second parameter
        /// of the action represents the index of the source element.</param>

        public static void ForEach<T>(this IEnumerable<T> source, Action<T, int> action)
            => MoreEnumerable.ForEach(source, action);

    }

    /// <summary><c>FullGroupJoin</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FullGroupJoinExtension
    {
        /// <summary>
        /// Performs a Full Group Join between the <paramref name="first"/> and <paramref name="second"/> sequences.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution and streams the results.
        /// The results are yielded in the order of the elements found in the first sequence
        /// followed by those found only in the second. In addition, the callback responsible
        /// for projecting the results is supplied with sequences which preserve their source order.
        /// </remarks>
        /// <typeparam name="TFirst">The type of the elements in the first input sequence</typeparam>
        /// <typeparam name="TSecond">The type of the elements in the second input sequence</typeparam>
        /// <typeparam name="TKey">The type of the key to use to join</typeparam>
        /// <param name="first">First sequence</param>
        /// <param name="second">Second sequence</param>
        /// <param name="firstKeySelector">The mapping from first sequence to key</param>
        /// <param name="secondKeySelector">The mapping from second sequence to key</param>
        /// <returns>A sequence of elements joined from <paramref name="first"/> and <paramref name="second"/>.
        /// </returns>

        public static IEnumerable<(TKey Key, IEnumerable<TFirst> First, IEnumerable<TSecond> Second)> FullGroupJoin<TFirst, TSecond, TKey>(this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector)
            => MoreEnumerable.FullGroupJoin(first, second, firstKeySelector, secondKeySelector);

        /// <summary>
        /// Performs a Full Group Join between the <paramref name="first"/> and <paramref name="second"/> sequences.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution and streams the results.
        /// The results are yielded in the order of the elements found in the first sequence
        /// followed by those found only in the second. In addition, the callback responsible
        /// for projecting the results is supplied with sequences which preserve their source order.
        /// </remarks>
        /// <typeparam name="TFirst">The type of the elements in the first input sequence</typeparam>
        /// <typeparam name="TSecond">The type of the elements in the second input sequence</typeparam>
        /// <typeparam name="TKey">The type of the key to use to join</typeparam>
        /// <param name="first">First sequence</param>
        /// <param name="second">Second sequence</param>
        /// <param name="firstKeySelector">The mapping from first sequence to key</param>
        /// <param name="secondKeySelector">The mapping from second sequence to key</param>
        /// <param name="comparer">The equality comparer to use to determine whether or not keys are equal.
        /// If null, the default equality comparer for <c>TKey</c> is used.</param>
        /// <returns>A sequence of elements joined from <paramref name="first"/> and <paramref name="second"/>.
        /// </returns>

        public static IEnumerable<(TKey Key, IEnumerable<TFirst> First, IEnumerable<TSecond> Second)> FullGroupJoin<TFirst, TSecond, TKey>(this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.FullGroupJoin(first, second, firstKeySelector, secondKeySelector, comparer);

        /// <summary>
        /// Performs a full group-join between two sequences.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution and streams the results.
        /// The results are yielded in the order of the elements found in the first sequence
        /// followed by those found only in the second. In addition, the callback responsible
        /// for projecting the results is supplied with sequences which preserve their source order.
        /// </remarks>
        /// <typeparam name="TFirst">The type of the elements in the first input sequence</typeparam>
        /// <typeparam name="TSecond">The type of the elements in the second input sequence</typeparam>
        /// <typeparam name="TKey">The type of the key to use to join</typeparam>
        /// <typeparam name="TResult">The type of the elements of the resulting sequence</typeparam>
        /// <param name="first">First sequence</param>
        /// <param name="second">Second sequence</param>
        /// <param name="firstKeySelector">The mapping from first sequence to key</param>
        /// <param name="secondKeySelector">The mapping from second sequence to key</param>
        /// <param name="resultSelector">Function to apply to each pair of elements plus the key</param>
        /// <returns>A sequence of elements joined from <paramref name="first"/> and <paramref name="second"/>.
        /// </returns>

        public static IEnumerable<TResult> FullGroupJoin<TFirst, TSecond, TKey, TResult>(this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TKey, IEnumerable<TFirst>, IEnumerable<TSecond>, TResult> resultSelector)
            => MoreEnumerable.FullGroupJoin(first, second, firstKeySelector, secondKeySelector, resultSelector);

        /// <summary>
        /// Performs a full group-join between two sequences.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution and streams the results.
        /// The results are yielded in the order of the elements found in the first sequence
        /// followed by those found only in the second. In addition, the callback responsible
        /// for projecting the results is supplied with sequences which preserve their source order.
        /// </remarks>
        /// <typeparam name="TFirst">The type of the elements in the first input sequence</typeparam>
        /// <typeparam name="TSecond">The type of the elements in the second input sequence</typeparam>
        /// <typeparam name="TKey">The type of the key to use to join</typeparam>
        /// <typeparam name="TResult">The type of the elements of the resulting sequence</typeparam>
        /// <param name="first">First sequence</param>
        /// <param name="second">Second sequence</param>
        /// <param name="firstKeySelector">The mapping from first sequence to key</param>
        /// <param name="secondKeySelector">The mapping from second sequence to key</param>
        /// <param name="resultSelector">Function to apply to each pair of elements plus the key</param>
        /// <param name="comparer">The equality comparer to use to determine whether or not keys are equal.
        /// If null, the default equality comparer for <c>TKey</c> is used.</param>
        /// <returns>A sequence of elements joined from <paramref name="first"/> and <paramref name="second"/>.
        /// </returns>

        public static IEnumerable<TResult> FullGroupJoin<TFirst, TSecond, TKey, TResult>(this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TKey, IEnumerable<TFirst>, IEnumerable<TSecond>, TResult> resultSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.FullGroupJoin(first, second, firstKeySelector, secondKeySelector, resultSelector, comparer);

    }

    /// <summary><c>FullJoin</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class FullJoinExtension
    {
        /// <summary>
        /// Performs a full outer join on two homogeneous sequences.
        /// Additional arguments specify key selection functions and result
        /// projection functions.
        /// </summary>
        /// <typeparam name="TSource">
        /// The type of elements in the source sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector function.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence to join fully.</param>
        /// <param name="second">
        /// The second sequence to join fully.</param>
        /// <param name="keySelector">
        /// Function that projects the key given an element of one of the
        /// sequences to join.</param>
        /// <param name="firstSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="first"/> where there is no corresponding element
        /// in <paramref name="second"/>.</param>
        /// <param name="secondSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="second"/> where there is no corresponding element
        /// in <paramref name="first"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <returns>A sequence containing results projected from a full
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> FullJoin<TSource, TKey, TResult>(
            this IEnumerable<TSource> first,
            IEnumerable<TSource> second,
            Func<TSource, TKey> keySelector,
            Func<TSource, TResult> firstSelector,
            Func<TSource, TResult> secondSelector,
            Func<TSource, TSource, TResult> bothSelector)
            => MoreEnumerable.FullJoin(first, second, keySelector, firstSelector, secondSelector, bothSelector);

        /// <summary>
        /// Performs a full outer join on two homogeneous sequences.
        /// Additional arguments specify key selection functions, result
        /// projection functions and a key comparer.
        /// </summary>
        /// <typeparam name="TSource">
        /// The type of elements in the source sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector function.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence to join fully.</param>
        /// <param name="second">
        /// The second sequence to join fully.</param>
        /// <param name="keySelector">
        /// Function that projects the key given an element of one of the
        /// sequences to join.</param>
        /// <param name="firstSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="first"/> where there is no corresponding element
        /// in <paramref name="second"/>.</param>
        /// <param name="secondSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="second"/> where there is no corresponding element
        /// in <paramref name="first"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <param name="comparer">
        /// The <see cref="IEqualityComparer{T}"/> instance used to compare
        /// keys for equality.</param>
        /// <returns>A sequence containing results projected from a full
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> FullJoin<TSource, TKey, TResult>(
            this IEnumerable<TSource> first,
            IEnumerable<TSource> second,
            Func<TSource, TKey> keySelector,
            Func<TSource, TResult> firstSelector,
            Func<TSource, TResult> secondSelector,
            Func<TSource, TSource, TResult> bothSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.FullJoin(first, second, keySelector, firstSelector, secondSelector, bothSelector, comparer);

        /// <summary>
        /// Performs a full outer join on two heterogeneous sequences.
        /// Additional arguments specify key selection functions and result
        /// projection functions.
        /// </summary>
        /// <typeparam name="TFirst">
        /// The type of elements in the first sequence.</typeparam>
        /// <typeparam name="TSecond">
        /// The type of elements in the second sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector functions.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence to join fully.</param>
        /// <param name="second">
        /// The second sequence to join fully.</param>
        /// <param name="firstKeySelector">
        /// Function that projects the key given an element from <paramref name="first"/>.</param>
        /// <param name="secondKeySelector">
        /// Function that projects the key given an element from <paramref name="second"/>.</param>
        /// <param name="firstSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="first"/> where there is no corresponding element
        /// in <paramref name="second"/>.</param>
        /// <param name="secondSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="second"/> where there is no corresponding element
        /// in <paramref name="first"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <returns>A sequence containing results projected from a full
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> FullJoin<TFirst, TSecond, TKey, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TFirst, TResult> firstSelector,
            Func<TSecond, TResult> secondSelector,
            Func<TFirst, TSecond, TResult> bothSelector)             => MoreEnumerable.FullJoin(first, second, firstKeySelector, secondKeySelector, firstSelector, secondSelector, bothSelector);

        /// <summary>
        /// Performs a full outer join on two heterogeneous sequences.
        /// Additional arguments specify key selection functions, result
        /// projection functions and a key comparer.
        /// </summary>
        /// <typeparam name="TFirst">
        /// The type of elements in the first sequence.</typeparam>
        /// <typeparam name="TSecond">
        /// The type of elements in the second sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector functions.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence to join fully.</param>
        /// <param name="second">
        /// The second sequence to join fully.</param>
        /// <param name="firstKeySelector">
        /// Function that projects the key given an element from <paramref name="first"/>.</param>
        /// <param name="secondKeySelector">
        /// Function that projects the key given an element from <paramref name="second"/>.</param>
        /// <param name="firstSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="first"/> where there is no corresponding element
        /// in <paramref name="second"/>.</param>
        /// <param name="secondSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="second"/> where there is no corresponding element
        /// in <paramref name="first"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <param name="comparer">
        /// The <see cref="IEqualityComparer{T}"/> instance used to compare
        /// keys for equality.</param>
        /// <returns>A sequence containing results projected from a full
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> FullJoin<TFirst, TSecond, TKey, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TFirst, TResult> firstSelector,
            Func<TSecond, TResult> secondSelector,
            Func<TFirst, TSecond, TResult> bothSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.FullJoin(first, second, firstKeySelector, secondKeySelector, firstSelector, secondSelector, bothSelector, comparer);

    }

    /// <summary><c>GroupAdjacent</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class GroupAdjacentExtension
    {
        /// <summary>
        /// Groups the adjacent elements of a sequence according to a
        /// specified key selector function.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of
        /// <paramref name="source"/>.</typeparam>
        /// <typeparam name="TKey">The type of the key returned by
        /// <paramref name="keySelector"/>.</typeparam>
        /// <param name="source">A sequence whose elements to group.</param>
        /// <param name="keySelector">A function to extract the key for each
        /// element.</param>
        /// <returns>A sequence of groupings where each grouping
        /// (<see cref="IGrouping{TKey,TElement}"/>) contains the key
        /// and the adjacent elements in the same order as found in the
        /// source sequence.</returns>
        /// <remarks>
        /// This method is implemented by using deferred execution and
        /// streams the groupings. The grouping elements, however, are
        /// buffered. Each grouping is therefore yielded as soon as it
        /// is complete and before the next grouping occurs.
        /// </remarks>

        public static IEnumerable<IGrouping<TKey, TSource>> GroupAdjacent<TSource, TKey>(
            this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector)
            => MoreEnumerable.GroupAdjacent(source, keySelector);

        /// <summary>
        /// Groups the adjacent elements of a sequence according to a
        /// specified key selector function and compares the keys by using a
        /// specified comparer.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of
        /// <paramref name="source"/>.</typeparam>
        /// <typeparam name="TKey">The type of the key returned by
        /// <paramref name="keySelector"/>.</typeparam>
        /// <param name="source">A sequence whose elements to group.</param>
        /// <param name="keySelector">A function to extract the key for each
        /// element.</param>
        /// <param name="comparer">An <see cref="IEqualityComparer{T}"/> to
        /// compare keys.</param>
        /// <returns>A sequence of groupings where each grouping
        /// (<see cref="IGrouping{TKey,TElement}"/>) contains the key
        /// and the adjacent elements in the same order as found in the
        /// source sequence.</returns>
        /// <remarks>
        /// This method is implemented by using deferred execution and
        /// streams the groupings. The grouping elements, however, are
        /// buffered. Each grouping is therefore yielded as soon as it
        /// is complete and before the next grouping occurs.
        /// </remarks>

        public static IEnumerable<IGrouping<TKey, TSource>> GroupAdjacent<TSource, TKey>(
            this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.GroupAdjacent(source, keySelector, comparer);

        /// <summary>
        /// Groups the adjacent elements of a sequence according to a
        /// specified key selector function and projects the elements for
        /// each group by using a specified function.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of
        /// <paramref name="source"/>.</typeparam>
        /// <typeparam name="TKey">The type of the key returned by
        /// <paramref name="keySelector"/>.</typeparam>
        /// <typeparam name="TElement">The type of the elements in the
        /// resulting groupings.</typeparam>
        /// <param name="source">A sequence whose elements to group.</param>
        /// <param name="keySelector">A function to extract the key for each
        /// element.</param>
        /// <param name="elementSelector">A function to map each source
        /// element to an element in the resulting grouping.</param>
        /// <returns>A sequence of groupings where each grouping
        /// (<see cref="IGrouping{TKey,TElement}"/>) contains the key
        /// and the adjacent elements (of type <typeparamref name="TElement"/>)
        /// in the same order as found in the source sequence.</returns>
        /// <remarks>
        /// This method is implemented by using deferred execution and
        /// streams the groupings. The grouping elements, however, are
        /// buffered. Each grouping is therefore yielded as soon as it
        /// is complete and before the next grouping occurs.
        /// </remarks>

        public static IEnumerable<IGrouping<TKey, TElement>> GroupAdjacent<TSource, TKey, TElement>(
            this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector,
            Func<TSource, TElement> elementSelector)
            => MoreEnumerable.GroupAdjacent(source, keySelector, elementSelector);

        /// <summary>
        /// Groups the adjacent elements of a sequence according to a
        /// specified key selector function. The keys are compared by using
        /// a comparer and each group's elements are projected by using a
        /// specified function.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of
        /// <paramref name="source"/>.</typeparam>
        /// <typeparam name="TKey">The type of the key returned by
        /// <paramref name="keySelector"/>.</typeparam>
        /// <typeparam name="TResult">The type of the elements in the
        /// resulting sequence.</typeparam>
        /// <param name="source">A sequence whose elements to group.</param>
        /// <param name="keySelector">A function to extract the key for each
        /// element.</param>
        /// <param name="resultSelector">A function to map each key and
        /// associated source elements to a result object.</param>
        /// <returns>A collection of elements of type
        /// <typeparamref name="TResult" /> where each element represents
        /// a projection over a group and its key.</returns>
        /// <remarks>
        /// This method is implemented by using deferred execution and
        /// streams the groupings. The grouping elements, however, are
        /// buffered. Each grouping is therefore yielded as soon as it
        /// is complete and before the next grouping occurs.
        /// </remarks>

        public static IEnumerable<TResult> GroupAdjacent<TSource, TKey, TResult>(
            this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector,
            Func<TKey, IEnumerable<TSource>, TResult> resultSelector)
            => MoreEnumerable.GroupAdjacent(source, keySelector, resultSelector);

        /// <summary>
        /// Groups the adjacent elements of a sequence according to a
        /// specified key selector function. The keys are compared by using
        /// a comparer and each group's elements are projected by using a
        /// specified function.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of
        /// <paramref name="source"/>.</typeparam>
        /// <typeparam name="TKey">The type of the key returned by
        /// <paramref name="keySelector"/>.</typeparam>
        /// <typeparam name="TElement">The type of the elements in the
        /// resulting groupings.</typeparam>
        /// <param name="source">A sequence whose elements to group.</param>
        /// <param name="keySelector">A function to extract the key for each
        /// element.</param>
        /// <param name="elementSelector">A function to map each source
        /// element to an element in the resulting grouping.</param>
        /// <param name="comparer">An <see cref="IEqualityComparer{T}"/> to
        /// compare keys.</param>
        /// <returns>A sequence of groupings where each grouping
        /// (<see cref="IGrouping{TKey,TElement}"/>) contains the key
        /// and the adjacent elements (of type <typeparamref name="TElement"/>)
        /// in the same order as found in the source sequence.</returns>
        /// <remarks>
        /// This method is implemented by using deferred execution and
        /// streams the groupings. The grouping elements, however, are
        /// buffered. Each grouping is therefore yielded as soon as it
        /// is complete and before the next grouping occurs.
        /// </remarks>

        public static IEnumerable<IGrouping<TKey, TElement>> GroupAdjacent<TSource, TKey, TElement>(
            this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector,
            Func<TSource, TElement> elementSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.GroupAdjacent(source, keySelector, elementSelector, comparer);

        /// <summary>
        /// Groups the adjacent elements of a sequence according to a
        /// specified key selector function. The keys are compared by using
        /// a comparer and each group's elements are projected by using a
        /// specified function.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of
        /// <paramref name="source"/>.</typeparam>
        /// <typeparam name="TKey">The type of the key returned by
        /// <paramref name="keySelector"/>.</typeparam>
        /// <typeparam name="TResult">The type of the elements in the
        /// resulting sequence.</typeparam>
        /// <param name="source">A sequence whose elements to group.</param>
        /// <param name="keySelector">A function to extract the key for each
        /// element.</param>
        /// <param name="resultSelector">A function to map each key and
        /// associated source elements to a result object.</param>
        /// <param name="comparer">An <see cref="IEqualityComparer{TKey}"/> to
        /// compare keys.</param>
        /// <returns>A collection of elements of type
        /// <typeparamref name="TResult" /> where each element represents
        /// a projection over a group and its key.</returns>
        /// <remarks>
        /// This method is implemented by using deferred execution and
        /// streams the groupings. The grouping elements, however, are
        /// buffered. Each grouping is therefore yielded as soon as it
        /// is complete and before the next grouping occurs.
        /// </remarks>

        public static IEnumerable<TResult> GroupAdjacent<TSource, TKey, TResult>(
            this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector,
            Func<TKey, IEnumerable<TSource>, TResult> resultSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.GroupAdjacent(source, keySelector, resultSelector, comparer);

    }

    /// <summary><c>Index</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class IndexExtension
    {
        /// <summary>
        /// Returns a sequence of <see cref="KeyValuePair{TKey,TValue}"/>
        /// where the key is the zero-based index of the value in the source
        /// sequence.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <returns>A sequence of <see cref="KeyValuePair{TKey,TValue}"/>.</returns>
        /// <remarks>This operator uses deferred execution and streams its
        /// results.</remarks>

        public static IEnumerable<KeyValuePair<int, TSource>> Index<TSource>(this IEnumerable<TSource> source)
            => MoreEnumerable.Index(source);

        /// <summary>
        /// Returns a sequence of <see cref="KeyValuePair{TKey,TValue}"/>
        /// where the key is the index of the value in the source sequence.
        /// An additional parameter specifies the starting index.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in <paramref name="source"/> sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="startIndex"></param>
        /// <returns>A sequence of <see cref="KeyValuePair{TKey,TValue}"/>.</returns>
        /// <remarks>This operator uses deferred execution and streams its
        /// results.</remarks>

        public static IEnumerable<KeyValuePair<int, TSource>> Index<TSource>(this IEnumerable<TSource> source, int startIndex)
            => MoreEnumerable.Index(source, startIndex);

    }

    /// <summary><c>IndexBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class IndexByExtension
    {
        /// <summary>
        /// Applies a key-generating function to each element of a sequence and
        /// returns a sequence that contains the elements of the original
        /// sequence as well its key and index inside the group of its key.
        /// </summary>
        /// <typeparam name="TSource">Type of the source sequence elements.</typeparam>
        /// <typeparam name="TKey">Type of the projected key.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="keySelector">
        /// Function that projects the key given an element in the source sequence.</param>
        /// <returns>
        /// A sequence of elements paired with their index within the key-group.
        /// The index is the key and the element is the value of the pair.
        /// </returns>

        public static IEnumerable<KeyValuePair<int, TSource>>
            IndexBy<TSource, TKey>(
                this IEnumerable<TSource> source,
                Func<TSource, TKey> keySelector)             => MoreEnumerable.            IndexBy(source, keySelector);

        /// <summary>
        /// Applies a key-generating function to each element of a sequence and
        /// returns a sequence that contains the elements of the original
        /// sequence as well its key and index inside the group of its key.
        /// An additional parameter specifies a comparer to use for testing the
        /// equivalence of keys.
        /// </summary>
        /// <typeparam name="TSource">Type of the source sequence elements.</typeparam>
        /// <typeparam name="TKey">Type of the projected key.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="keySelector">
        /// Function that projects the key given an element in the source sequence.</param>
        /// <param name="comparer">
        /// The equality comparer to use to determine whether or not keys are
        /// equal. If <c>null</c>, the default equality comparer for
        /// <typeparamref name="TSource"/> is used.</param>
        /// <returns>
        /// A sequence of elements paired with their index within the key-group.
        /// The index is the key and the element is the value of the pair.
        /// </returns>

        public static IEnumerable<KeyValuePair<int, TSource>>
            IndexBy<TSource, TKey>(
                this IEnumerable<TSource> source,
                Func<TSource, TKey> keySelector,
                IEqualityComparer<TKey> comparer)             => MoreEnumerable.            IndexBy(source, keySelector, comparer);

    }

    /// <summary><c>Insert</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class InsertExtension
    {
        /// <summary>
        /// Inserts the elements of a sequence into another sequence at a
        /// specified index.
        /// </summary>
        /// <typeparam name="T">Type of the elements of the source sequence.</typeparam>
        /// <param name="first">The source sequence.</param>
        /// <param name="second">The sequence that will be inserted.</param>
        /// <param name="index">
        /// The zero-based index at which to insert elements from
        /// <paramref name="second"/>.</param>
        /// <returns>
        /// A sequence that contains the elements of <paramref name="first"/>
        /// plus the elements of <paramref name="second"/> inserted at
        /// the given index.
        /// </returns>
        /// <exception cref="ArgumentNullException"><paramref name="first"/> is null.</exception>
        /// <exception cref="ArgumentNullException"><paramref name="second"/> is null.</exception>
        /// <exception cref="ArgumentOutOfRangeException">
        /// Thrown if <paramref name="index"/> is negative.
        /// </exception>
        /// <exception cref="ArgumentOutOfRangeException">
        /// Thrown lazily if <paramref name="index"/> is greater than the
        /// length of <paramref name="first"/>. The validation occurs when
        /// yielding the next element after having iterated
        /// <paramref name="first"/> entirely.
        /// </exception>

        public static IEnumerable<T> Insert<T>(this IEnumerable<T> first, IEnumerable<T> second, int index)
            => MoreEnumerable.Insert(first, second, index);

    }

    /// <summary><c>Interleave</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class InterleaveExtension
    {
        /// <summary>
        /// Interleaves the elements of two or more sequences into a single sequence, skipping sequences as they are consumed
        /// </summary>
        /// <remarks>
        /// Interleave combines sequences by visiting each in turn, and returning the first element of each, followed
        /// by the second, then the third, and so on. So, for example:<br/>
        /// <code><![CDATA[
        /// {1,1,1}.Interleave( {2,2,2}, {3,3,3} ) => { 1,2,3,1,2,3,1,2,3 }
        /// ]]></code>
        /// This operator behaves in a deferred and streaming manner.<br/>
        /// When sequences are of unequal length, this method will skip those sequences that have been fully consumed
        /// and continue interleaving the remaining sequences.<br/>
        /// The sequences are interleaved in the order that they appear in the <paramref name="otherSequences"/>
        /// collection, with <paramref name="sequence"/> as the first sequence.
        /// </remarks>
        /// <typeparam name="T">The type of the elements of the source sequences</typeparam>
        /// <param name="sequence">The first sequence in the interleave group</param>
        /// <param name="otherSequences">The other sequences in the interleave group</param>
        /// <returns>A sequence of interleaved elements from all of the source sequences</returns>

        public static IEnumerable<T> Interleave<T>(this IEnumerable<T> sequence, params IEnumerable<T>[] otherSequences)
            => MoreEnumerable.Interleave(sequence, otherSequences);

    }

    /// <summary><c>Lag</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class LagExtension
    {
        /// <summary>
        /// Produces a projection of a sequence by evaluating pairs of elements separated by a negative offset.
        /// </summary>
        /// <remarks>
        /// This operator evaluates in a deferred and streaming manner.<br/>
        /// For elements prior to the lag offset, <c>default(T)</c> is used as the lagged value.<br/>
        /// </remarks>
        /// <typeparam name="TSource">The type of the elements of the source sequence</typeparam>
        /// <typeparam name="TResult">The type of the elements of the result sequence</typeparam>
        /// <param name="source">The sequence over which to evaluate lag</param>
        /// <param name="offset">The offset (expressed as a positive number) by which to lag each value of the sequence</param>
        /// <param name="resultSelector">A projection function which accepts the current and lagged items (in that order) and returns a result</param>
        /// <returns>A sequence produced by projecting each element of the sequence with its lagged pairing</returns>

        public static IEnumerable<TResult> Lag<TSource, TResult>(this IEnumerable<TSource> source, int offset, Func<TSource, TSource, TResult> resultSelector)
            => MoreEnumerable.Lag(source, offset, resultSelector);

        /// <summary>
        /// Produces a projection of a sequence by evaluating pairs of elements separated by a negative offset.
        /// </summary>
        /// <remarks>
        /// This operator evaluates in a deferred and streaming manner.<br/>
        /// </remarks>
        /// <typeparam name="TSource">The type of the elements of the source sequence</typeparam>
        /// <typeparam name="TResult">The type of the elements of the result sequence</typeparam>
        /// <param name="source">The sequence over which to evaluate lag</param>
        /// <param name="offset">The offset (expressed as a positive number) by which to lag each value of the sequence</param>
        /// <param name="defaultLagValue">A default value supplied for the lagged value prior to the lag offset</param>
        /// <param name="resultSelector">A projection function which accepts the current and lagged items (in that order) and returns a result</param>
        /// <returns>A sequence produced by projecting each element of the sequence with its lagged pairing</returns>

        public static IEnumerable<TResult> Lag<TSource, TResult>(this IEnumerable<TSource> source, int offset, TSource defaultLagValue, Func<TSource, TSource, TResult> resultSelector)
            => MoreEnumerable.Lag(source, offset, defaultLagValue, resultSelector);

    }

    /// <summary><c>Last</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class LastExtension
    {

        /// <summary>
        /// Returns the last element of a sequence.
        /// </summary>
        /// <typeparam name="T">
        /// The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The input sequence.</param>
        /// <exception cref="InvalidOperationException">
        /// The input sequence is empty.</exception>
        /// <returns>
        /// The last element of the input sequence.
        /// </returns>

        public static T Last<T>(this IExtremaEnumerable<T> source)
            => MoreEnumerable.Last(source);

    }

    /// <summary><c>LastOrDefault</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class LastOrDefaultExtension
    {

        /// <summary>
        /// Returns the last element of a sequence, or a default value if the
        /// sequence contains no elements.
        /// </summary>
        /// <typeparam name="T">
        /// The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The input sequence.</param>
        /// <returns>
        /// Default value of type <typeparamref name="T"/> if source is empty;
        /// otherwise, the last element in source.
        /// </returns>

        public static T LastOrDefault<T>(this IExtremaEnumerable<T> source)
            => MoreEnumerable.LastOrDefault(source);

    }

    /// <summary><c>Lead</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class LeadExtension
    {
        /// <summary>
        /// Produces a projection of a sequence by evaluating pairs of elements separated by a positive offset.
        /// </summary>
        /// <remarks>
        /// This operator evaluates in a deferred and streaming manner.<br/>
        /// For elements of the sequence that are less than <paramref name="offset"/> items from the end,
        /// default(T) is used as the lead value.<br/>
        /// </remarks>
        /// <typeparam name="TSource">The type of the elements in the source sequence</typeparam>
        /// <typeparam name="TResult">The type of the elements in the result sequence</typeparam>
        /// <param name="source">The sequence over which to evaluate Lead</param>
        /// <param name="offset">The offset (expressed as a positive number) by which to lead each element of the sequence</param>
        /// <param name="resultSelector">A projection function which accepts the current and subsequent (lead) element (in that order) and produces a result</param>
        /// <returns>A sequence produced by projecting each element of the sequence with its lead pairing</returns>

        public static IEnumerable<TResult> Lead<TSource, TResult>(this IEnumerable<TSource> source, int offset, Func<TSource, TSource, TResult> resultSelector)
            => MoreEnumerable.Lead(source, offset, resultSelector);

        /// <summary>
        /// Produces a projection of a sequence by evaluating pairs of elements separated by a positive offset.
        /// </summary>
        /// <remarks>
        /// This operator evaluates in a deferred and streaming manner.<br/>
        /// </remarks>
        /// <typeparam name="TSource">The type of the elements in the source sequence</typeparam>
        /// <typeparam name="TResult">The type of the elements in the result sequence</typeparam>
        /// <param name="source">The sequence over which to evaluate Lead</param>
        /// <param name="offset">The offset (expressed as a positive number) by which to lead each element of the sequence</param>
        /// <param name="defaultLeadValue">A default value supplied for the leading element when none is available</param>
        /// <param name="resultSelector">A projection function which accepts the current and subsequent (lead) element (in that order) and produces a result</param>
        /// <returns>A sequence produced by projecting each element of the sequence with its lead pairing</returns>

        public static IEnumerable<TResult> Lead<TSource, TResult>(this IEnumerable<TSource> source, int offset, TSource defaultLeadValue, Func<TSource, TSource, TResult> resultSelector)
            => MoreEnumerable.Lead(source, offset, defaultLeadValue, resultSelector);

    }

    /// <summary><c>LeftJoin</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class LeftJoinExtension
    {
        /// <summary>
        /// Performs a left outer join on two homogeneous sequences.
        /// Additional arguments specify key selection functions and result
        /// projection functions.
        /// </summary>
        /// <typeparam name="TSource">
        /// The type of elements in the source sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector function.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence of the join operation.</param>
        /// <param name="second">
        /// The second sequence of the join operation.</param>
        /// <param name="keySelector">
        /// Function that projects the key given an element of one of the
        /// sequences to join.</param>
        /// <param name="firstSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="first"/> where there is no corresponding element
        /// in <paramref name="second"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <returns>A sequence containing results projected from a left
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> LeftJoin<TSource, TKey, TResult>(
            this IEnumerable<TSource> first,
            IEnumerable<TSource> second,
            Func<TSource, TKey> keySelector,
            Func<TSource, TResult> firstSelector,
            Func<TSource, TSource, TResult> bothSelector)
            => MoreEnumerable.LeftJoin(first, second, keySelector, firstSelector, bothSelector);

        /// <summary>
        /// Performs a left outer join on two homogeneous sequences.
        /// Additional arguments specify key selection functions, result
        /// projection functions and a key comparer.
        /// </summary>
        /// <typeparam name="TSource">
        /// The type of elements in the source sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector function.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence of the join operation.</param>
        /// <param name="second">
        /// The second sequence of the join operation.</param>
        /// <param name="keySelector">
        /// Function that projects the key given an element of one of the
        /// sequences to join.</param>
        /// <param name="firstSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="first"/> where there is no corresponding element
        /// in <paramref name="second"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <param name="comparer">
        /// The <see cref="IEqualityComparer{T}"/> instance used to compare
        /// keys for equality.</param>
        /// <returns>A sequence containing results projected from a left
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> LeftJoin<TSource, TKey, TResult>(
            this IEnumerable<TSource> first,
            IEnumerable<TSource> second,
            Func<TSource, TKey> keySelector,
            Func<TSource, TResult> firstSelector,
            Func<TSource, TSource, TResult> bothSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.LeftJoin(first, second, keySelector, firstSelector, bothSelector, comparer);

        /// <summary>
        /// Performs a left outer join on two heterogeneous sequences.
        /// Additional arguments specify key selection functions and result
        /// projection functions.
        /// </summary>
        /// <typeparam name="TFirst">
        /// The type of elements in the first sequence.</typeparam>
        /// <typeparam name="TSecond">
        /// The type of elements in the second sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector functions.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence of the join operation.</param>
        /// <param name="second">
        /// The second sequence of the join operation.</param>
        /// <param name="firstKeySelector">
        /// Function that projects the key given an element from <paramref name="first"/>.</param>
        /// <param name="secondKeySelector">
        /// Function that projects the key given an element from <paramref name="second"/>.</param>
        /// <param name="firstSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="first"/> where there is no corresponding element
        /// in <paramref name="second"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <returns>A sequence containing results projected from a left
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> LeftJoin<TFirst, TSecond, TKey, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TFirst, TResult> firstSelector,
            Func<TFirst, TSecond, TResult> bothSelector)             => MoreEnumerable.LeftJoin(first, second, firstKeySelector, secondKeySelector, firstSelector, bothSelector);

        /// <summary>
        /// Performs a left outer join on two heterogeneous sequences.
        /// Additional arguments specify key selection functions, result
        /// projection functions and a key comparer.
        /// </summary>
        /// <typeparam name="TFirst">
        /// The type of elements in the first sequence.</typeparam>
        /// <typeparam name="TSecond">
        /// The type of elements in the second sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector functions.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence of the join operation.</param>
        /// <param name="second">
        /// The second sequence of the join operation.</param>
        /// <param name="firstKeySelector">
        /// Function that projects the key given an element from <paramref name="first"/>.</param>
        /// <param name="secondKeySelector">
        /// Function that projects the key given an element from <paramref name="second"/>.</param>
        /// <param name="firstSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="first"/> where there is no corresponding element
        /// in <paramref name="second"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <param name="comparer">
        /// The <see cref="IEqualityComparer{T}"/> instance used to compare
        /// keys for equality.</param>
        /// <returns>A sequence containing results projected from a left
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> LeftJoin<TFirst, TSecond, TKey, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TFirst, TResult> firstSelector,
            Func<TFirst, TSecond, TResult> bothSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.LeftJoin(first, second, firstKeySelector, secondKeySelector, firstSelector, bothSelector, comparer);

    }

    /// <summary><c>MaxBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class MaxByExtension
    {

        /// <summary>
        /// Returns the maximal elements of the given sequence, based on
        /// the given projection.
        /// </summary>
        /// <remarks>
        /// This overload uses the default comparer  for the projected type.
        /// This operator uses deferred execution. The results are evaluated
        /// and cached on first use to returned sequence.
        /// </remarks>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <typeparam name="TKey">Type of the projected element</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="selector">Selector to use to pick the results to compare</param>
        /// <returns>The maximal element, according to the projection.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> or <paramref name="selector"/> is null</exception>

        public static IExtremaEnumerable<TSource> MaxBy<TSource, TKey>(this IEnumerable<TSource> source,
            Func<TSource, TKey> selector)
            => MoreEnumerable.MaxBy(source, selector);

        /// <summary>
        /// Returns the maximal elements of the given sequence, based on
        /// the given projection and the specified comparer for projected values.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution. The results are evaluated
        /// and cached on first use to returned sequence.
        /// </remarks>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <typeparam name="TKey">Type of the projected element</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="selector">Selector to use to pick the results to compare</param>
        /// <param name="comparer">Comparer to use to compare projected values</param>
        /// <returns>The maximal element, according to the projection.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/>, <paramref name="selector"/>
        /// or <paramref name="comparer"/> is null</exception>

        public static IExtremaEnumerable<TSource> MaxBy<TSource, TKey>(this IEnumerable<TSource> source,
            Func<TSource, TKey> selector, IComparer<TKey> comparer)
            => MoreEnumerable.MaxBy(source, selector, comparer);

    }

    /// <summary><c>MinBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class MinByExtension
    {
        /// <summary>
        /// Returns the minimal elements of the given sequence, based on
        /// the given projection.
        /// </summary>
        /// <remarks>
        /// This overload uses the default comparer for the projected type.
        /// This operator uses deferred execution. The results are evaluated
        /// and cached on first use to returned sequence.
        /// </remarks>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <typeparam name="TKey">Type of the projected element</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="selector">Selector to use to pick the results to compare</param>
        /// <returns>The minimal element, according to the projection.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> or <paramref name="selector"/> is null</exception>

        public static IExtremaEnumerable<TSource> MinBy<TSource, TKey>(this IEnumerable<TSource> source,
            Func<TSource, TKey> selector)
            => MoreEnumerable.MinBy(source, selector);

        /// <summary>
        /// Returns the minimal elements of the given sequence, based on
        /// the given projection and the specified comparer for projected values.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution. The results are evaluated
        /// and cached on first use to returned sequence.
        /// </remarks>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <typeparam name="TKey">Type of the projected element</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="selector">Selector to use to pick the results to compare</param>
        /// <param name="comparer">Comparer to use to compare projected values</param>
        /// <returns>The minimal element, according to the projection.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/>, <paramref name="selector"/>
        /// or <paramref name="comparer"/> is null</exception>

        public static IExtremaEnumerable<TSource> MinBy<TSource, TKey>(this IEnumerable<TSource> source,
            Func<TSource, TKey> selector, IComparer<TKey> comparer)
            => MoreEnumerable.MinBy(source, selector, comparer);

    }

    /// <summary><c>Move</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class MoveExtension
    {
        /// <summary>
        /// Returns a sequence with a range of elements in the source sequence
        /// moved to a new offset.
        /// </summary>
        /// <typeparam name="T">Type of the source sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="fromIndex">
        /// The zero-based index identifying the first element in the range of
        /// elements to move.</param>
        /// <param name="count">The count of items to move.</param>
        /// <param name="toIndex">
        /// The index where the specified range will be moved.</param>
        /// <returns>
        /// A sequence with the specified range moved to the new position.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// var result = Enumerable.Range(0, 6).Move(3, 2, 0);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>{ 3, 4, 0, 1, 2, 5 }</c>.
        /// </example>

        public static IEnumerable<T> Move<T>(this IEnumerable<T> source, int fromIndex, int count, int toIndex)
            => MoreEnumerable.Move(source, fromIndex, count, toIndex);

    }

    /// <summary><c>OrderBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class OrderByExtension
    {
        /// <summary>
        /// Sorts the elements of a sequence in a particular direction (ascending, descending) according to a key
        /// </summary>
        /// <typeparam name="T">The type of the elements in the source sequence</typeparam>
        /// <typeparam name="TKey">The type of the key used to order elements</typeparam>
        /// <param name="source">The sequence to order</param>
        /// <param name="keySelector">A key selector function</param>
        /// <param name="direction">A direction in which to order the elements (ascending, descending)</param>
        /// <returns>An ordered copy of the source sequence</returns>

        public static IOrderedEnumerable<T> OrderBy<T, TKey>(this IEnumerable<T> source, Func<T, TKey> keySelector, OrderByDirection direction)
            => MoreEnumerable.OrderBy(source, keySelector, direction);

        /// <summary>
        /// Sorts the elements of a sequence in a particular direction (ascending, descending) according to a key
        /// </summary>
        /// <typeparam name="T">The type of the elements in the source sequence</typeparam>
        /// <typeparam name="TKey">The type of the key used to order elements</typeparam>
        /// <param name="source">The sequence to order</param>
        /// <param name="keySelector">A key selector function</param>
        /// <param name="direction">A direction in which to order the elements (ascending, descending)</param>
        /// <param name="comparer">A comparer used to define the semantics of element comparison</param>
        /// <returns>An ordered copy of the source sequence</returns>

        public static IOrderedEnumerable<T> OrderBy<T, TKey>(this IEnumerable<T> source, Func<T, TKey> keySelector, IComparer<TKey> comparer, OrderByDirection direction)
            => MoreEnumerable.OrderBy(source, keySelector, comparer, direction);

    }

    /// <summary><c>OrderedMerge</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class OrderedMergeExtension
    {
        /// <summary>
        /// Merges two ordered sequences into one. Where the elements equal
        /// in both sequences, the element from the first sequence is
        /// returned in the resulting sequence.
        /// </summary>
        /// <typeparam name="T">Type of elements in input and output sequences.</typeparam>
        /// <param name="first">The first input sequence.</param>
        /// <param name="second">The second input sequence.</param>
        /// <returns>
        /// A sequence with elements from the two input sequences merged, as
        /// in a full outer join.</returns>
        /// <remarks>
        /// This method uses deferred execution. The behavior is undefined
        /// if the sequences are unordered as inputs.
        /// </remarks>


        public static IEnumerable<T> OrderedMerge<T>(
            this IEnumerable<T> first,
            IEnumerable<T> second)
            => MoreEnumerable.OrderedMerge(first, second);

        /// <summary>
        /// Merges two ordered sequences into one with an additional
        /// parameter specifying how to compare the elements of the
        /// sequences. Where the elements equal in both sequences, the
        /// element from the first sequence is returned in the resulting
        /// sequence.
        /// </summary>
        /// <typeparam name="T">Type of elements in input and output sequences.</typeparam>
        /// <param name="first">The first input sequence.</param>
        /// <param name="second">The second input sequence.</param>
        /// <param name="comparer">An <see cref="IComparer{T}"/> to compare elements.</param>
        /// <returns>
        /// A sequence with elements from the two input sequences merged, as
        /// in a full outer join.</returns>
        /// <remarks>
        /// This method uses deferred execution. The behavior is undefined
        /// if the sequences are unordered as inputs.
        /// </remarks>

        public static IEnumerable<T> OrderedMerge<T>(
            this IEnumerable<T> first,
            IEnumerable<T> second,
            IComparer<T> comparer)
            => MoreEnumerable.OrderedMerge(first, second, comparer);

        /// <summary>
        /// Merges two ordered sequences into one with an additional
        /// parameter specifying the element key by which the sequences are
        /// ordered. Where the keys equal in both sequences, the
        /// element from the first sequence is returned in the resulting
        /// sequence.
        /// </summary>
        /// <typeparam name="T">Type of elements in input and output sequences.</typeparam>
        /// <typeparam name="TKey">Type of keys used for merging.</typeparam>
        /// <param name="first">The first input sequence.</param>
        /// <param name="second">The second input sequence.</param>
        /// <param name="keySelector">Function to extract a key given an element.</param>
        /// <returns>
        /// A sequence with elements from the two input sequences merged
        /// according to a key, as in a full outer join.</returns>
        /// <remarks>
        /// This method uses deferred execution. The behavior is undefined
        /// if the sequences are unordered (by key) as inputs.
        /// </remarks>

        public static IEnumerable<T> OrderedMerge<T, TKey>(
            this IEnumerable<T> first,
            IEnumerable<T> second,
            Func<T, TKey> keySelector)
            => MoreEnumerable.OrderedMerge(first, second, keySelector);

        /// <summary>
        /// Merges two ordered sequences into one. Additional parameters
        /// specify the element key by which the sequences are ordered,
        /// the result when element is found in first sequence but not in
        /// the second, the result when element is found in second sequence
        /// but not in the first and the result when elements are found in
        /// both sequences.
        /// </summary>
        /// <typeparam name="T">Type of elements in source sequences.</typeparam>
        /// <typeparam name="TKey">Type of keys used for merging.</typeparam>
        /// <typeparam name="TResult">Type of elements in the returned sequence.</typeparam>
        /// <param name="first">The first input sequence.</param>
        /// <param name="second">The second input sequence.</param>
        /// <param name="keySelector">Function to extract a key given an element.</param>
        /// <param name="firstSelector">Function to project the result element
        /// when only the first sequence yields a source element.</param>
        /// <param name="secondSelector">Function to project the result element
        /// when only the second sequence yields a source element.</param>
        /// <param name="bothSelector">Function to project the result element
        /// when only both sequences yield a source element whose keys are
        /// equal.</param>
        /// <returns>
        /// A sequence with projections from the two input sequences merged
        /// according to a key, as in a full outer join.</returns>
        /// <remarks>
        /// This method uses deferred execution. The behavior is undefined
        /// if the sequences are unordered (by key) as inputs.
        /// </remarks>

        public static IEnumerable<TResult> OrderedMerge<T, TKey, TResult>(
            this IEnumerable<T> first,
            IEnumerable<T> second,
            Func<T, TKey> keySelector,
            Func<T, TResult> firstSelector,
            Func<T, TResult> secondSelector,
            Func<T, T, TResult> bothSelector)
            => MoreEnumerable.OrderedMerge(first, second, keySelector, firstSelector, secondSelector, bothSelector);

        /// <summary>
        /// Merges two ordered sequences into one. Additional parameters
        /// specify the element key by which the sequences are ordered,
        /// the result when element is found in first sequence but not in
        /// the second, the result when element is found in second sequence
        /// but not in the first, the result when elements are found in
        /// both sequences and a method for comparing keys.
        /// </summary>
        /// <typeparam name="T">Type of elements in source sequences.</typeparam>
        /// <typeparam name="TKey">Type of keys used for merging.</typeparam>
        /// <typeparam name="TResult">Type of elements in the returned sequence.</typeparam>
        /// <param name="first">The first input sequence.</param>
        /// <param name="second">The second input sequence.</param>
        /// <param name="keySelector">Function to extract a key given an element.</param>
        /// <param name="firstSelector">Function to project the result element
        /// when only the first sequence yields a source element.</param>
        /// <param name="secondSelector">Function to project the result element
        /// when only the second sequence yields a source element.</param>
        /// <param name="bothSelector">Function to project the result element
        /// when only both sequences yield a source element whose keys are
        /// equal.</param>
        /// <param name="comparer">An <see cref="IComparer{T}"/> to compare keys.</param>
        /// <returns>
        /// A sequence with projections from the two input sequences merged
        /// according to a key, as in a full outer join.</returns>
        /// <remarks>
        /// This method uses deferred execution. The behavior is undefined
        /// if the sequences are unordered (by key) as inputs.
        /// </remarks>

        public static IEnumerable<TResult> OrderedMerge<T, TKey, TResult>(
            this IEnumerable<T> first,
            IEnumerable<T> second,
            Func<T, TKey> keySelector,
            Func<T, TResult> firstSelector,
            Func<T, TResult> secondSelector,
            Func<T, T, TResult> bothSelector,
            IComparer<TKey> comparer)
            => MoreEnumerable.OrderedMerge(first, second, keySelector, firstSelector, secondSelector, bothSelector, comparer);

        /// <summary>
        /// Merges two heterogeneous sequences ordered by a common key type
        /// into a homogeneous one. Additional parameters specify the
        /// element key by which the sequences are ordered, the result when
        /// element is found in first sequence but not in the second and
        /// the result when element is found in second sequence but not in
        /// the first, the result when elements are found in both sequences.
        /// </summary>
        /// <typeparam name="TFirst">Type of elements in the first sequence.</typeparam>
        /// <typeparam name="TSecond">Type of elements in the second sequence.</typeparam>
        /// <typeparam name="TKey">Type of keys used for merging.</typeparam>
        /// <typeparam name="TResult">Type of elements in the returned sequence.</typeparam>
        /// <param name="first">The first input sequence.</param>
        /// <param name="second">The second input sequence.</param>
        /// <param name="firstKeySelector">Function to extract a key given an
        /// element from the first sequence.</param>
        /// <param name="secondKeySelector">Function to extract a key given an
        /// element from the second sequence.</param>
        /// <param name="firstSelector">Function to project the result element
        /// when only the first sequence yields a source element.</param>
        /// <param name="secondSelector">Function to project the result element
        /// when only the second sequence yields a source element.</param>
        /// <param name="bothSelector">Function to project the result element
        /// when only both sequences yield a source element whose keys are
        /// equal.</param>
        /// <returns>
        /// A sequence with projections from the two input sequences merged
        /// according to a key, as in a full outer join.</returns>
        /// <remarks>
        /// This method uses deferred execution. The behavior is undefined
        /// if the sequences are unordered (by key) as inputs.
        /// </remarks>

        public static IEnumerable<TResult> OrderedMerge<TFirst, TSecond, TKey, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TFirst, TResult> firstSelector,
            Func<TSecond, TResult> secondSelector,
            Func<TFirst, TSecond, TResult> bothSelector)
            => MoreEnumerable.OrderedMerge(first, second, firstKeySelector, secondKeySelector, firstSelector, secondSelector, bothSelector);

        /// <summary>
        /// Merges two heterogeneous sequences ordered by a common key type
        /// into a homogeneous one. Additional parameters specify the
        /// element key by which the sequences are ordered, the result when
        /// element is found in first sequence but not in the second,
        /// the result when element is found in second sequence but not in
        /// the first, the result when elements are found in both sequences
        /// and a method for comparing keys.
        /// </summary>
        /// <typeparam name="TFirst">Type of elements in the first sequence.</typeparam>
        /// <typeparam name="TSecond">Type of elements in the second sequence.</typeparam>
        /// <typeparam name="TKey">Type of keys used for merging.</typeparam>
        /// <typeparam name="TResult">Type of elements in the returned sequence.</typeparam>
        /// <param name="first">The first input sequence.</param>
        /// <param name="second">The second input sequence.</param>
        /// <param name="firstKeySelector">Function to extract a key given an
        /// element from the first sequence.</param>
        /// <param name="secondKeySelector">Function to extract a key given an
        /// element from the second sequence.</param>
        /// <param name="firstSelector">Function to project the result element
        /// when only the first sequence yields a source element.</param>
        /// <param name="secondSelector">Function to project the result element
        /// when only the second sequence yields a source element.</param>
        /// <param name="bothSelector">Function to project the result element
        /// when only both sequences yield a source element whose keys are
        /// equal.</param>
        /// <param name="comparer">An <see cref="IComparer{T}"/> to compare keys.</param>
        /// <returns>
        /// A sequence with projections from the two input sequences merged
        /// according to a key, as in a full outer join.</returns>
        /// <remarks>
        /// This method uses deferred execution. The behavior is undefined
        /// if the sequences are unordered (by key) as inputs.
        /// </remarks>

        public static IEnumerable<TResult> OrderedMerge<TFirst, TSecond, TKey, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TFirst, TResult> firstSelector,
            Func<TSecond, TResult> secondSelector,
            Func<TFirst, TSecond, TResult> bothSelector,
            IComparer<TKey> comparer)
            => MoreEnumerable.OrderedMerge(first, second, firstKeySelector, secondKeySelector, firstSelector, secondSelector, bothSelector, comparer);

    }

    /// <summary><c>Pad</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PadExtension
    {
        /// <summary>
        /// Pads a sequence with default values if it is narrower (shorter
        /// in length) than a given width.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The sequence to pad.</param>
        /// <param name="width">The width/length below which to pad.</param>
        /// <returns>
        /// Returns a sequence that is at least as wide/long as the width/length
        /// specified by the <paramref name="width"/> parameter.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] numbers = { 123, 456, 789 };
        /// var result = numbers.Pad(5);
        /// ]]></code>
        /// The <c>result</c> variable, when iterated over, will yield
        /// 123, 456, 789 and two zeroes, in turn.
        /// </example>

        public static IEnumerable<TSource> Pad<TSource>(this IEnumerable<TSource> source, int width)
            => MoreEnumerable.Pad(source, width);

        /// <summary>
        /// Pads a sequence with a given filler value if it is narrower (shorter
        /// in length) than a given width.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The sequence to pad.</param>
        /// <param name="width">The width/length below which to pad.</param>
        /// <param name="padding">The value to use for padding.</param>
        /// <returns>
        /// Returns a sequence that is at least as wide/long as the width/length
        /// specified by the <paramref name="width"/> parameter.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] numbers = { 123, 456, 789 };
        /// var result = numbers.Pad(5, -1);
        /// ]]></code>
        /// The <c>result</c> variable, when iterated over, will yield
        /// 123, 456, and 789 followed by two occurrences of -1, in turn.
        /// </example>

        public static IEnumerable<TSource> Pad<TSource>(this IEnumerable<TSource> source, int width, TSource padding)
            => MoreEnumerable.Pad(source, width, padding);

        /// <summary>
        /// Pads a sequence with a dynamic filler value if it is narrower (shorter
        /// in length) than a given width.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The sequence to pad.</param>
        /// <param name="width">The width/length below which to pad.</param>
        /// <param name="paddingSelector">Function to calculate padding.</param>
        /// <returns>
        /// Returns a sequence that is at least as wide/long as the width/length
        /// specified by the <paramref name="width"/> parameter.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] numbers = { 0, 1, 2 };
        /// var result = numbers.Pad(5, i => -i);
        /// ]]></code>
        /// The <c>result</c> variable, when iterated over, will yield
        /// 0, 1, 2, -3 and -4, in turn.
        /// </example>

        public static IEnumerable<TSource> Pad<TSource>(this IEnumerable<TSource> source, int width, Func<int, TSource> paddingSelector)
            => MoreEnumerable.Pad(source, width, paddingSelector);

    }

    /// <summary><c>PadStart</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PadStartExtension
    {
        /// <summary>
        /// Pads a sequence with default values in the beginning if it is narrower (shorter
        /// in length) than a given width.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The sequence to pad.</param>
        /// <param name="width">The width/length below which to pad.</param>
        /// <returns>
        /// Returns a sequence that is at least as wide/long as the width/length
        /// specified by the <paramref name="width"/> parameter.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] numbers = { 123, 456, 789 };
        /// var result = numbers.PadStart(5);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>{ 0, 0, 123, 456, 789 }</c>.
        /// </example>

        public static IEnumerable<TSource> PadStart<TSource>(this IEnumerable<TSource> source, int width)
            => MoreEnumerable.PadStart(source, width);

        /// <summary>
        /// Pads a sequence with a given filler value in the beginning if it is narrower (shorter
        /// in length) than a given width.
        /// An additional parameter specifies the value to use for padding.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The sequence to pad.</param>
        /// <param name="width">The width/length below which to pad.</param>
        /// <param name="padding">The value to use for padding.</param>
        /// <returns>
        /// Returns a sequence that is at least as wide/long as the width/length
        /// specified by the <paramref name="width"/> parameter.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] numbers = { 123, 456, 789 };
        /// var result = numbers.PadStart(5, -1);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>{ -1, -1, 123, 456, 789 }</c>.
        /// </example>

        public static IEnumerable<TSource> PadStart<TSource>(this IEnumerable<TSource> source, int width, TSource padding)
            => MoreEnumerable.PadStart(source, width, padding);

        /// <summary>
        /// Pads a sequence with a dynamic filler value in the beginning if it is narrower (shorter
        /// in length) than a given width.
        /// An additional parameter specifies the function to calculate padding.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The sequence to pad.</param>
        /// <param name="width">The width/length below which to pad.</param>
        /// <param name="paddingSelector">
        /// Function to calculate padding given the index of the missing element.
        /// </param>
        /// <returns>
        /// Returns a sequence that is at least as wide/long as the width/length
        /// specified by the <paramref name="width"/> parameter.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] numbers = { 123, 456, 789 };
        /// var result = numbers.PadStart(6, i => -i);
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>{ 0, -1, -2, 123, 456, 789 }</c>.
        /// </example>

        public static IEnumerable<TSource> PadStart<TSource>(this IEnumerable<TSource> source, int width, Func<int, TSource> paddingSelector)
            => MoreEnumerable.PadStart(source, width, paddingSelector);

    }

    /// <summary><c>Pairwise</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PairwiseExtension
    {
        /// <summary>
        /// Returns a sequence resulting from applying a function to each
        /// element in the source sequence and its
        /// predecessor, with the exception of the first element which is
        /// only returned as the predecessor of the second element.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <typeparam name="TResult">The type of the element of the returned sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="resultSelector">A transform function to apply to
        /// each pair of sequence.</param>
        /// <returns>
        /// Returns the resulting sequence.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// var source = new[] { "a", "b", "c", "d" };
        /// var result = source.Pairwise((a, b) => a + b);
        /// ]]></code>
        /// The <c>result</c> variable, when iterated over, will yield
        /// "ab", "bc" and "cd", in turn.
        /// </example>

        public static IEnumerable<TResult> Pairwise<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, TSource, TResult> resultSelector)
            => MoreEnumerable.Pairwise(source, resultSelector);

    }

    /// <summary><c>PartialSort</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PartialSortExtension
    {
        /// <summary>
        /// Combines <see cref="Enumerable.OrderBy{TSource,TKey}(IEnumerable{TSource},Func{TSource,TKey})"/>,
        /// where each element is its key, and <see cref="Enumerable.Take{TSource}"/>
        /// in a single operation.
        /// </summary>
        /// <typeparam name="T">Type of elements in the sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="count">Number of (maximum) elements to return.</param>
        /// <returns>A sequence containing at most top <paramref name="count"/>
        /// elements from source, in their ascending order.</returns>
        /// <remarks>
        /// This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<T> PartialSort<T>(this IEnumerable<T> source, int count)
            => MoreEnumerable.PartialSort(source, count);

        /// <summary>
        /// Combines <see cref="MoreEnumerable.OrderBy{T, TKey}(IEnumerable{T}, Func{T, TKey}, IComparer{TKey}, OrderByDirection)"/>,
        /// where each element is its key, and <see cref="Enumerable.Take{TSource}"/>
        /// in a single operation.
        /// An additional parameter specifies the direction of the sort
        /// </summary>
        /// <typeparam name="T">Type of elements in the sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="count">Number of (maximum) elements to return.</param>
        /// <param name="direction">The direction in which to sort the elements</param>
        /// <returns>A sequence containing at most top <paramref name="count"/>
        /// elements from source, in the specified order.</returns>
        /// <remarks>
        /// This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<T> PartialSort<T>(this IEnumerable<T> source,
            int count, OrderByDirection direction)
            => MoreEnumerable.PartialSort(source, count, direction);

        /// <summary>
        /// Combines <see cref="Enumerable.OrderBy{TSource,TKey}(IEnumerable{TSource},Func{TSource,TKey},IComparer{TKey})"/>,
        /// where each element is its key, and <see cref="Enumerable.Take{TSource}"/>
        /// in a single operation. An additional parameter specifies how the
        /// elements compare to each other.
        /// </summary>
        /// <typeparam name="T">Type of elements in the sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="count">Number of (maximum) elements to return.</param>
        /// <param name="comparer">A <see cref="IComparer{T}"/> to compare elements.</param>
        /// <returns>A sequence containing at most top <paramref name="count"/>
        /// elements from source, in their ascending order.</returns>
        /// <remarks>
        /// This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<T> PartialSort<T>(this IEnumerable<T> source,
            int count, IComparer<T> comparer)
            => MoreEnumerable.PartialSort(source, count, comparer);

        /// <summary>
        /// Combines <see cref="MoreEnumerable.OrderBy{T, TKey}(IEnumerable{T}, Func{T, TKey}, IComparer{TKey}, OrderByDirection)"/>,
        /// where each element is its key, and <see cref="Enumerable.Take{TSource}"/>
        /// in a single operation.
        /// Additional parameters specify how the elements compare to each other and
        /// the direction of the sort.
        /// </summary>
        /// <typeparam name="T">Type of elements in the sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="count">Number of (maximum) elements to return.</param>
        /// <param name="comparer">A <see cref="IComparer{T}"/> to compare elements.</param>
        /// <param name="direction">The direction in which to sort the elements</param>
        /// <returns>A sequence containing at most top <paramref name="count"/>
        /// elements from source, in the specified order.</returns>
        /// <remarks>
        /// This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<T> PartialSort<T>(this IEnumerable<T> source,
            int count, IComparer<T> comparer, OrderByDirection direction)
            => MoreEnumerable.PartialSort(source, count, comparer, direction);

    }

    /// <summary><c>PartialSortBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PartialSortByExtension
    {

        /// <summary>
        /// Combines <see cref="Enumerable.OrderBy{TSource,TKey}(IEnumerable{TSource},Func{TSource,TKey},IComparer{TKey})"/>,
        /// and <see cref="Enumerable.Take{TSource}"/> in a single operation.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in the sequence.</typeparam>
        /// <typeparam name="TKey">Type of keys.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="keySelector">A function to extract a key from an element.</param>
        /// <param name="count">Number of (maximum) elements to return.</param>
        /// <returns>A sequence containing at most top <paramref name="count"/>
        /// elements from source, in ascending order of their keys.</returns>
        /// <remarks>
        /// This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<TSource> PartialSortBy<TSource, TKey>(
            this IEnumerable<TSource> source, int count,
            Func<TSource, TKey> keySelector)
            => MoreEnumerable.PartialSortBy(source, count, keySelector);

        /// <summary>
        /// Combines <see cref="MoreEnumerable.OrderBy{T, TKey}(IEnumerable{T}, Func{T, TKey}, OrderByDirection)"/>,
        /// and <see cref="Enumerable.Take{TSource}"/> in a single operation.
        /// An additional parameter specifies the direction of the sort
        /// </summary>
        /// <typeparam name="TSource">Type of elements in the sequence.</typeparam>
        /// <typeparam name="TKey">Type of keys.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="keySelector">A function to extract a key from an element.</param>
        /// <param name="count">Number of (maximum) elements to return.</param>
        /// <param name="direction">The direction in which to sort the elements</param>
        /// <returns>A sequence containing at most top <paramref name="count"/>
        /// elements from source, in the specified order of their keys.</returns>
        /// <remarks>
        /// This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<TSource> PartialSortBy<TSource, TKey>(
            this IEnumerable<TSource> source, int count,
            Func<TSource, TKey> keySelector, OrderByDirection direction)
            => MoreEnumerable.PartialSortBy(source, count, keySelector, direction);

        /// <summary>
        /// Combines <see cref="Enumerable.OrderBy{TSource,TKey}(IEnumerable{TSource},Func{TSource,TKey},IComparer{TKey})"/>,
        /// and <see cref="Enumerable.Take{TSource}"/> in a single operation.
        /// An additional parameter specifies how the keys compare to each other.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in the sequence.</typeparam>
        /// <typeparam name="TKey">Type of keys.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="keySelector">A function to extract a key from an element.</param>
        /// <param name="count">Number of (maximum) elements to return.</param>
        /// <param name="comparer">A <see cref="IComparer{T}"/> to compare elements.</param>
        /// <returns>A sequence containing at most top <paramref name="count"/>
        /// elements from source, in ascending order of their keys.</returns>
        /// <remarks>
        /// This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<TSource> PartialSortBy<TSource, TKey>(
            this IEnumerable<TSource> source, int count,
            Func<TSource, TKey> keySelector,
            IComparer<TKey> comparer)
            => MoreEnumerable.PartialSortBy(source, count, keySelector, comparer);

        /// <summary>
        /// Combines <see cref="MoreEnumerable.OrderBy{T, TKey}(IEnumerable{T}, Func{T, TKey}, OrderByDirection)"/>,
        /// and <see cref="Enumerable.Take{TSource}"/> in a single operation.
        /// Additional parameters specify how the elements compare to each other and
        /// the direction of the sort.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in the sequence.</typeparam>
        /// <typeparam name="TKey">Type of keys.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="keySelector">A function to extract a key from an element.</param>
        /// <param name="count">Number of (maximum) elements to return.</param>
        /// <param name="comparer">A <see cref="IComparer{T}"/> to compare elements.</param>
        /// <param name="direction">The direction in which to sort the elements</param>
        /// <returns>A sequence containing at most top <paramref name="count"/>
        /// elements from source, in the specified order of their keys.</returns>
        /// <remarks>
        /// This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<TSource> PartialSortBy<TSource, TKey>(
            this IEnumerable<TSource> source, int count,
            Func<TSource, TKey> keySelector,
            IComparer<TKey> comparer,
            OrderByDirection direction)
            => MoreEnumerable.PartialSortBy(source, count, keySelector, comparer, direction);

    }

    /// <summary><c>Partition</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PartitionExtension
    {
        /// <summary>
        /// Partitions or splits a sequence in two using a predicate.
        /// </summary>
        /// <param name="source">The source sequence.</param>
        /// <param name="predicate">The predicate function.</param>
        /// <typeparam name="T">Type of source elements.</typeparam>
        /// <returns>
        /// A tuple of elements staisfying the predicate and those that do not,
        /// respectively.
        /// </returns>
        /// <example>
        /// <code><![CDATA[
        /// var (evens, odds) =
        ///     Enumerable.Range(0, 10).Partition(x => x % 2 == 0);
        /// ]]></code>
        /// The <c>evens</c> variable, when iterated over, will yield 0, 2, 4, 6
        /// and then 8. The <c>odds</c> variable, when iterated over, will yield
        /// 1, 3, 5, 7 and then 9.
        /// </example>

        public static (IEnumerable<T> True, IEnumerable<T> False)
            Partition<T>(this IEnumerable<T> source, Func<T, bool> predicate)             => MoreEnumerable.            Partition(source, predicate);

        /// <summary>
        /// Partitions a grouping by Boolean keys into a projection of true
        /// elements and false elements, respectively.
        /// </summary>
        /// <typeparam name="T">Type of elements in source groupings.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from sequences of true elements
        /// and false elements, respectively, passed as arguments.
        /// </param>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>

        public static TResult Partition<T, TResult>(this IEnumerable<IGrouping<bool, T>> source,
            Func<IEnumerable<T>, IEnumerable<T>, TResult> resultSelector)
            => MoreEnumerable.Partition(source, resultSelector);

        /// <summary>
        /// Partitions a grouping by nullable Boolean keys into a projection of
        /// true elements, false elements and null elements, respectively.
        /// </summary>
        /// <typeparam name="T">Type of elements in source groupings.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from sequences of true elements,
        /// false elements and null elements, respectively, passed as
        /// arguments.
        /// </param>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>

        public static TResult Partition<T, TResult>(this IEnumerable<IGrouping<bool?, T>> source,
            Func<IEnumerable<T>, IEnumerable<T>, IEnumerable<T>, TResult> resultSelector)
            => MoreEnumerable.Partition(source, resultSelector);

        /// <summary>
        /// Partitions or splits a sequence in two using a predicate and then
        /// projects a result from the two.
        /// </summary>
        /// <param name="source">The source sequence.</param>
        /// <param name="predicate">The predicate function.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from sequences of elements that
        /// satisfy the predicate and those that do not, respectively, passed as
        /// arguments.
        /// </param>
        /// <typeparam name="T">Type of source elements.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>
        /// <example>
        /// <code><![CDATA[
        /// var (evens, odds) =
        ///     Enumerable.Range(0, 10)
        ///               .Partition(x => x % 2 == 0, ValueTuple.Create);
        /// ]]></code>
        /// The <c>evens</c> variable, when iterated over, will yield 0, 2, 4, 6
        /// and then 8. The <c>odds</c> variable, when iterated over, will yield
        /// 1, 3, 5, 7 and then 9.
        /// </example>

        public static TResult Partition<T, TResult>(this IEnumerable<T> source,
            Func<T, bool> predicate, Func<IEnumerable<T>, IEnumerable<T>, TResult> resultSelector)
            => MoreEnumerable.Partition(source, predicate, resultSelector);

        /// <summary>
        /// Partitions a grouping and projects a result from group elements
        /// matching a key and those groups that do not.
        /// </summary>
        /// <typeparam name="TKey">Type of keys in source groupings.</typeparam>
        /// <typeparam name="TElement">Type of elements in source groupings.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="key">The key to partition.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from sequences of elements
        /// matching <paramref name="key"/> and those groups that do not (in
        /// the order in which they appear in <paramref name="source"/>),
        /// passed as arguments.
        /// </param>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>

        public static TResult Partition<TKey, TElement, TResult>(this IEnumerable<IGrouping<TKey, TElement>> source,
            TKey key,
            Func<IEnumerable<TElement>, IEnumerable<IGrouping<TKey, TElement>>, TResult> resultSelector)             => MoreEnumerable.Partition(source, key, resultSelector);

        /// <summary>
        /// Partitions a grouping and projects a result from elements of
        /// groups matching a set of two keys and those groups that do not.
        /// </summary>
        /// <typeparam name="TKey">Type of keys in source groupings.</typeparam>
        /// <typeparam name="TElement">Type of elements in source groupings.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="key1">The first key to partition on.</param>
        /// <param name="key2">The second key to partition on.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from elements of the group
        /// matching <paramref name="key1"/>, elements of the group matching
        /// <paramref name="key2"/> and those groups that do not (in the order
        /// in which they appear in <paramref name="source"/>), passed as
        /// arguments.
        /// </param>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>

        public static TResult Partition<TKey, TElement, TResult>(this IEnumerable<IGrouping<TKey, TElement>> source,
            TKey key1, TKey key2,
            Func<IEnumerable<TElement>, IEnumerable<TElement>, IEnumerable<IGrouping<TKey, TElement>>, TResult> resultSelector)             => MoreEnumerable.Partition(source, key1, key2, resultSelector);

        /// <summary>
        /// Partitions a grouping and projects a result from group elements
        /// matching a key and those groups that do not. An additional parameter
        /// specifies how to compare keys for equality.
        /// </summary>
        /// <typeparam name="TKey">Type of keys in source groupings.</typeparam>
        /// <typeparam name="TElement">Type of elements in source groupings.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="key">The key to partition on.</param>
        /// <param name="comparer">The comparer for keys.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from elements of the group
        /// matching <paramref name="key"/> and those groups that do not (in
        /// the order in which they appear in <paramref name="source"/>),
        /// passed as arguments.
        /// </param>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>

        public static TResult Partition<TKey, TElement, TResult>(this IEnumerable<IGrouping<TKey, TElement>> source,
            TKey key, IEqualityComparer<TKey> comparer,
            Func<IEnumerable<TElement>, IEnumerable<IGrouping<TKey, TElement>>, TResult> resultSelector)
            => MoreEnumerable.Partition(source, key, comparer, resultSelector);

        /// <summary>
        /// Partitions a grouping and projects a result from elements groups
        /// matching a set of three keys and those groups that do not.
        /// </summary>
        /// <typeparam name="TKey">Type of keys in source groupings.</typeparam>
        /// <typeparam name="TElement">Type of elements in source groupings.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="key1">The first key to partition on.</param>
        /// <param name="key2">The second key to partition on.</param>
        /// <param name="key3">The third key to partition on.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from elements of groups
        /// matching <paramref name="key1"/>, <paramref name="key2"/> and
        /// <paramref name="key3"/> and those groups that do not (in the order
        /// in which they appear in <paramref name="source"/>), passed as
        /// arguments.
        /// </param>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>

        public static TResult Partition<TKey, TElement, TResult>(this IEnumerable<IGrouping<TKey, TElement>> source,
            TKey key1, TKey key2, TKey key3,
            Func<IEnumerable<TElement>, IEnumerable<TElement>, IEnumerable<TElement>, IEnumerable<IGrouping<TKey, TElement>>, TResult> resultSelector)             => MoreEnumerable.Partition(source, key1, key2, key3, resultSelector);

        /// <summary>
        /// Partitions a grouping and projects a result from elements of
        /// groups matching a set of two keys and those groups that do not.
        /// An additional parameter specifies how to compare keys for equality.
        /// </summary>
        /// <typeparam name="TKey">Type of keys in source groupings.</typeparam>
        /// <typeparam name="TElement">Type of elements in source groupings.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="key1">The first key to partition on.</param>
        /// <param name="key2">The second key to partition on.</param>
        /// <param name="comparer">The comparer for keys.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from elements of the group
        /// matching <paramref name="key1"/>, elements of the group matching
        /// <paramref name="key2"/> and those groups that do not (in the order
        /// in which they appear in <paramref name="source"/>), passed as
        /// arguments.
        /// </param>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>

        public static TResult Partition<TKey, TElement, TResult>(this IEnumerable<IGrouping<TKey, TElement>> source,
            TKey key1, TKey key2, IEqualityComparer<TKey> comparer,
            Func<IEnumerable<TElement>, IEnumerable<TElement>, IEnumerable<IGrouping<TKey, TElement>>, TResult> resultSelector)
            => MoreEnumerable.Partition(source, key1, key2, comparer, resultSelector);

        /// <summary>
        /// Partitions a grouping and projects a result from elements groups
        /// matching a set of three keys and those groups that do not. An
        /// additional parameter specifies how to compare keys for equality.
        /// </summary>
        /// <typeparam name="TKey">Type of keys in source groupings.</typeparam>
        /// <typeparam name="TElement">Type of elements in source groupings.</typeparam>
        /// <typeparam name="TResult">Type of the result.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="key1">The first key to partition on.</param>
        /// <param name="key2">The second key to partition on.</param>
        /// <param name="key3">The third key to partition on.</param>
        /// <param name="comparer">The comparer for keys.</param>
        /// <param name="resultSelector">
        /// Function that projects the result from elements of groups
        /// matching <paramref name="key1"/>, <paramref name="key2"/> and
        /// <paramref name="key3"/> and those groups that do not (in
        /// the order in which they appear in <paramref name="source"/>),
        /// passed as arguments.
        /// </param>
        /// <returns>
        /// The return value from <paramref name="resultSelector"/>.
        /// </returns>

        public static TResult Partition<TKey, TElement, TResult>(this IEnumerable<IGrouping<TKey, TElement>> source,
            TKey key1, TKey key2, TKey key3, IEqualityComparer<TKey> comparer,
            Func<IEnumerable<TElement>, IEnumerable<TElement>, IEnumerable<TElement>, IEnumerable<IGrouping<TKey, TElement>>, TResult> resultSelector)             => MoreEnumerable.Partition(source, key1, key2, key3, comparer, resultSelector);

    }

    /// <summary><c>Permutations</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PermutationsExtension
    {

        /// <summary>
        /// Generates a sequence of lists that represent the permutations of the original sequence.
        /// </summary>
        /// <remarks>
        /// A permutation is a unique re-ordering of the elements of the sequence.<br/>
        /// This operator returns permutations in a deferred, streaming fashion; however, each
        /// permutation is materialized into a new list. There are N! permutations of a sequence,
        /// where N => sequence.Count().<br/>
        /// Be aware that the original sequence is considered one of the permutations and will be
        /// returned as one of the results.
        /// </remarks>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="sequence">The original sequence to permute</param>
        /// <returns>A sequence of lists representing permutations of the original sequence</returns>

        public static IEnumerable<IList<T>> Permutations<T>(this IEnumerable<T> sequence)
            => MoreEnumerable.Permutations(sequence);

    }

    /// <summary><c>Pipe</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PipeExtension
    {
        /// <summary>
        /// Executes the given action on each element in the source sequence
        /// and yields it.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="source">The sequence of elements</param>
        /// <param name="action">The action to execute on each element</param>
        /// <returns>A sequence with source elements in their original order.</returns>
        /// <remarks>
        /// The returned sequence is essentially a duplicate of
        /// the original, but with the extra action being executed while the
        /// sequence is evaluated. The action is always taken before the element
        /// is yielded, so any changes made by the action will be visible in the
        /// returned sequence. This operator uses deferred execution and streams it results.
        /// </remarks>

        public static IEnumerable<T> Pipe<T>(this IEnumerable<T> source, Action<T> action)
            => MoreEnumerable.Pipe(source, action);

    }

    /// <summary><c>Prepend</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PrependExtension
    {
        /// <summary>
        /// Prepends a single value to a sequence.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The sequence to prepend to.</param>
        /// <param name="value">The value to prepend.</param>
        /// <returns>
        /// Returns a sequence where a value is prepended to it.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <code><![CDATA[
        /// int[] numbers = { 1, 2, 3 };
        /// var result = numbers.Prepend(0);
        /// ]]></code>
        /// The <c>result</c> variable, when iterated over, will yield
        /// 0, 1, 2 and 3, in turn.

        public static IEnumerable<TSource> Prepend<TSource>(this IEnumerable<TSource> source, TSource value)
            => MoreEnumerable.Prepend(source, value);

    }

    /// <summary><c>PreScan</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class PreScanExtension
    {
        /// <summary>
        /// Performs a pre-scan (exclusive prefix sum) on a sequence of elements.
        /// </summary>
        /// <remarks>
        /// An exclusive prefix sum returns an equal-length sequence where the
        /// N-th element is the sum of the first N-1 input elements (the first
        /// element is a special case, it is set to the identity). More
        /// generally, the pre-scan allows any commutative binary operation,
        /// not just a sum.
        /// The inclusive version of PreScan is <see cref="MoreEnumerable.Scan{TSource}"/>.
        /// This operator uses deferred execution and streams its result.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] values = { 1, 2, 3, 4 };
        /// var prescan = values.PreScan((a, b) => a + b, 0);
        /// var scan = values.Scan((a, b) => a + b);
        /// var result = values.EquiZip(prescan, ValueTuple.Create);
        /// ]]></code>
        /// <c>prescan</c> will yield <c>{ 0, 1, 3, 6 }</c>, while <c>scan</c>
        /// and <c>result</c> will both yield <c>{ 1, 3, 6, 10 }</c>. This
        /// shows the relationship between the inclusive and exclusive prefix sum.
        /// </example>
        /// <typeparam name="TSource">Type of elements in source sequence</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="transformation">Transformation operation</param>
        /// <param name="identity">Identity element (see remarks)</param>
        /// <returns>The scanned sequence</returns>

        public static IEnumerable<TSource> PreScan<TSource>(
            this IEnumerable<TSource> source,
            Func<TSource, TSource, TSource> transformation,
            TSource identity)
            => MoreEnumerable.PreScan(source, transformation, identity);

    }

    /// <summary><c>RandomSubset</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class RandomSubsetExtension
    {
        /// <summary>
        /// Returns a sequence of a specified size of random elements from the
        /// original sequence.
        /// </summary>
        /// <typeparam name="T">The type of source sequence elements.</typeparam>
        /// <param name="source">
        /// The sequence from which to return random elements.</param>
        /// <param name="subsetSize">The size of the random subset to return.</param>
        /// <returns>
        /// A random sequence of elements in random order from the original
        /// sequence.</returns>

        public static IEnumerable<T> RandomSubset<T>(this IEnumerable<T> source, int subsetSize)
            => MoreEnumerable.RandomSubset(source, subsetSize);

        /// <summary>
        /// Returns a sequence of a specified size of random elements from the
        /// original sequence. An additional parameter specifies a random
        /// generator to be used for the random selection algorithm.
        /// </summary>
        /// <typeparam name="T">The type of source sequence elements.</typeparam>
        /// <param name="source">
        /// The sequence from which to return random elements.</param>
        /// <param name="subsetSize">The size of the random subset to return.</param>
        /// <param name="rand">
        /// A random generator used as part of the selection algorithm.</param>
        /// <returns>
        /// A random sequence of elements in random order from the original
        /// sequence.</returns>

        public static IEnumerable<T> RandomSubset<T>(this IEnumerable<T> source, int subsetSize, Random rand)
            => MoreEnumerable.RandomSubset(source, subsetSize, rand);

    }

    /// <summary><c>Rank</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class RankExtension
    {
        /// <summary>
        /// Ranks each item in the sequence in descending ordering using a default comparer.
        /// </summary>
        /// <typeparam name="TSource">Type of item in the sequence</typeparam>
        /// <param name="source">The sequence whose items will be ranked</param>
        /// <returns>A sequence of position integers representing the ranks of the corresponding items in the sequence</returns>

        public static IEnumerable<int> Rank<TSource>(this IEnumerable<TSource> source)
            => MoreEnumerable.Rank(source);

        /// <summary>
        /// Rank each item in the sequence using a caller-supplied comparer.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements in the source sequence</typeparam>
        /// <param name="source">The sequence of items to rank</param>
        /// <param name="comparer">A object that defines comparison semantics for the elements in the sequence</param>
        /// <returns>A sequence of position integers representing the ranks of the corresponding items in the sequence</returns>

        public static IEnumerable<int> Rank<TSource>(this IEnumerable<TSource> source, IComparer<TSource> comparer)
            => MoreEnumerable.Rank(source, comparer);

    }

    /// <summary><c>RankBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class RankByExtension
    {

        /// <summary>
        /// Ranks each item in the sequence in descending ordering by a specified key using a default comparer
        /// </summary>
        /// <typeparam name="TSource">The type of the elements in the source sequence</typeparam>
        /// <typeparam name="TKey">The type of the key used to rank items in the sequence</typeparam>
        /// <param name="source">The sequence of items to rank</param>
        /// <param name="keySelector">A key selector function which returns the value by which to rank items in the sequence</param>
        /// <returns>A sequence of position integers representing the ranks of the corresponding items in the sequence</returns>

        public static IEnumerable<int> RankBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector)
            => MoreEnumerable.RankBy(source, keySelector);

        /// <summary>
        /// Ranks each item in a sequence using a specified key and a caller-supplied comparer
        /// </summary>
        /// <typeparam name="TSource">The type of the elements in the source sequence</typeparam>
        /// <typeparam name="TKey">The type of the key used to rank items in the sequence</typeparam>
        /// <param name="source">The sequence of items to rank</param>
        /// <param name="keySelector">A key selector function which returns the value by which to rank items in the sequence</param>
        /// <param name="comparer">An object that defines the comparison semantics for keys used to rank items</param>
        /// <returns>A sequence of position integers representing the ranks of the corresponding items in the sequence</returns>

        public static IEnumerable<int> RankBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer)
            => MoreEnumerable.RankBy(source, keySelector, comparer);

    }

    /// <summary><c>Repeat</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class RepeatExtension
    {

        /// <summary>
        /// Repeats the sequence forever.
        /// </summary>
        /// <typeparam name="T">Type of elements in sequence</typeparam>
        /// <param name="sequence">The sequence to repeat</param>
        /// <returns>A sequence produced from the infinite repetition of the original source sequence</returns>

        public static IEnumerable<T> Repeat<T>(this IEnumerable<T> sequence)
            => MoreEnumerable.Repeat(sequence);
        /// <summary>
        /// Repeats the sequence the specified number of times.
        /// </summary>
        /// <typeparam name="T">Type of elements in sequence</typeparam>
        /// <param name="sequence">The sequence to repeat</param>
        /// <param name="count">Number of times to repeat the sequence</param>
        /// <returns>A sequence produced from the repetition of the original source sequence</returns>

        public static IEnumerable<T> Repeat<T>(this IEnumerable<T> sequence, int count)
            => MoreEnumerable.Repeat(sequence, count);

    }

    /// <summary><c>RightJoin</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class RightJoinExtension
    {
        /// <summary>
        /// Performs a right outer join on two homogeneous sequences.
        /// Additional arguments specify key selection functions and result
        /// projection functions.
        /// </summary>
        /// <typeparam name="TSource">
        /// The type of elements in the source sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector function.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence of the join operation.</param>
        /// <param name="second">
        /// The second sequence of the join operation.</param>
        /// <param name="keySelector">
        /// Function that projects the key given an element of one of the
        /// sequences to join.</param>
        /// <param name="secondSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="second"/> where there is no corresponding element
        /// in <paramref name="first"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <returns>A sequence containing results projected from a right
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> RightJoin<TSource, TKey, TResult>(
            this IEnumerable<TSource> first,
            IEnumerable<TSource> second,
            Func<TSource, TKey> keySelector,
            Func<TSource, TResult> secondSelector,
            Func<TSource, TSource, TResult> bothSelector)
            => MoreEnumerable.RightJoin(first, second, keySelector, secondSelector, bothSelector);

        /// <summary>
        /// Performs a right outer join on two homogeneous sequences.
        /// Additional arguments specify key selection functions, result
        /// projection functions and a key comparer.
        /// </summary>
        /// <typeparam name="TSource">
        /// The type of elements in the source sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector function.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence of the join operation.</param>
        /// <param name="second">
        /// The second sequence of the join operation.</param>
        /// <param name="keySelector">
        /// Function that projects the key given an element of one of the
        /// sequences to join.</param>
        /// <param name="secondSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="second"/> where there is no corresponding element
        /// in <paramref name="first"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <param name="comparer">
        /// The <see cref="IEqualityComparer{T}"/> instance used to compare
        /// keys for equality.</param>
        /// <returns>A sequence containing results projected from a right
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> RightJoin<TSource, TKey, TResult>(
            this IEnumerable<TSource> first,
            IEnumerable<TSource> second,
            Func<TSource, TKey> keySelector,
            Func<TSource, TResult> secondSelector,
            Func<TSource, TSource, TResult> bothSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.RightJoin(first, second, keySelector, secondSelector, bothSelector, comparer);

        /// <summary>
        /// Performs a right outer join on two heterogeneous sequences.
        /// Additional arguments specify key selection functions and result
        /// projection functions.
        /// </summary>
        /// <typeparam name="TFirst">
        /// The type of elements in the first sequence.</typeparam>
        /// <typeparam name="TSecond">
        /// The type of elements in the second sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector functions.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence of the join operation.</param>
        /// <param name="second">
        /// The second sequence of the join operation.</param>
        /// <param name="firstKeySelector">
        /// Function that projects the key given an element from <paramref name="first"/>.</param>
        /// <param name="secondKeySelector">
        /// Function that projects the key given an element from <paramref name="second"/>.</param>
        /// <param name="secondSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="second"/> where there is no corresponding element
        /// in <paramref name="first"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <returns>A sequence containing results projected from a right
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> RightJoin<TFirst, TSecond, TKey, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TSecond, TResult> secondSelector,
            Func<TFirst, TSecond, TResult> bothSelector)             => MoreEnumerable.RightJoin(first, second, firstKeySelector, secondKeySelector, secondSelector, bothSelector);

        /// <summary>
        /// Performs a right outer join on two heterogeneous sequences.
        /// Additional arguments specify key selection functions, result
        /// projection functions and a key comparer.
        /// </summary>
        /// <typeparam name="TFirst">
        /// The type of elements in the first sequence.</typeparam>
        /// <typeparam name="TSecond">
        /// The type of elements in the second sequence.</typeparam>
        /// <typeparam name="TKey">
        /// The type of the key returned by the key selector functions.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the result elements.</typeparam>
        /// <param name="first">
        /// The first sequence of the join operation.</param>
        /// <param name="second">
        /// The second sequence of the join operation.</param>
        /// <param name="firstKeySelector">
        /// Function that projects the key given an element from <paramref name="first"/>.</param>
        /// <param name="secondKeySelector">
        /// Function that projects the key given an element from <paramref name="second"/>.</param>
        /// <param name="secondSelector">
        /// Function that projects the result given just an element from
        /// <paramref name="second"/> where there is no corresponding element
        /// in <paramref name="first"/>.</param>
        /// <param name="bothSelector">
        /// Function that projects the result given an element from
        /// <paramref name="first"/> and an element from <paramref name="second"/>
        /// that match on a common key.</param>
        /// <param name="comparer">
        /// The <see cref="IEqualityComparer{T}"/> instance used to compare
        /// keys for equality.</param>
        /// <returns>A sequence containing results projected from a right
        /// outer join of the two input sequences.</returns>

        public static IEnumerable<TResult> RightJoin<TFirst, TSecond, TKey, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TKey> firstKeySelector,
            Func<TSecond, TKey> secondKeySelector,
            Func<TSecond, TResult> secondSelector,
            Func<TFirst, TSecond, TResult> bothSelector,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.RightJoin(first, second, firstKeySelector, secondKeySelector, secondSelector, bothSelector, comparer);

    }

    /// <summary><c>RunLengthEncode</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class RunLengthEncodeExtension
    {
        /// <summary>
        /// Run-length encodes a sequence by converting consecutive instances of the same element into
        /// a <c>KeyValuePair{T,int}</c> representing the item and its occurrence count.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="sequence">The sequence to run length encode</param>
        /// <returns>A sequence of <c>KeyValuePair{T,int}</c> where the key is the element and the value is the occurrence count</returns>

        public static IEnumerable<KeyValuePair<T, int>> RunLengthEncode<T>(this IEnumerable<T> sequence)
            => MoreEnumerable.RunLengthEncode(sequence);

        /// <summary>
        /// Run-length encodes a sequence by converting consecutive instances of the same element into
        /// a <c>KeyValuePair{T,int}</c> representing the item and its occurrence count. This overload
        /// uses a custom equality comparer to identify equivalent items.
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="sequence">The sequence to run length encode</param>
        /// <param name="comparer">The comparer used to identify equivalent items</param>
        /// <returns>A sequence of <c>KeyValuePair{T,int}</c> where they key is the element and the value is the occurrence count</returns>

        public static IEnumerable<KeyValuePair<T, int>> RunLengthEncode<T>(this IEnumerable<T> sequence, IEqualityComparer<T> comparer)
            => MoreEnumerable.RunLengthEncode(sequence, comparer);

    }

    /// <summary><c>Scan</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ScanExtension
    {
        /// <summary>
        /// Performs a scan (inclusive prefix sum) on a sequence of elements.
        /// </summary>
        /// <remarks>
        /// An inclusive prefix sum returns an equal-length sequence where the
        /// N-th element is the sum of the first N input elements. More
        /// generally, the scan allows any commutative binary operation, not
        /// just a sum.
        /// The exclusive version of Scan is <see cref="MoreEnumerable.PreScan{TSource}"/>.
        /// This operator uses deferred execution and streams its result.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] values = { 1, 2, 3, 4 };
        /// var prescan = values.PreScan((a, b) => a + b, 0);
        /// var scan = values.Scan((a, b) => a + b);
        /// var result = values.EquiZip(scan, ValueTuple.Create);
        /// ]]></code>
        /// <c>prescan</c> will yield <c>{ 0, 1, 3, 6 }</c>, while <c>scan</c>
        /// and <c>result</c> will both yield <c>{ 1, 3, 6, 10 }</c>. This
        /// shows the relationship between the inclusive and exclusive prefix sum.
        /// </example>
        /// <typeparam name="TSource">Type of elements in source sequence</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="transformation">Transformation operation</param>
        /// <returns>The scanned sequence</returns>

        public static IEnumerable<TSource> Scan<TSource>(this IEnumerable<TSource> source,
            Func<TSource, TSource, TSource> transformation)
            => MoreEnumerable.Scan(source, transformation);

        /// <summary>
        /// Like <see cref="Enumerable.Aggregate{TSource}"/> except returns
        /// the sequence of intermediate results as well as the final one.
        /// An additional parameter specifies a seed.
        /// </summary>
        /// <remarks>
        /// This operator uses deferred execution and streams its result.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// var result = Enumerable.Range(1, 5).Scan(0, (a, b) => a + b);
        /// ]]></code>
        /// When iterated, <c>result</c> will yield <c>{ 0, 1, 3, 6, 10, 15 }</c>.
        /// </example>
        /// <typeparam name="TSource">Type of elements in source sequence</typeparam>
        /// <typeparam name="TState">Type of state</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="seed">Initial state to seed</param>
        /// <param name="transformation">Transformation operation</param>
        /// <returns>The scanned sequence</returns>

        public static IEnumerable<TState> Scan<TSource, TState>(this IEnumerable<TSource> source,
            TState seed, Func<TState, TSource, TState> transformation)
            => MoreEnumerable.Scan(source, seed, transformation);

    }

    /// <summary><c>ScanBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ScanByExtension
    {
        /// <summary>
        /// Applies an accumulator function over sequence element keys,
        /// returning the keys along with intermediate accumulator states.
        /// </summary>
        /// <typeparam name="TSource">Type of the elements of the source sequence.</typeparam>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TState">Type of the state.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="keySelector">
        /// A function that returns the key given an element.</param>
        /// <param name="seedSelector">
        /// A function to determine the initial value for the accumulator that is
        /// invoked once per key encountered.</param>
        /// <param name="accumulator">
        /// An accumulator function invoked for each element.</param>
        /// <returns>
        /// A sequence of keys paired with intermediate accumulator states.
        /// </returns>

        public static IEnumerable<KeyValuePair<TKey, TState>> ScanBy<TSource, TKey, TState>(
            this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector,
            Func<TKey, TState> seedSelector,
            Func<TState, TKey, TSource, TState> accumulator)
            => MoreEnumerable.ScanBy(source, keySelector, seedSelector, accumulator);

        /// <summary>
        /// Applies an accumulator function over sequence element keys,
        /// returning the keys along with intermediate accumulator states. An
        /// additional parameter specifies the comparer to use to compare keys.
        /// </summary>
        /// <typeparam name="TSource">Type of the elements of the source sequence.</typeparam>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TState">Type of the state.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="keySelector">
        /// A function that returns the key given an element.</param>
        /// <param name="seedSelector">
        /// A function to determine the initial value for the accumulator that is
        /// invoked once per key encountered.</param>
        /// <param name="accumulator">
        /// An accumulator function invoked for each element.</param>
        /// <param name="comparer">The equality comparer to use to determine
        /// whether or not keys are equal. If <c>null</c>, the default equality
        /// comparer for <typeparamref name="TSource"/> is used.</param>
        /// <returns>
        /// A sequence of keys paired with intermediate accumulator states.
        /// </returns>

        public static IEnumerable<KeyValuePair<TKey, TState>> ScanBy<TSource, TKey, TState>(
            this IEnumerable<TSource> source,
            Func<TSource, TKey> keySelector,
            Func<TKey, TState> seedSelector,
            Func<TState, TKey, TSource, TState> accumulator,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.ScanBy(source, keySelector, seedSelector, accumulator, comparer);

    }

    /// <summary><c>ScanRight</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ScanRightExtension
    {
        /// <summary>
        /// Peforms a right-associative scan (inclusive prefix) on a sequence of elements.
        /// This operator is the right-associative version of the
        /// <see cref="MoreEnumerable.Scan{TSource}(IEnumerable{TSource}, Func{TSource, TSource, TSource})"/> LINQ operator.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in source sequence.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="func">
        /// A right-associative accumulator function to be invoked on each element.
        /// Its first argument is the current value in the sequence; second argument is the previous accumulator value.
        /// </param>
        /// <returns>The scanned sequence.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var result = Enumerable.Range(1, 5).Select(i => i.ToString()).ScanRight((a, b) => string.Format("({0}/{1})", a, b));
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>[ "(1+(2+(3+(4+5))))", "(2+(3+(4+5)))", "(3+(4+5))", "(4+5)", "5" ]</c>.
        /// </example>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// Source sequence is consumed greedily when an iteration of the resulting sequence begins.
        /// </remarks>

        public static IEnumerable<TSource> ScanRight<TSource>(this IEnumerable<TSource> source, Func<TSource, TSource, TSource> func)
            => MoreEnumerable.ScanRight(source, func);

        /// <summary>
        /// Peforms a right-associative scan (inclusive prefix) on a sequence of elements.
        /// The specified seed value is used as the initial accumulator value.
        /// This operator is the right-associative version of the
        /// <see cref="MoreEnumerable.Scan{TSource, TState}(IEnumerable{TSource}, TState, Func{TState, TSource, TState})"/> LINQ operator.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of source.</typeparam>
        /// <typeparam name="TAccumulate">The type of the accumulator value.</typeparam>
        /// <param name="source">Source sequence.</param>
        /// <param name="seed">The initial accumulator value.</param>
        /// <param name="func">A right-associative accumulator function to be invoked on each element.</param>
        /// <returns>The scanned sequence.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var result = Enumerable.Range(1, 4).ScanRight("5", (a, b) => string.Format("({0}/{1})", a, b));
        /// ]]></code>
        /// The <c>result</c> variable will contain <c>[ "(1+(2+(3+(4+5))))", "(2+(3+(4+5)))", "(3+(4+5))", "(4+5)", "5" ]</c>.
        /// </example>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// Source sequence is consumed greedily when an iteration of the resulting sequence begins.
        /// </remarks>

        public static IEnumerable<TAccumulate> ScanRight<TSource, TAccumulate>(this IEnumerable<TSource> source, TAccumulate seed, Func<TSource, TAccumulate, TAccumulate> func)
            => MoreEnumerable.ScanRight(source, seed, func);

    }

    /// <summary><c>Segment</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SegmentExtension
    {
        /// <summary>
        /// Divides a sequence into multiple sequences by using a segment detector based on the original sequence
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="source">The sequence to segment</param>
        /// <param name="newSegmentPredicate">A function, which returns <c>true</c> if the given element begins a new segment, and <c>false</c> otherwise</param>
        /// <returns>A sequence of segment, each of which is a portion of the original sequence</returns>
        /// <exception cref="ArgumentNullException">
        /// Thrown if either <paramref name="source"/> or <paramref name="newSegmentPredicate"/> are <see langword="null"/>.
        /// </exception>

        public static IEnumerable<IEnumerable<T>> Segment<T>(this IEnumerable<T> source, Func<T, bool> newSegmentPredicate)
            => MoreEnumerable.Segment(source, newSegmentPredicate);

        /// <summary>
        /// Divides a sequence into multiple sequences by using a segment detector based on the original sequence
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="source">The sequence to segment</param>
        /// <param name="newSegmentPredicate">A function, which returns <c>true</c> if the given element or index indicate a new segment, and <c>false</c> otherwise</param>
        /// <returns>A sequence of segment, each of which is a portion of the original sequence</returns>
        /// <exception cref="ArgumentNullException">
        /// Thrown if either <paramref name="source"/> or <paramref name="newSegmentPredicate"/> are <see langword="null"/>.
        /// </exception>

        public static IEnumerable<IEnumerable<T>> Segment<T>(this IEnumerable<T> source, Func<T, int, bool> newSegmentPredicate)
            => MoreEnumerable.Segment(source, newSegmentPredicate);

        /// <summary>
        /// Divides a sequence into multiple sequences by using a segment detector based on the original sequence
        /// </summary>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <param name="source">The sequence to segment</param>
        /// <param name="newSegmentPredicate">A function, which returns <c>true</c> if the given current element, previous element or index indicate a new segment, and <c>false</c> otherwise</param>
        /// <returns>A sequence of segment, each of which is a portion of the original sequence</returns>
        /// <exception cref="ArgumentNullException">
        /// Thrown if either <paramref name="source"/> or <paramref name="newSegmentPredicate"/> are <see langword="null"/>.
        /// </exception>

        public static IEnumerable<IEnumerable<T>> Segment<T>(this IEnumerable<T> source, Func<T, T, int, bool> newSegmentPredicate)
            => MoreEnumerable.Segment(source, newSegmentPredicate);

    }

    /// <summary><c>Shuffle</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ShuffleExtension
    {
        /// <summary>
        /// Returns a sequence of elements in random order from the original
        /// sequence.
        /// </summary>
        /// <typeparam name="T">The type of source sequence elements.</typeparam>
        /// <param name="source">
        /// The sequence from which to return random elements.</param>
        /// <returns>
        /// A sequence of elements <paramref name="source"/> randomized in
        /// their order.
        /// </returns>
        /// <remarks>
        /// This method uses deferred execution and streams its results. The
        /// source sequence is entirely buffered before the results are
        /// streamed.
        /// </remarks>

        public static IEnumerable<T> Shuffle<T>(this IEnumerable<T> source)
            => MoreEnumerable.Shuffle(source);

        /// <summary>
        /// Returns a sequence of elements in random order from the original
        /// sequence. An additional parameter specifies a random generator to be
        /// used for the random selection algorithm.
        /// </summary>
        /// <typeparam name="T">The type of source sequence elements.</typeparam>
        /// <param name="source">
        /// The sequence from which to return random elements.</param>
        /// <param name="rand">
        /// A random generator used as part of the selection algorithm.</param>
        /// <returns>
        /// A sequence of elements <paramref name="source"/> randomized in
        /// their order.
        /// </returns>
        /// <remarks>
        /// This method uses deferred execution and streams its results. The
        /// source sequence is entirely buffered before the results are
        /// streamed.
        /// </remarks>

        public static IEnumerable<T> Shuffle<T>(this IEnumerable<T> source, Random rand)
            => MoreEnumerable.Shuffle(source, rand);

    }

    /// <summary><c>Single</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SingleExtension
    {

        /// <summary>
        /// Returns the only element of a sequence, and throws an exception if
        /// there is not exactly one element in the sequence.
        /// </summary>
        /// <typeparam name="T">
        /// The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The input sequence.</param>
        /// <exception cref="InvalidOperationException">
        /// The input sequence contains more than one element.</exception>
        /// <returns>
        /// The single element of the input sequence.
        /// </returns>

        public static T Single<T>(this IExtremaEnumerable<T> source)
            => MoreEnumerable.Single(source);

    }

    /// <summary><c>SingleOrDefault</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SingleOrDefaultExtension
    {

        /// <summary>
        /// Returns the only element of a sequence, or a default value if the
        /// sequence is empty; this method throws an exception if there is more
        /// than one element in the sequence.
        /// </summary>
        /// <typeparam name="T">
        /// The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The input sequence.</param>
        /// <returns>
        /// The single element of the input sequence, or default value of type
        /// <typeparamref name="T"/> if the sequence contains no elements.
        /// </returns>

        public static T SingleOrDefault<T>(this IExtremaEnumerable<T> source)
            => MoreEnumerable.SingleOrDefault(source);

    }

    /// <summary><c>SkipLast</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SkipLastExtension
    {
        /// <summary>
        /// Bypasses a specified number of elements at the end of the sequence.
        /// </summary>
        /// <typeparam name="T">Type of the source sequence</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="count">The number of elements to bypass at the end of the source sequence.</param>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> containing the source sequence elements except for the bypassed ones at the end.
        /// </returns>

        public static IEnumerable<T> SkipLast<T>(this IEnumerable<T> source, int count)
            => MoreEnumerable.SkipLast(source, count);

    }

    /// <summary><c>SkipUntil</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SkipUntilExtension
    {
        /// <summary>
        /// Skips items from the input sequence until the given predicate returns true
        /// when applied to the current source item; that item will be the last skipped.
        /// </summary>
        /// <remarks>
        /// <para>
        /// SkipUntil differs from Enumerable.SkipWhile in two respects. Firstly, the sense
        /// of the predicate is reversed: it is expected that the predicate will return false
        /// to start with, and then return true - for example, when trying to find a matching
        /// item in a sequence.
        /// </para>
        /// <para>
        /// Secondly, SkipUntil skips the element which causes the predicate to return true. For
        /// example, in a sequence <code><![CDATA[{ 1, 2, 3, 4, 5 }]]></code> and with a predicate of
        /// <code><![CDATA[x => x == 3]]></code>, the result would be <code><![CDATA[{ 4, 5 }]]></code>.
        /// </para>
        /// <para>
        /// SkipUntil is as lazy as possible: it will not iterate over the source sequence
        /// until it has to, it won't iterate further than it has to, and it won't evaluate
        /// the predicate until it has to. (This means that an item may be returned which would
        /// actually cause the predicate to throw an exception if it were evaluated, so long as
        /// it comes after the first item causing the predicate to return true.)
        /// </para>
        /// </remarks>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="predicate">Predicate used to determine when to stop yielding results from the source.</param>
        /// <returns>Items from the source sequence after the predicate first returns true when applied to the item.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> or <paramref name="predicate"/> is null</exception>

        public static IEnumerable<TSource> SkipUntil<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate)
            => MoreEnumerable.SkipUntil(source, predicate);

    }

    /// <summary><c>Slice</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SliceExtension
    {
        /// <summary>
        /// Extracts a contiguous count of elements from a sequence at a particular zero-based starting index
        /// </summary>
        /// <remarks>
        /// If the starting position or count specified result in slice extending past the end of the sequence,
        /// it will return all elements up to that point. There is no guarantee that the resulting sequence will
        /// contain the number of elements requested - it may have anywhere from 0 to <paramref name="count"/>.<br/>
        /// This method is implemented in an optimized manner for any sequence implementing <c>IList{T}</c>.<br/>
        /// The result of Slice() is identical to: <c>sequence.Skip(startIndex).Take(count)</c>
        /// </remarks>
        /// <typeparam name="T">The type of the elements in the source sequence</typeparam>
        /// <param name="sequence">The sequence from which to extract elements</param>
        /// <param name="startIndex">The zero-based index at which to begin slicing</param>
        /// <param name="count">The number of items to slice out of the index</param>
        /// <returns>A new sequence containing any elements sliced out from the source sequence</returns>

        public static IEnumerable<T> Slice<T>(this IEnumerable<T> sequence, int startIndex, int count)
            => MoreEnumerable.Slice(sequence, startIndex, count);

    }

    /// <summary><c>SortedMerge</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SortedMergeExtension
    {
        /// <summary>
        /// Merges two or more sequences that are in a common order (either ascending or descending) into
        /// a single sequence that preserves that order.
        /// </summary>
        /// <remarks>
        /// Using SortedMerge on sequences that are not ordered or are not in the same order produces
        /// undefined results.<br/>
        /// <c>SortedMerge</c> uses performs the merge in a deferred, streaming manner. <br/>
        ///
        /// Here is an example of a merge, as well as the produced result:
        /// <code><![CDATA[
        ///   var s1 = new[] { 3, 7, 11 };
        ///   var s2 = new[] { 2, 4, 20 };
        ///   var s3 = new[] { 17, 19, 25 };
        ///   var merged = s1.SortedMerge( OrderByDirection.Ascending, s2, s3 );
        ///   var result = merged.ToArray();
        ///   // result will be:
        ///   // { 2, 3, 4, 7, 11, 17, 19, 20, 25 }
        /// ]]></code>
        /// </remarks>
        /// <typeparam name="TSource">The type of the elements of the sequence</typeparam>
        /// <param name="source">The primary sequence with which to merge</param>
        /// <param name="direction">The ordering that all sequences must already exhibit</param>
        /// <param name="otherSequences">A variable argument array of zero or more other sequences to merge with</param>
        /// <returns>A merged, order-preserving sequence containing all of the elements of the original sequences</returns>

        public static IEnumerable<TSource> SortedMerge<TSource>(this IEnumerable<TSource> source, OrderByDirection direction, params IEnumerable<TSource>[] otherSequences)
            => MoreEnumerable.SortedMerge(source, direction, otherSequences);

        /// <summary>
        /// Merges two or more sequences that are in a common order (either ascending or descending) into
        /// a single sequence that preserves that order.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements in the sequence</typeparam>
        /// <param name="source">The primary sequence with which to merge</param>
        /// <param name="direction">The ordering that all sequences must already exhibit</param>
        /// <param name="comparer">The comparer used to evaluate the relative order between elements</param>
        /// <param name="otherSequences">A variable argument array of zero or more other sequences to merge with</param>
        /// <returns>A merged, order-preserving sequence containing al of the elements of the original sequences</returns>

        public static IEnumerable<TSource> SortedMerge<TSource>(this IEnumerable<TSource> source, OrderByDirection direction, IComparer<TSource> comparer, params IEnumerable<TSource>[] otherSequences)
            => MoreEnumerable.SortedMerge(source, direction, comparer, otherSequences);

    }

    /// <summary><c>Split</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SplitExtension
    {

        /// <summary>
        /// Splits the source sequence by a separator.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separator">Separator element.</param>
        /// <returns>A sequence of splits of elements.</returns>

        public static IEnumerable<IEnumerable<TSource>> Split<TSource>(this IEnumerable<TSource> source,
            TSource separator)
            => MoreEnumerable.Split(source, separator);

        /// <summary>
        /// Splits the source sequence by separator elements identified by a
        /// function.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separatorFunc">Predicate function used to determine
        /// the splitter elements in the source sequence.</param>
        /// <returns>A sequence of splits of elements.</returns>

        public static IEnumerable<IEnumerable<TSource>> Split<TSource>(this IEnumerable<TSource> source,
            Func<TSource, bool> separatorFunc)
            => MoreEnumerable.Split(source, separatorFunc);

        /// <summary>
        /// Splits the source sequence by a separator given a maximum count of splits.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separator">Separator element.</param>
        /// <param name="count">Maximum number of splits.</param>
        /// <returns>A sequence of splits of elements.</returns>

        public static IEnumerable<IEnumerable<TSource>> Split<TSource>(this IEnumerable<TSource> source,
            TSource separator, int count)
            => MoreEnumerable.Split(source, separator, count);

        /// <summary>
        /// Splits the source sequence by a separator and then transforms the
        /// splits into results.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separator">Separator element.</param>
        /// <param name="comparer">Comparer used to determine separator
        /// element equality.</param>
        /// <returns>A sequence of splits of elements.</returns>

        public static IEnumerable<IEnumerable<TSource>> Split<TSource>(this IEnumerable<TSource> source,
            TSource separator, IEqualityComparer<TSource> comparer)
            => MoreEnumerable.Split(source, separator, comparer);

        /// <summary>
        /// Splits the source sequence by separator elements identified by a
        /// function, given a maximum count of splits.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separatorFunc">Predicate function used to determine
        /// the splitter elements in the source sequence.</param>
        /// <param name="count">Maximum number of splits.</param>
        /// <returns>A sequence of splits of elements.</returns>

        public static IEnumerable<IEnumerable<TSource>> Split<TSource>(this IEnumerable<TSource> source,
            Func<TSource, bool> separatorFunc, int count)
            => MoreEnumerable.Split(source, separatorFunc, count);

        /// <summary>
        /// Splits the source sequence by a separator, given a maximum count
        /// of splits. A parameter specifies how the separator is compared
        /// for equality.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separator">Separator element.</param>
        /// <param name="comparer">Comparer used to determine separator
        /// element equality.</param>
        /// <param name="count">Maximum number of splits.</param>
        /// <returns>A sequence of splits of elements.</returns>

        public static IEnumerable<IEnumerable<TSource>> Split<TSource>(this IEnumerable<TSource> source,
            TSource separator, IEqualityComparer<TSource> comparer, int count)
            => MoreEnumerable.Split(source, separator, comparer, count);

        /// <summary>
        /// Splits the source sequence by a separator and then transforms
        /// the splits into results.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <typeparam name="TResult">Type of the result sequence elements.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separator">Separator element.</param>
        /// <param name="resultSelector">Function used to project splits
        /// of source elements into elements of the resulting sequence.</param>
        /// <returns>
        /// A sequence of values typed as <typeparamref name="TResult"/>.
        /// </returns>

        public static IEnumerable<TResult> Split<TSource, TResult>(this IEnumerable<TSource> source,
            TSource separator,
            Func<IEnumerable<TSource>, TResult> resultSelector)
            => MoreEnumerable.Split(source, separator, resultSelector);

        /// <summary>
        /// Splits the source sequence by separator elements identified by
        /// a function and then transforms the splits into results.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <typeparam name="TResult">Type of the result sequence elements.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separatorFunc">Predicate function used to determine
        /// the splitter elements in the source sequence.</param>
        /// <param name="resultSelector">Function used to project splits
        /// of source elements into elements of the resulting sequence.</param>
        /// <returns>
        /// A sequence of values typed as <typeparamref name="TResult"/>.
        /// </returns>

        public static IEnumerable<TResult> Split<TSource, TResult>(this IEnumerable<TSource> source,
            Func<TSource, bool> separatorFunc,
            Func<IEnumerable<TSource>, TResult> resultSelector)
            => MoreEnumerable.Split(source, separatorFunc, resultSelector);

        /// <summary>
        /// Splits the source sequence by a separator, given a maximum count
        /// of splits, and then transforms the splits into results.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <typeparam name="TResult">Type of the result sequence elements.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separator">Separator element.</param>
        /// <param name="count">Maximum number of splits.</param>
        /// <param name="resultSelector">Function used to project splits
        /// of source elements into elements of the resulting sequence.</param>
        /// <returns>
        /// A sequence of values typed as <typeparamref name="TResult"/>.
        /// </returns>

        public static IEnumerable<TResult> Split<TSource, TResult>(this IEnumerable<TSource> source,
            TSource separator, int count,
            Func<IEnumerable<TSource>, TResult> resultSelector)
            => MoreEnumerable.Split(source, separator, count, resultSelector);

        /// <summary>
        /// Splits the source sequence by a separator and then transforms the
        /// splits into results. A parameter specifies how the separator is
        /// compared for equality.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <typeparam name="TResult">Type of the result sequence elements.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separator">Separator element.</param>
        /// <param name="comparer">Comparer used to determine separator
        /// element equality.</param>
        /// <param name="resultSelector">Function used to project splits
        /// of source elements into elements of the resulting sequence.</param>
        /// <returns>
        /// A sequence of values typed as <typeparamref name="TResult"/>.
        /// </returns>

        public static IEnumerable<TResult> Split<TSource, TResult>(this IEnumerable<TSource> source,
            TSource separator, IEqualityComparer<TSource> comparer,
            Func<IEnumerable<TSource>, TResult> resultSelector)
            => MoreEnumerable.Split(source, separator, comparer, resultSelector);

        /// <summary>
        /// Splits the source sequence by separator elements identified by
        /// a function, given a maximum count of splits, and then transforms
        /// the splits into results.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <typeparam name="TResult">Type of the result sequence elements.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separatorFunc">Predicate function used to determine
        /// the splitter elements in the source sequence.</param>
        /// <param name="count">Maximum number of splits.</param>
        /// <param name="resultSelector">Function used to project a split
        /// group of source elements into an element of the resulting sequence.</param>
        /// <returns>
        /// A sequence of values typed as <typeparamref name="TResult"/>.
        /// </returns>

        public static IEnumerable<TResult> Split<TSource, TResult>(this IEnumerable<TSource> source,
            Func<TSource, bool> separatorFunc, int count,
            Func<IEnumerable<TSource>, TResult> resultSelector)
            => MoreEnumerable.Split(source, separatorFunc, count, resultSelector);

        /// <summary>
        /// Splits the source sequence by a separator, given a maximum count
        /// of splits, and then transforms the splits into results. A
        /// parameter specifies how the separator is compared for equality.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence.</typeparam>
        /// <typeparam name="TResult">Type of the result sequence elements.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="separator">Separator element.</param>
        /// <param name="comparer">Comparer used to determine separator
        /// element equality.</param>
        /// <param name="count">Maximum number of splits.</param>
        /// <param name="resultSelector">Function used to project splits
        /// of source elements into elements of the resulting sequence.</param>
        /// <returns>
        /// A sequence of values typed as <typeparamref name="TResult"/>.
        /// </returns>

        public static IEnumerable<TResult> Split<TSource, TResult>(this IEnumerable<TSource> source,
            TSource separator, IEqualityComparer<TSource> comparer, int count,
            Func<IEnumerable<TSource>, TResult> resultSelector)
            => MoreEnumerable.Split(source, separator, comparer, count, resultSelector);

    }

    /// <summary><c>StartsWith</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class StartsWithExtension
    {
        /// <summary>
        /// Determines whether the beginning of the first sequence is
        /// equivalent to the second sequence, using the default equality
        /// comparer.
        /// </summary>
        /// <typeparam name="T">Type of elements.</typeparam>
        /// <param name="first">The sequence to check.</param>
        /// <param name="second">The sequence to compare to.</param>
        /// <returns>
        /// <c>true</c> if <paramref name="first" /> begins with elements
        /// equivalent to <paramref name="second" />.
        /// </returns>
        /// <remarks>
        /// This is the <see cref="IEnumerable{T}" /> equivalent of
        /// <see cref="string.StartsWith(string)" /> and it calls
        /// <see cref="IEqualityComparer{T}.Equals(T,T)" /> using
        /// <see cref="EqualityComparer{T}.Default"/> on pairs of elements at
        /// the same index.
        /// </remarks>

        public static bool StartsWith<T>(this IEnumerable<T> first, IEnumerable<T> second)
            => MoreEnumerable.StartsWith(first, second);

        /// <summary>
        /// Determines whether the beginning of the first sequence is
        /// equivalent to the second sequence, using the specified element
        /// equality comparer.
        /// </summary>
        /// <typeparam name="T">Type of elements.</typeparam>
        /// <param name="first">The sequence to check.</param>
        /// <param name="second">The sequence to compare to.</param>
        /// <param name="comparer">Equality comparer to use.</param>
        /// <returns>
        /// <c>true</c> if <paramref name="first" /> begins with elements
        /// equivalent to <paramref name="second" />.
        /// </returns>
        /// <remarks>
        /// This is the <see cref="IEnumerable{T}" /> equivalent of
        /// <see cref="string.StartsWith(string)" /> and
        /// it calls <see cref="IEqualityComparer{T}.Equals(T,T)" /> on pairs
        /// of elements at the same index.
        /// </remarks>

        public static bool StartsWith<T>(this IEnumerable<T> first, IEnumerable<T> second, IEqualityComparer<T> comparer)
            => MoreEnumerable.StartsWith(first, second, comparer);

    }

    /// <summary><c>Subsets</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class SubsetsExtension
    {
        /// <summary>
        /// Returns a sequence of <see cref="IList{T}"/> representing all of
        /// the subsets of any size that are part of the original sequence. In
        /// mathematics, it is equivalent to the <em>power set</em> of a set.
        /// </summary>
        /// <remarks>
        /// This operator produces all of the subsets of a given sequence. Subsets are returned
        /// in increasing cardinality, starting with the empty set and terminating with the
        /// entire original sequence.<br/>
        /// Subsets are produced in a deferred, streaming manner; however, each subset is returned
        /// as a materialized list.<br/>
        /// There are 2^N subsets of a given sequence, where N => sequence.Count().
        /// </remarks>
        /// <param name="sequence">Sequence for which to produce subsets</param>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <returns>A sequence of lists that represent the all subsets of the original sequence</returns>
        /// <exception cref="ArgumentNullException">Thrown if <paramref name="sequence"/> is <see langword="null"/></exception>

        public static IEnumerable<IList<T>> Subsets<T>(this IEnumerable<T> sequence)
            => MoreEnumerable.Subsets(sequence);

        /// <summary>
        /// Returns a sequence of <see cref="IList{T}"/> representing all
        /// subsets of a given size that are part of the original sequence. In
        /// mathematics, it is equivalent to the <em>combinations</em> or
        /// <em>k-subsets</em> of a set.
        /// </summary>
        /// <param name="sequence">Sequence for which to produce subsets</param>
        /// <param name="subsetSize">The size of the subsets to produce</param>
        /// <typeparam name="T">The type of the elements in the sequence</typeparam>
        /// <returns>A sequence of lists that represents of K-sized subsets of the original sequence</returns>
        /// <exception cref="ArgumentNullException">
        /// Thrown if <paramref name="sequence"/> is <see langword="null"/>
        /// </exception>
        /// <exception cref="ArgumentOutOfRangeException">
        /// Thrown if <paramref name="subsetSize"/> is less than zero.
        /// </exception>

        public static IEnumerable<IList<T>> Subsets<T>(this IEnumerable<T> sequence, int subsetSize)
            => MoreEnumerable.Subsets(sequence, subsetSize);

    }

    /// <summary><c>TagFirstLast</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class TagFirstLastExtension
    {
        /// <summary>
        /// Returns a sequence resulting from applying a function to each
        /// element in the source sequence with additional parameters
        /// indicating whether the element is the first and/or last of the
        /// sequence.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <typeparam name="TResult">The type of the element of the returned sequence.</typeparam>
        /// <param name="source">The source sequence.</param>
        /// <param name="resultSelector">A function that determines how to
        /// project the each element along with its first or last tag.</param>
        /// <returns>
        /// Returns the resulting sequence.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 123, 456, 789 };
        /// var result = numbers.TagFirstLast((num, fst, lst) => new
        ///              {
        ///                  Number = num,
        ///                  IsFirst = fst, IsLast = lst
        ///              });
        /// ]]></code>
        /// The <c>result</c> variable, when iterated over, will yield
        /// <c>{ Number = 123, IsFirst = True, IsLast = False }</c>,
        /// <c>{ Number = 456, IsFirst = False, IsLast = False }</c> and
        /// <c>{ Number = 789, IsFirst = False, IsLast = True }</c> in turn.
        /// </example>

        public static IEnumerable<TResult> TagFirstLast<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, bool, bool, TResult> resultSelector)
            => MoreEnumerable.TagFirstLast(source, resultSelector);

    }

    /// <summary><c>TakeEvery</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class TakeEveryExtension
    {
        /// <summary>
        /// Returns every N-th element of a sequence.
        /// </summary>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="step">Number of elements to bypass before returning the next element.</param>
        /// <returns>
        /// A sequence with every N-th element of the input sequence.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] numbers = { 1, 2, 3, 4, 5 };
        /// var result = numbers.TakeEvery(2);
        /// ]]></code>
        /// The <c>result</c> variable, when iterated over, will yield 1, 3 and 5, in turn.
        /// </example>

        public static IEnumerable<TSource> TakeEvery<TSource>(this IEnumerable<TSource> source, int step)
            => MoreEnumerable.TakeEvery(source, step);

    }

    /// <summary><c>TakeLast</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class TakeLastExtension
    {
        /// <summary>
        /// Returns a specified number of contiguous elements from the end of
        /// a sequence.
        /// </summary>
        /// <typeparam name="TSource">The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">The sequence to return the last element of.</param>
        /// <param name="count">The number of elements to return.</param>
        /// <returns>
        /// An <see cref="IEnumerable{T}"/> that contains the specified number of
        /// elements from the end of the input sequence.
        /// </returns>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// int[] numbers = { 12, 34, 56, 78 };
        /// var result = numbers.TakeLast(2);
        /// ]]></code>
        /// The <c>result</c> variable, when iterated over, will yield
        /// 56 and 78 in turn.
        /// </example>

        public static IEnumerable<TSource> TakeLast<TSource>(this IEnumerable<TSource> source, int count)
            => MoreEnumerable.TakeLast(source, count);

    }

    /// <summary><c>TakeUntil</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class TakeUntilExtension
    {
        /// <summary>
        /// Returns items from the input sequence until the given predicate returns true
        /// when applied to the current source item; that item will be the last returned.
        /// </summary>
        /// <remarks>
        /// <para>
        /// TakeUntil differs from Enumerable.TakeWhile in two respects. Firstly, the sense
        /// of the predicate is reversed: it is expected that the predicate will return false
        /// to start with, and then return true - for example, when trying to find a matching
        /// item in a sequence.
        /// </para>
        /// <para>
        /// Secondly, TakeUntil yields the element which causes the predicate to return true. For
        /// example, in a sequence <code><![CDATA[{ 1, 2, 3, 4, 5 }]]></code> and with a predicate of
        /// <code><![CDATA[x => x == 3]]></code>, the result would be <code><![CDATA[{ 1, 2, 3 }]]></code>.
        /// </para>
        /// <para>
        /// TakeUntil is as lazy as possible: it will not iterate over the source sequence
        /// until it has to, it won't iterate further than it has to, and it won't evaluate
        /// the predicate until it has to. (This means that an item may be returned which would
        /// actually cause the predicate to throw an exception if it were evaluated, so long as
        /// no more items of data are requested.)
        /// </para>
        /// </remarks>
        /// <typeparam name="TSource">Type of the source sequence</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="predicate">Predicate used to determine when to stop yielding results from the source.</param>
        /// <returns>Items from the source sequence, until the predicate returns true when applied to the item.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> or <paramref name="predicate"/> is null</exception>

        public static IEnumerable<TSource> TakeUntil<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate)
            => MoreEnumerable.TakeUntil(source, predicate);

    }

    /// <summary><c>ThenBy</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ThenByExtension
    {

        /// <summary>
        /// Performs a subsequent ordering of elements in a sequence in a particular direction (ascending, descending) according to a key
        /// </summary>
        /// <typeparam name="T">The type of the elements in the source sequence</typeparam>
        /// <typeparam name="TKey">The type of the key used to order elements</typeparam>
        /// <param name="source">The sequence to order</param>
        /// <param name="keySelector">A key selector function</param>
        /// <param name="direction">A direction in which to order the elements (ascending, descending)</param>
        /// <returns>An ordered copy of the source sequence</returns>

        public static IOrderedEnumerable<T> ThenBy<T, TKey>(this IOrderedEnumerable<T> source, Func<T, TKey> keySelector, OrderByDirection direction)
            => MoreEnumerable.ThenBy(source, keySelector, direction);

        /// <summary>
        /// Performs a subsequent ordering of elements in a sequence in a particular direction (ascending, descending) according to a key
        /// </summary>
        /// <typeparam name="T">The type of the elements in the source sequence</typeparam>
        /// <typeparam name="TKey">The type of the key used to order elements</typeparam>
        /// <param name="source">The sequence to order</param>
        /// <param name="keySelector">A key selector function</param>
        /// <param name="direction">A direction in which to order the elements (ascending, descending)</param>
        /// <param name="comparer">A comparer used to define the semantics of element comparison</param>
        /// <returns>An ordered copy of the source sequence</returns>

        public static IOrderedEnumerable<T> ThenBy<T, TKey>(this IOrderedEnumerable<T> source, Func<T, TKey> keySelector, IComparer<TKey> comparer, OrderByDirection direction)
            => MoreEnumerable.ThenBy(source, keySelector, comparer, direction);

    }

    /// <summary><c>ToArrayByIndex</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ToArrayByIndexExtension
    {
        /// <summary>
        /// Creates an array from an <see cref="IEnumerable{T}"/> where a
        /// function is used to determine the index at which an element will
        /// be placed in the array.
        /// </summary>
        /// <param name="source">The source sequence for the array.</param>
        /// <param name="indexSelector">
        /// A function that maps an element to its index.</param>
        /// <typeparam name="T">
        /// The type of the element in <paramref name="source"/>.</typeparam>
        /// <returns>
        /// An array that contains the elements from the input sequence. The
        /// size of the array will be as large as the highest index returned
        /// by the <paramref name="indexSelector"/> plus 1.
        /// </returns>
        /// <remarks>
        /// This method forces immediate query evaluation. It should not be
        /// used on infinite sequences. If more than one element maps to the
        /// same index then the latter element overwrites the former in the
        /// resulting array.
        /// </remarks>

        public static T[] ToArrayByIndex<T>(this IEnumerable<T> source,
            Func<T, int> indexSelector)
            => MoreEnumerable.ToArrayByIndex(source, indexSelector);

        /// <summary>
        /// Creates an array of user-specified length from an
        /// <see cref="IEnumerable{T}"/> where a function is used to determine
        /// the index at which an element will be placed in the array.
        /// </summary>
        /// <param name="source">The source sequence for the array.</param>
        /// <param name="length">The (non-negative) length of the resulting array.</param>
        /// <param name="indexSelector">
        /// A function that maps an element to its index.</param>
        /// <typeparam name="T">
        /// The type of the element in <paramref name="source"/>.</typeparam>
        /// <returns>
        /// An array of size <paramref name="length"/> that contains the
        /// elements from the input sequence.
        /// </returns>
        /// <remarks>
        /// This method forces immediate query evaluation. It should not be
        /// used on infinite sequences. If more than one element maps to the
        /// same index then the latter element overwrites the former in the
        /// resulting array.
        /// </remarks>

        public static T[] ToArrayByIndex<T>(this IEnumerable<T> source, int length,
            Func<T, int> indexSelector)
            => MoreEnumerable.ToArrayByIndex(source, length, indexSelector);

        /// <summary>
        /// Creates an array from an <see cref="IEnumerable{T}"/> where a
        /// function is used to determine the index at which an element will
        /// be placed in the array. The elements are projected into the array
        /// via an additional function.
        /// </summary>
        /// <param name="source">The source sequence for the array.</param>
        /// <param name="indexSelector">
        /// A function that maps an element to its index.</param>
        /// <param name="resultSelector">
        /// A function to project a source element into an element of the
        /// resulting array.</param>
        /// <typeparam name="T">
        /// The type of the element in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the element in the resulting array.</typeparam>
        /// <returns>
        /// An array that contains the projected elements from the input
        /// sequence. The size of the array will be as large as the highest
        /// index returned by the <paramref name="indexSelector"/> plus 1.
        /// </returns>
        /// <remarks>
        /// This method forces immediate query evaluation. It should not be
        /// used on infinite sequences. If more than one element maps to the
        /// same index then the latter element overwrites the former in the
        /// resulting array.
        /// </remarks>

        public static TResult[] ToArrayByIndex<T, TResult>(this IEnumerable<T> source,
            Func<T, int> indexSelector, Func<T, TResult> resultSelector)
            => MoreEnumerable.ToArrayByIndex(source, indexSelector, resultSelector);

        /// <summary>
        /// Creates an array from an <see cref="IEnumerable{T}"/> where a
        /// function is used to determine the index at which an element will
        /// be placed in the array. The elements are projected into the array
        /// via an additional function.
        /// </summary>
        /// <param name="source">The source sequence for the array.</param>
        /// <param name="indexSelector">
        /// A function that maps an element to its index.</param>
        /// <param name="resultSelector">
        /// A function to project a source element into an element of the
        /// resulting array.</param>
        /// <typeparam name="T">
        /// The type of the element in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the element in the resulting array.</typeparam>
        /// <returns>
        /// An array that contains the projected elements from the input
        /// sequence. The size of the array will be as large as the highest
        /// index returned by the <paramref name="indexSelector"/> plus 1.
        /// </returns>
        /// <remarks>
        /// This method forces immediate query evaluation. It should not be
        /// used on infinite sequences. If more than one element maps to the
        /// same index then the latter element overwrites the former in the
        /// resulting array.
        /// </remarks>

        public static TResult[] ToArrayByIndex<T, TResult>(this IEnumerable<T> source,
            Func<T, int> indexSelector, Func<T, int, TResult> resultSelector)
            => MoreEnumerable.ToArrayByIndex(source, indexSelector, resultSelector);

        /// <summary>
        /// Creates an array of user-specified length from an
        /// <see cref="IEnumerable{T}"/> where a function is used to determine
        /// the index at which an element will be placed in the array. The
        /// elements are projected into the array via an additional function.
        /// </summary>
        /// <param name="source">The source sequence for the array.</param>
        /// <param name="length">The (non-negative) length of the resulting array.</param>
        /// <param name="indexSelector">
        /// A function that maps an element to its index.</param>
        /// <param name="resultSelector">
        /// A function to project a source element into an element of the
        /// resulting array.</param>
        /// <typeparam name="T">
        /// The type of the element in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the element in the resulting array.</typeparam>
        /// <returns>
        /// An array of size <paramref name="length"/> that contains the
        /// projected elements from the input sequence.
        /// </returns>
        /// <remarks>
        /// This method forces immediate query evaluation. It should not be
        /// used on infinite sequences. If more than one element maps to the
        /// same index then the latter element overwrites the former in the
        /// resulting array.
        /// </remarks>

        public static TResult[] ToArrayByIndex<T, TResult>(this IEnumerable<T> source, int length,
            Func<T, int> indexSelector, Func<T, TResult> resultSelector)
            => MoreEnumerable.ToArrayByIndex(source, length, indexSelector, resultSelector);

        /// <summary>
        /// Creates an array of user-specified length from an
        /// <see cref="IEnumerable{T}"/> where a function is used to determine
        /// the index at which an element will be placed in the array. The
        /// elements are projected into the array via an additional function.
        /// </summary>
        /// <param name="source">The source sequence for the array.</param>
        /// <param name="length">The (non-negative) length of the resulting array.</param>
        /// <param name="indexSelector">
        /// A function that maps an element to its index.</param>
        /// <param name="resultSelector">
        /// A function to project a source element into an element of the
        /// resulting array.</param>
        /// <typeparam name="T">
        /// The type of the element in <paramref name="source"/>.</typeparam>
        /// <typeparam name="TResult">
        /// The type of the element in the resulting array.</typeparam>
        /// <returns>
        /// An array of size <paramref name="length"/> that contains the
        /// projected elements from the input sequence.
        /// </returns>
        /// <remarks>
        /// This method forces immediate query evaluation. It should not be
        /// used on infinite sequences. If more than one element maps to the
        /// same index then the latter element overwrites the former in the
        /// resulting array.
        /// </remarks>

        public static TResult[] ToArrayByIndex<T, TResult>(this IEnumerable<T> source, int length,
            Func<T, int> indexSelector, Func<T, int, TResult> resultSelector)
            => MoreEnumerable.ToArrayByIndex(source, length, indexSelector, resultSelector);

    }

    /// <summary><c>ToDelimitedString</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ToDelimitedStringExtension
    {
        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<bool> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<byte> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<char> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<decimal> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<double> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<float> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<int> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<long> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>
        [CLSCompliant(false)]
        public static string ToDelimitedString(this IEnumerable<sbyte> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<short> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString(this IEnumerable<string> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>
        [CLSCompliant(false)]
        public static string ToDelimitedString(this IEnumerable<uint> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>
        [CLSCompliant(false)]
        public static string ToDelimitedString(this IEnumerable<ulong> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>
        [CLSCompliant(false)]
        public static string ToDelimitedString(this IEnumerable<ushort> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);
        /// <summary>
        /// Creates a delimited string from a sequence of values and
        /// a given delimiter.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence</typeparam>
        /// <param name="source">The sequence of items to delimit. Each is converted to a string using the
        /// simple ToString() conversion.</param>
        /// <param name="delimiter">The delimiter to inject between elements.</param>
        /// <returns>
        /// A string that consists of the elements in <paramref name="source"/>
        /// delimited by <paramref name="delimiter"/>. If the source sequence
        /// is empty, the method returns an empty string.
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="source"/> or <paramref name="delimiter"/> is <c>null</c>.
        /// </exception>
        /// <remarks>
        /// This operator uses immediate execution and effectively buffers the sequence.
        /// </remarks>

        public static string ToDelimitedString<TSource>(this IEnumerable<TSource> source, string delimiter)
            => MoreEnumerable.ToDelimitedString(source, delimiter);

    }

    /// <summary><c>ToDictionary</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ToDictionaryExtension
    {

        /// <summary>
        /// Creates a <see cref="Dictionary{TKey,TValue}" /> from a sequence of
        /// tuples of 2 where the first item is the key and the second the
        /// value.
        /// </summary>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TValue">The type of the value.</typeparam>
        /// <param name="source">The source sequence of couples (tuple of 2).</param>
        /// <returns>
        /// A <see cref="Dictionary{TKey, TValue}"/> containing the values
        /// mapped to their keys.
        /// </returns>

        public static Dictionary<TKey, TValue> ToDictionary<TKey, TValue>(this IEnumerable<(TKey Key, TValue Value)> source)             => MoreEnumerable.ToDictionary(source);
        /// <summary>
        /// Creates a <see cref="Dictionary{TKey,TValue}" /> from a sequence of
        /// <see cref="KeyValuePair{TKey,TValue}" /> elements.
        /// </summary>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TValue">The type of the value.</typeparam>
        /// <param name="source">The source sequence of key-value pairs.</param>
        /// <returns>
        /// A <see cref="Dictionary{TKey, TValue}"/> containing the values
        /// mapped to their keys.
        /// </returns>

        public static Dictionary<TKey, TValue> ToDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source)             => MoreEnumerable.ToDictionary(source);

        /// <summary>
        /// Creates a <see cref="Dictionary{TKey,TValue}" /> from a sequence of
        /// tuples of 2 where the first item is the key and the second the
        /// value. An additional parameter specifies a comparer for keys.
        /// </summary>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TValue">The type of the value.</typeparam>
        /// <param name="source">The source sequence of couples (tuple of 2).</param>
        /// <param name="comparer">The comparer for keys.</param>
        /// <returns>
        /// A <see cref="Dictionary{TKey, TValue}"/> containing the values
        /// mapped to their keys.
        /// </returns>

        public static Dictionary<TKey, TValue> ToDictionary<TKey, TValue>(this IEnumerable<(TKey Key, TValue Value)> source,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.ToDictionary(source, comparer);

        /// <summary>
        /// Creates a <see cref="Dictionary{TKey,TValue}" /> from a sequence of
        /// <see cref="KeyValuePair{TKey,TValue}" /> elements. An additional
        /// parameter specifies a comparer for keys.
        /// </summary>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TValue">The type of the value.</typeparam>
        /// <param name="source">The source sequence of key-value pairs.</param>
        /// <param name="comparer">The comparer for keys.</param>
        /// <returns>
        /// A <see cref="Dictionary{TKey, TValue}"/> containing the values
        /// mapped to their keys.
        /// </returns>

        public static Dictionary<TKey, TValue> ToDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.ToDictionary(source, comparer);

    }

    /// <summary><c>ToHashSet</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ToHashSetExtension
    {
        /// <summary>
        /// Returns a <see cref="HashSet{T}"/> of the source items using the default equality
        /// comparer for the type.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in source sequence.</typeparam>
        /// <param name="source">Source sequence</param>
        /// <returns>A hash set of the items in the sequence, using the default equality comparer.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <remarks>
        /// This evaluates the input sequence completely.
        /// </remarks>

        public static HashSet<TSource> ToHashSet<TSource>(this IEnumerable<TSource> source)
            => MoreEnumerable.ToHashSet(source);

        /// <summary>
        /// Returns a <see cref="HashSet{T}"/> of the source items using the specified equality
        /// comparer for the type.
        /// </summary>
        /// <typeparam name="TSource">Type of elements in source sequence.</typeparam>
        /// <param name="source">Source sequence</param>
        /// <param name="comparer">Equality comparer to use; a value of null will cause the type's default equality comparer to be used</param>
        /// <returns>A hash set of the items in the sequence, using the default equality comparer.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="source"/> is null</exception>
        /// <remarks>
        /// This evaluates the input sequence completely.
        /// </remarks>

        public static HashSet<TSource> ToHashSet<TSource>(this IEnumerable<TSource> source, IEqualityComparer<TSource> comparer)
            => MoreEnumerable.ToHashSet(source, comparer);

    }

    /// <summary><c>ToLookup</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ToLookupExtension
    {

        /// <summary>
        /// Creates a <see cref="Lookup{TKey,TValue}" /> from a sequence of
        /// tuples of 2 where the first item is the key and the second the
        /// value.
        /// </summary>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TValue">The type of the value.</typeparam>
        /// <param name="source">The source sequence of tuples of 2.</param>
        /// <returns>
        /// A <see cref="Lookup{TKey, TValue}"/> containing the values
        /// mapped to their keys.
        /// </returns>

        public static ILookup<TKey, TValue> ToLookup<TKey, TValue>(this IEnumerable<(TKey Key, TValue Value)> source)             => MoreEnumerable.ToLookup(source);
        /// <summary>
        /// Creates a <see cref="ILookup{TKey,TValue}" /> from a sequence of
        /// <see cref="KeyValuePair{TKey,TValue}" /> elements.
        /// </summary>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TValue">The type of the value.</typeparam>
        /// <param name="source">The source sequence of key-value pairs.</param>
        /// <returns>
        /// A <see cref="ILookup{TKey,TValue}"/> containing the values
        /// mapped to their keys.
        /// </returns>

        public static ILookup<TKey, TValue> ToLookup<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source)             => MoreEnumerable.ToLookup(source);

        /// <summary>
        /// Creates a <see cref="Lookup{TKey,TValue}" /> from a sequence of
        /// tuples of 2 where the first item is the key and the second the
        /// value. An additional parameter specifies a comparer for keys.
        /// </summary>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TValue">The type of the value.</typeparam>
        /// <param name="source">The source sequence of tuples of 2.</param>
        /// <param name="comparer">The comparer for keys.</param>
        /// <returns>
        /// A <see cref="Lookup{TKey, TValue}"/> containing the values
        /// mapped to their keys.
        /// </returns>

        public static ILookup<TKey, TValue> ToLookup<TKey, TValue>(this IEnumerable<(TKey Key, TValue Value)> source,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.ToLookup(source, comparer);

        /// <summary>
        /// Creates a <see cref="ILookup{TKey,TValue}" /> from a sequence of
        /// <see cref="KeyValuePair{TKey,TValue}" /> elements. An additional
        /// parameter specifies a comparer for keys.
        /// </summary>
        /// <typeparam name="TKey">The type of the key.</typeparam>
        /// <typeparam name="TValue">The type of the value.</typeparam>
        /// <param name="source">The source sequence of key-value pairs.</param>
        /// <param name="comparer">The comparer for keys.</param>
        /// <returns>
        /// A <see cref="ILookup{TKey,TValue}"/> containing the values
        /// mapped to their keys.
        /// </returns>

        public static ILookup<TKey, TValue> ToLookup<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source,
            IEqualityComparer<TKey> comparer)
            => MoreEnumerable.ToLookup(source, comparer);

    }

    /// <summary><c>Trace</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class TraceExtension
    {
        /// <summary>
        /// Traces the elements of a source sequence for diagnostics.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence</typeparam>
        /// <param name="source">Source sequence whose elements to trace.</param>
        /// <returns>
        /// Return the source sequence unmodified.
        /// </returns>
        /// <remarks>
        /// This a pass-through operator that uses deferred execution and
        /// streams the results.
        /// </remarks>

        public static IEnumerable<TSource> Trace<TSource>(this IEnumerable<TSource> source)
            => MoreEnumerable.Trace(source);

        /// <summary>
        /// Traces the elements of a source sequence for diagnostics using
        /// custom formatting.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence</typeparam>
        /// <param name="source">Source sequence whose elements to trace.</param>
        /// <param name="format">
        /// String to use to format the trace message. If null then the
        /// element value becomes the traced message.
        /// </param>
        /// <returns>
        /// Return the source sequence unmodified.
        /// </returns>
        /// <remarks>
        /// This a pass-through operator that uses deferred execution and
        /// streams the results.
        /// </remarks>

        public static IEnumerable<TSource> Trace<TSource>(this IEnumerable<TSource> source, string format)
            => MoreEnumerable.Trace(source, format);

        /// <summary>
        /// Traces the elements of a source sequence for diagnostics using
        /// a custom formatter.
        /// </summary>
        /// <typeparam name="TSource">Type of element in the source sequence</typeparam>
        /// <param name="source">Source sequence whose elements to trace.</param>
        /// <param name="formatter">Function used to format each source element into a string.</param>
        /// <returns>
        /// Return the source sequence unmodified.
        /// </returns>
        /// <remarks>
        /// This a pass-through operator that uses deferred execution and
        /// streams the results.
        /// </remarks>

        public static IEnumerable<TSource> Trace<TSource>(this IEnumerable<TSource> source, Func<TSource, string> formatter)
            => MoreEnumerable.Trace(source, formatter);

    }

    /// <summary><c>Transpose</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class TransposeExtension
    {
        /// <summary>
        /// Transposes a sequence of rows into a sequence of columns.
        /// </summary>
        /// <typeparam name="T">Type of source sequence elements.</typeparam>
        /// <param name="source">Source sequence to transpose.</param>
        /// <returns>
        /// Returns a sequence of columns in the source swapped into rows.
        /// </returns>
        /// <remarks>
        /// If a rows is shorter than a follow it then the shorter row's
        /// elements are skipped in the corresponding column sequences.
        /// This operator uses deferred execution and streams its results.
        /// Source sequence is consumed greedily when an iteration begins.
        /// The inner sequences representing rows are consumed lazily and
        /// resulting sequences of columns are streamed.
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// var matrix = new[]
        /// {
        ///     new[] { 10, 11 },
        ///     new[] { 20 },
        ///     new[] { 30, 31, 32 }
        /// };
        /// var result = matrix.Transpose();
        /// ]]></code>
        /// The <c>result</c> variable will contain [[10, 20, 30], [11, 31], [32]].
        /// </example>

        public static IEnumerable<IEnumerable<T>> Transpose<T>(this IEnumerable<IEnumerable<T>> source)
            => MoreEnumerable.Transpose(source);

    }

    /// <summary><c>Window</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class WindowExtension
    {
        /// <summary>
        /// Processes a sequence into a series of subsequences representing a windowed subset of the original
        /// </summary>
        /// <remarks>
        /// The number of sequences returned is: <c>Max(0, sequence.Count() - windowSize) + 1</c><br/>
        /// Returned subsequences are buffered, but the overall operation is streamed.<br/>
        /// </remarks>
        /// <typeparam name="TSource">The type of the elements of the source sequence</typeparam>
        /// <param name="source">The sequence to evaluate a sliding window over</param>
        /// <param name="size">The size (number of elements) in each window</param>
        /// <returns>A series of sequences representing each sliding window subsequence</returns>

        public static IEnumerable<IList<TSource>> Window<TSource>(this IEnumerable<TSource> source, int size)
            => MoreEnumerable.Window(source, size);

    }

    /// <summary><c>WindowLeft</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class WindowLeftExtension
    {
        /// <summary>
        /// Creates a left-aligned sliding window of a given size over the
        /// source sequence.
        /// </summary>
        /// <typeparam name="TSource">
        /// The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">
        /// The sequence over which to create the sliding window.</param>
        /// <param name="size">Size of the sliding window.</param>
        /// <returns>A sequence representing each sliding window.</returns>
        /// <remarks>
        /// <para>
        /// A window can contain fewer elements than <paramref name="size"/>,
        /// especially as it slides over the end of the sequence.</para>
        /// <para>
        /// This operator uses deferred execution and streams its results.</para>
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// Console.WriteLine(
        ///     Enumerable
        ///         .Range(1, 5)
        ///         .WindowLeft(3)
        ///         .Select(w => "AVG(" + w.ToDelimitedString(",") + ") = " + w.Average())
        ///         .ToDelimitedString(Environment.NewLine));
        ///
        /// // Output:
        /// // AVG(1,2,3) = 2
        /// // AVG(2,3,4) = 3
        /// // AVG(3,4,5) = 4
        /// // AVG(4,5) = 4.5
        /// // AVG(5) = 5
        /// ]]></code>
        /// </example>

        public static IEnumerable<IList<TSource>> WindowLeft<TSource>(this IEnumerable<TSource> source, int size)
            => MoreEnumerable.WindowLeft(source, size);

    }

    /// <summary><c>WindowRight</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class WindowRightExtension
    {
        /// <summary>
        /// Creates a right-aligned sliding window over the source sequence
        /// of a given size.
        /// </summary>
        /// <typeparam name="TSource">
        /// The type of the elements of <paramref name="source"/>.</typeparam>
        /// <param name="source">
        /// The sequence over which to create the sliding window.</param>
        /// <param name="size">Size of the sliding window.</param>
        /// <returns>A sequence representing each sliding window.</returns>
        /// <remarks>
        /// <para>
        /// A window can contain fewer elements than <paramref name="size"/>,
        /// especially as it slides over the start of the sequence.</para>
        /// <para>
        /// This operator uses deferred execution and streams its results.</para>
        /// </remarks>
        /// <example>
        /// <code><![CDATA[
        /// Console.WriteLine(
        ///     Enumerable
        ///         .Range(1, 5)
        ///         .WindowRight(3)
        ///         .Select(w => "AVG(" + w.ToDelimitedString(",") + ") = " + w.Average())
        ///         .ToDelimitedString(Environment.NewLine));
        ///
        /// // Output:
        /// // AVG(1) = 1
        /// // AVG(1,2) = 1.5
        /// // AVG(1,2,3) = 2
        /// // AVG(2,3,4) = 3
        /// // AVG(3,4,5) = 4
        /// ]]></code>
        /// </example>

        public static IEnumerable<IList<TSource>> WindowRight<TSource>(this IEnumerable<TSource> source, int size)
            => MoreEnumerable.WindowRight(source, size);

    }

    /// <summary><c>ZipLongest</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ZipLongestExtension
    {
        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. The resulting sequence
        /// will always be as long as the longest of input sequences where the
        /// default value of each of the shorter sequence element types is used
        /// for padding.
        /// </summary>
        /// <typeparam name="TFirst">Type of elements in first sequence.</typeparam>
        /// <typeparam name="TSecond">Type of elements in second sequence.</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence.</typeparam>
        /// <param name="first">The first sequence.</param>
        /// <param name="second">The second sequence.</param>
        /// <param name="resultSelector">
        /// Function to apply to each pair of elements.</param>
        /// <returns>
        /// A sequence that contains elements of the two input sequences,
        /// combined by <paramref name="resultSelector"/>.
        /// </returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = { 1, 2, 3 };
        /// var letters = { "A", "B", "C", "D" };
        /// var zipped = numbers.ZipLongest(letters, (n, l) => n + l);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield "1A",
        /// "2B", "3C", "0D" in turn.
        /// </example>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TResult> ZipLongest<TFirst, TSecond, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TSecond, TResult> resultSelector)
            => MoreEnumerable.ZipLongest(first, second, resultSelector);

        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. The resulting sequence
        /// will always be as long as the longest of input sequences where the
        /// default value of each of the shorter sequence element types is used
        /// for padding.
        /// </summary>
        /// <typeparam name="T1">Type of elements in first sequence.</typeparam>
        /// <typeparam name="T2">Type of elements in second sequence.</typeparam>
        /// <typeparam name="T3">Type of elements in third sequence.</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence.</typeparam>
        /// <param name="first">The first sequence.</param>
        /// <param name="second">The second sequence.</param>
        /// <param name="third">The third sequence.</param>
        /// <param name="resultSelector">
        /// Function to apply to each triplet of elements.</param>
        /// <returns>
        /// A sequence that contains elements of the three input sequences,
        /// combined by <paramref name="resultSelector"/>.
        /// </returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 1, 2, 3 };
        /// var letters = new[] { "A", "B", "C", "D" };
        /// var chars   = new[] { 'a', 'b', 'c', 'd', 'e' };
        /// var zipped  = numbers.ZipLongest(letters, chars, (n, l, c) => n + l + c);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield "1Aa",
        /// "2Bb", "3Cc", "0Dd", "0e" in turn.
        /// </example>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TResult> ZipLongest<T1, T2, T3, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            Func<T1, T2, T3, TResult> resultSelector)
            => MoreEnumerable.ZipLongest(first, second, third, resultSelector);

        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. The resulting sequence
        /// will always be as long as the longest of input sequences where the
        /// default value of each of the shorter sequence element types is used
        /// for padding.
        /// </summary>
        /// <typeparam name="T1">Type of elements in first sequence</typeparam>
        /// <typeparam name="T2">Type of elements in second sequence</typeparam>
        /// <typeparam name="T3">Type of elements in third sequence</typeparam>
        /// <typeparam name="T4">Type of elements in fourth sequence</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence</typeparam>
        /// <param name="first">The first sequence.</param>
        /// <param name="second">The second sequence.</param>
        /// <param name="third">The third sequence.</param>
        /// <param name="fourth">The fourth sequence.</param>
        /// <param name="resultSelector">
        /// Function to apply to each quadruplet of elements.</param>
        /// <returns>
        /// A sequence that contains elements of the four input sequences,
        /// combined by <paramref name="resultSelector"/>.
        /// </returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 1, 2, 3 };
        /// var letters = new[] { "A", "B", "C", "D" };
        /// var chars   = new[] { 'a', 'b', 'c', 'd', 'e' };
        /// var flags   = new[] { true, false, true, false, true, false };
        /// var zipped  = numbers.ZipLongest(letters, chars, flags, (n, l, c, f) => n + l + c + f);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield "1AaTrue",
        /// "2BbFalse", "3CcTrue", "0DdFalse", "0eTrue", "0\0False" in turn.
        /// </example>
        /// <remarks>
        /// This operator uses deferred execution and streams its results.
        /// </remarks>

        public static IEnumerable<TResult> ZipLongest<T1, T2, T3, T4, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            IEnumerable<T4> fourth,
            Func<T1, T2, T3, T4, TResult> resultSelector)
            => MoreEnumerable.ZipLongest(first, second, third, fourth, resultSelector);

    }

    /// <summary><c>ZipShortest</c> extension.</summary>

    [GeneratedCode("MoreLinq.ExtensionsGenerator", "1.0.0.0")]
    public static partial class ZipShortestExtension
    {
        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. The resulting sequence
        /// is as short as the shortest input sequence.
        /// </summary>
        /// <typeparam name="TFirst">Type of elements in first sequence.</typeparam>
        /// <typeparam name="TSecond">Type of elements in second sequence.</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence.</typeparam>
        /// <param name="first">The first sequence.</param>
        /// <param name="second">The second sequence.</param>
        /// <param name="resultSelector">
        /// Function to apply to each pair of elements.</param>
        /// <returns>
        /// A projection of tuples, where each tuple contains the N-th element
        /// from each of the argument sequences.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 1, 2, 3 };
        /// var letters = new[] { "A", "B", "C", "D" };
        /// var zipped = numbers.ZipShortest(letters, (n, l) => n + l);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield "1A", "2B", "3C", in turn.
        /// </example>
        /// <remarks>
        /// <para>
        /// If the input sequences are of different lengths, the result sequence
        /// is terminated as soon as the shortest input sequence is exhausted
        /// and remainder elements from the longer sequences are never consumed.
        /// </para>
        /// <para>
        /// This operator uses deferred execution and streams its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> ZipShortest<TFirst, TSecond, TResult>(
            this IEnumerable<TFirst> first,
            IEnumerable<TSecond> second,
            Func<TFirst, TSecond, TResult> resultSelector)
            => MoreEnumerable.ZipShortest(first, second, resultSelector);

        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. The resulting sequence
        /// is as short as the shortest input sequence.
        /// </summary>
        /// <typeparam name="T1">Type of elements in first sequence.</typeparam>
        /// <typeparam name="T2">Type of elements in second sequence.</typeparam>
        /// <typeparam name="T3">Type of elements in third sequence.</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence.</typeparam>
        /// <param name="first">First sequence</param>
        /// <param name="second">Second sequence</param>
        /// <param name="third">Third sequence</param>
        /// <param name="resultSelector">
        /// Function to apply to each triplet of elements.</param>
        /// <returns>
        /// A projection of tuples, where each tuple contains the N-th element
        /// from each of the argument sequences.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 1, 2, 3 };
        /// var letters = new[] { "A", "B", "C", "D" };
        /// var chars   = new[] { 'a', 'b', 'c', 'd', 'e' };
        /// var zipped  = numbers.ZipShortest(letters, chars, (n, l, c) => c + n + l);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield
        /// "98A", "100B", "102C", in turn.
        /// </example>
        /// <remarks>
        /// <para>
        /// If the input sequences are of different lengths, the result sequence
        /// is terminated as soon as the shortest input sequence is exhausted
        /// and remainder elements from the longer sequences are never consumed.
        /// </para>
        /// <para>
        /// This operator uses deferred execution and streams its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> ZipShortest<T1, T2, T3, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            Func<T1, T2, T3, TResult> resultSelector)
            => MoreEnumerable.ZipShortest(first, second, third, resultSelector);

        /// <summary>
        /// Returns a projection of tuples, where each tuple contains the N-th
        /// element from each of the argument sequences. The resulting sequence
        /// is as short as the shortest input sequence.
        /// </summary>
        /// <typeparam name="T1">Type of elements in first sequence.</typeparam>
        /// <typeparam name="T2">Type of elements in second sequence.</typeparam>
        /// <typeparam name="T3">Type of elements in third sequence.</typeparam>
        /// <typeparam name="T4">Type of elements in fourth sequence.</typeparam>
        /// <typeparam name="TResult">Type of elements in result sequence.</typeparam>
        /// <param name="first">The first sequence.</param>
        /// <param name="second">The second sequence.</param>
        /// <param name="third">The third sequence.</param>
        /// <param name="fourth">The fourth sequence.</param>
        /// <param name="resultSelector">
        /// Function to apply to each quadruplet of elements.</param>
        /// <returns>
        /// A projection of tuples, where each tuple contains the N-th element
        /// from each of the argument sequences.</returns>
        /// <example>
        /// <code><![CDATA[
        /// var numbers = new[] { 1, 2, 3 };
        /// var letters = new[] { "A", "B", "C", "D" };
        /// var chars   = new[] { 'a', 'b', 'c', 'd', 'e' };
        /// var flags   = new[] { true, false };
        /// var zipped  = numbers.ZipShortest(letters, chars, flags, (n, l, c, f) => n + l + c + f);
        /// ]]></code>
        /// The <c>zipped</c> variable, when iterated over, will yield
        /// "1AaTrue", "2BbFalse" in turn.
        /// </example>
        /// <remarks>
        /// <para>
        /// If the input sequences are of different lengths, the result sequence
        /// is terminated as soon as the shortest input sequence is exhausted
        /// and remainder elements from the longer sequences are never consumed.
        /// </para>
        /// <para>
        /// This operator uses deferred execution and streams its results.</para>
        /// </remarks>

        public static IEnumerable<TResult> ZipShortest<T1, T2, T3, T4, TResult>(
            this IEnumerable<T1> first,
            IEnumerable<T2> second,
            IEnumerable<T3> third,
            IEnumerable<T4> fourth,
            Func<T1, T2, T3, T4, TResult> resultSelector)
            => MoreEnumerable.ZipShortest(first, second, third, fourth, resultSelector);

    }
}
