use strict;
use warnings;

# this Makefile.PL is only for in-repo development purposes.
# In the built distribution, it is replaced by one generated by Dist::Zilla.

BEGIN {

    my @modules = qw(
        ExtUtils::MakeMaker::Dist::Zilla::Develop
        File::Find::Rule
        Test::Inline
        Path::Tiny
    );

    my %missing;
    for my $module (@modules) {
        eval "require $module";
        $missing{$module} = $@ if $@;
    }

    if ( keys %missing ) {
        warn "Errors encountered while checking for developer Makefile.PL dependencies:\n\n";
        warn values %missing, "\n";
        warn
            "You need to install the following modules to run this Makefile.PL:\n";
        warn "    $_\n" for keys %missing;
        warn "\nTry running this command:\n";
        warn "    cpanm " . ( join q{ }, keys %missing ) . "\n";
        exit 1;
    }

    ExtUtils::MakeMaker::Dist::Zilla::Develop->import();
}

system( $^X, 'author/extract-inline-tests', '--quiet' );

use lib '.';
use inc::MMHelper;

eval inc::MMHelper::my_package_subs();

my %args = inc::MMHelper::mm_args();
$args{clean}{FILES} = join(' ', ($args{clean}{FILES} || ()),
    (grep !/basics_genome_overloadingsubtypesandcoercion\.t\z/, glob('t/recipes/*')),
    'xs/*.c', 'xs/*.o',
);

WriteMakefile(
    NAME => 'Moose',
    VERSION_FROM => 'lib/Moose.pm',
    test => { TESTS => 't/*.t t/*/*.t' },
    CCFLAGS => inc::MMHelper::ccflags_static('dev'),
    INSTALLMAN1DIR => 'none',
    INSTALLMAN3DIR => 'none',
    NORECURS => 1,
    %args,
);

# uncomment these lines to generate a new ppport.h locally, e.g. if an update
# is necessary for new features.
# use Devel::PPPort;
# Devel::PPPort::WriteFile();
system("$^X ppport.h --compat-version=5.008003 --quiet xs/* *.[hc]");
