import React from 'react';
import { styled } from '@storybook/theming';
import { addons } from '@storybook/addons';
import Provider from './provider';

export class FakeProvider extends Provider {
  constructor() {
    super();

    // @ts-ignore
    this.addons = addons;
    // @ts-ignore
    this.channel = {
      on: () => {},
      off: () => {},
      emit: () => {},
      addListener: () => {},
    };
  }

  // @ts-ignore
  getElements(type) {
    return addons.getElements(type);
  }

  renderPreview() {
    return <div>This is from a 'renderPreview' call from FakeProvider</div>;
  }

  // @ts-ignore
  handleAPI(api) {
    addons.loadAddons(api);
  }

  // @ts-ignore
  getConfig() {
    return {};
  }
}

export const Centered = styled.div({
  width: '100vw',
  height: '100vh',
  display: 'flex',
  justifyContent: 'center',
  alignItems: 'center',
  flexDirection: 'column',
});

export class PrettyFakeProvider extends FakeProvider {
  renderPreview(...args: any[]) {
    return (
      <Centered>
        This is from a 'renderPreview' call from FakeProvider
        <hr />
        'renderPreview' was called with:
        <pre>{JSON.stringify(args, null, 2)}</pre>
      </Centered>
    );
  }
}
