---
title: 'Example Storybooks'
---

Storybook is the world’s most popular component explorer. It's widely adopted by industry giants, startups, and open source projects alike.

This is a curated list of Storybooks for your inspiration.

## Storybook team

- [Official Storybook](https://next--storybookjs.netlify.app/official-storybook/): Storybook application UI
- [Storybook Design System](https://master--5ccbc373887ca40020446347.chromatic.com/): Reusable components that adhere to Storybook's design language
- [Marketing and docs](https://master--5be26744d2f6250024a9117d.chromatic.com/): Main website that has stories for components and pages.
- [Learn Storybook](https://master--5cf841a3f3e3d200208ffc74.chromatic.com/): Tutorial site that has stories for components and pages.

## Websites

See how to build UIs using a [component driven](https://www.componentdriven.org/) methodology.

- [BBC Psammead](https://bbc.github.io/psammead/?path=/story/components-brand--without-brand-link)
- [The Guardian](https://master--5dfcbf3012392c0020e7140b.chromatic.com)

<!--

NOTE for contributors: This is a curated list. Here's what qualifies:
- Website or app Storybook that illustrates how to build UIs from small components to pages
- Used in production by a medium/large company or large open source community
- Must be developed actively

-->

## Design systems and component libraries

Learn how leading teams build design systems.

- [Workday Canvas](https://workday.github.io/canvas-kit/?path=/story/welcome-getting-started--page)
- [Salesforce Lightning](http://design-system-react-components.herokuapp.com/?path=/story/sldsaccordion--base)
- [IBM Carbon](https://react.carbondesignsystem.com/?path=/story/accordion--accordion)
- [Shopify Polaris](https://master--5d559397bae39100201eedc1.chromatic.com/)
- [Airbnb Dates](http://airbnb.io/react-dates/?path=/story/daterangepicker-drp--default)
- [Lonely Planet](http://lonelyplanet.github.io/backpack-ui/?path=/story/styles--design-tokens)
- [Wix Style](https://www.wix.com/pages/wix-style-react/?path=/story/*)
- [Chakra UI](https://chakra-ui.netlify.app/?path=/story/*)
- [Grommet](https://storybook.grommet.io/?path=/story/all--all)
- [Reaviz](https://reaviz.io/?path=/story/docs-intro--page)
- [ShareGate Orbit](https://orbit.sharegate.design/?path=/docs/getting-started-packages--page)
- [AppNexus Lucid](https://appnexus.github.io/lucid/?path=/docs/documentation-introduction--introduction)
- [AnyVision UI](http://storybook.anyvision.co/)
- [Skyscanner Backpack](https://backpack.github.io/storybook/)
- [GitLab UI](https://gitlab-org.gitlab.io/gitlab-ui)

<!--

NOTE for contributors: This is a curated list. Here's what qualifies:
- Design system or component library
- Used in production by a medium/large company or large open source community (Grommet, Chakra)
- Must have greater than 20+ contributors OR 1k+ GitHub stars OR show exceptional use of SB features

-->
