import AngularSnapshotSerializer from 'jest-preset-angular/build/AngularSnapshotSerializer';
import HTMLCommentSerializer from 'jest-preset-angular/build/HTMLCommentSerializer';
// eslint-disable-next-line import/no-extraneous-dependencies
import { TestBed } from '@angular/core/testing';
// eslint-disable-next-line import/no-extraneous-dependencies
import { BrowserDynamicTestingModule } from '@angular/platform-browser-dynamic/testing';
// eslint-disable-next-line import/no-extraneous-dependencies
import { NO_ERRORS_SCHEMA } from '@angular/core';
import { addSerializer } from 'jest-specific-snapshot';
import { initModuleData } from './helpers';

addSerializer(HTMLCommentSerializer);
addSerializer(AngularSnapshotSerializer);

function getRenderedTree(story: any) {
  const currentStory = story.render();

  const { moduleMeta, AppComponent } = initModuleData(currentStory);

  TestBed.configureTestingModule(
    // TODO: take a look at `bootstrap` because it looks it does not exists in TestModuleMetadata
    {
      imports: [...moduleMeta.imports],
      declarations: [...moduleMeta.declarations],
      providers: [...moduleMeta.providers],
      schemas: [NO_ERRORS_SCHEMA, ...moduleMeta.schemas],
      bootstrap: [...moduleMeta.bootstrap],
    } as any
  );

  TestBed.overrideModule(BrowserDynamicTestingModule, {
    set: {
      entryComponents: [...moduleMeta.entryComponents],
    },
  });

  return TestBed.compileComponents().then(() => {
    const tree = TestBed.createComponent(AppComponent);
    tree.detectChanges();

    return tree;
  });
}

export default getRenderedTree;
