<h1>Storybook Docs for Web Components</h1>

- [Installation](#installation)
- [Props tables](#props-tables)
- [Stories not inline](#stories-not-inline)
- [More resources](#more-resources)

## Installation

- Be sure to check the [installation section of the general addon-docs page](../README.md) before proceeding.
- Be sure to have a [custom-elements.json](./#custom-elementsjson) file.
- Add to your `.storybook/preview.js`

  ```js
  import { setCustomElements } from '@storybook/web-components';
  import customElements from '../custom-elements.json';

  setCustomElements(customElements);
  ```

- Add to your story files

  ```js
  export default {
    title: 'Demo Card',
    component: 'your-component-name', // which is also found in the `custom-elements.json`
  };
  ```

## Props tables

In order to get [Props tables](..docs/../../docs/props-tables.md) documentation for web-components you will need to have a [custom-elements.json](https://github.com/webcomponents/custom-elements-json) file.

You can hand write it or better generate it. Depending on the web components sugar you are choosing your milage may vary.

Known analyzers that output `custom-elements.json`:

- [web-component-analyzer](https://github.com/runem/web-component-analyzer)
  - Supports LitElement, Polymer, Vanilla, (Stencil)
- [stenciljs](https://stenciljs.com/)
  - Supports Stencil (but does not have all metadata)

To generate this file with Stencil, add `docs-vscode` to outputTargets in `stencil.config.ts`:

```
{
  type: 'docs-vscode',
  file: 'custom-elements.json'
},
```

The file looks something like this:

```json
{
  "version": 2,
  "tags": [
    {
      "name": "demo-wc-card",
      "properties": [
        {
          "name": "header",
          "type": "String",
          "attribute": "header",
          "description": "Shown at the top of the card",
          "default": "Your Message"
        }
      ],
      "events": [],
      "slots": [],
      "cssProperties": []
    }
  ]
}
```

For a full example see the [web-components-kitchen-sink/custom-elements.json](../../../examples/web-components-kitchen-sink/custom-elements.json).

## Stories not inline

By default stories are rendered inline.
For web components that is usually fine as they are style encapsulated via shadow dom.
However when you have a style tag in you template it might be best to show them in an iframe.

To always use iframes you can set

```js
addParameters({
  docs: {
    inlineStories: false,
  },
});
```

or add it to individual stories.

```js
<Story inline={false} />
```

## More resources

Want to learn more? Here are some more articles on Storybook Docs:

- References: [DocsPage](../docs/docspage.md) / [MDX](../docs/mdx.md) / [FAQ](../docs/faq.md) / [Recipes](../docs/recipes.md) / [Theming](../docs/theming.md) / [Props](../docs/props-tables.md)
- Announcements: [Vision](https://medium.com/storybookjs/storybook-docs-sneak-peak-5be78445094a) / [DocsPage](https://medium.com/storybookjs/storybook-docspage-e185bc3622bf) / [MDX](https://medium.com/storybookjs/rich-docs-with-storybook-mdx-61bc145ae7bc) / [Framework support](https://medium.com/storybookjs/storybook-docs-for-new-frameworks-b1f6090ee0ea)
- Example: [Storybook Design System](https://github.com/storybookjs/design-system)
