**Technical Charter (the “Charter”) for MoonRay**

**[ \_ ] [ \_ ], 2023**


This charter (the “Charter”) sets forth the responsibilities and procedures for technical contribution  
&emsp;to, and oversight of, the **MoonRay (aka OpenMoonRay)** project (the “Project”),  
&emsp;which has been established as  **MoonRay** by DreamWorks Animation L.L.C. (“DreamWorks”).  
&emsp;All Contributors to the Project must comply with the terms of this Charter.

**1. Mission and Scope of the Project**

&emsp;a.&ensp;The mission of the Project is to continue maintenance and development of an  
&emsp;&emsp; open source project with the goals indicated in the “README” file within the  
&emsp;&emsp; Project’s code repository.  

&emsp;b.&ensp;The scope of the Project includes using existing MoonRay repositories to seed the  
&emsp;&emsp; Project, and software development under an OSI-approved open source license  
&emsp;&emsp; supporting the mission, including documentation, testing, integration and the  
&emsp;&emsp; creation of other artifacts that aid the development, deployment, operation or  
&emsp;&emsp; adoption of the open source software project.

**2. Technical Steering Committee**  

&emsp;a.&ensp;The Technical Steering Committee (the “TSC”) will be responsible for all  
&emsp;&emsp; technical oversight of the open source Project.  

&emsp;b.&ensp;The TSC voting members shall be as set forth within the “CONTRIBUTING” file  
&emsp;&emsp; within the Project’s code repository. A voting member of the TSC may nominate  
&emsp;&emsp; a successor in the event that such voting member decides to leave the TSC, and  
&emsp;&emsp; the TSC, including the departing member, shall confirm or reject such nomination  
&emsp;&emsp; by a vote. In the event that the departing member’s nomination for successor is  
&emsp;&emsp; rejected by vote of the TSC, the departing member shall be entitled to continue  
&emsp;&emsp; nominating successors until one such successor is confirmed by vote of the TSC.  
&emsp;&emsp; If the departing member fails or is unable to nominate a successor, the TSC may  
&emsp;&emsp; nominate one on the departing member’s behalf. The TSC may also determine if  
&emsp;&emsp; and how additional voting members of the TSC are chosen, and any such  
&emsp;&emsp; approach will be documented in the CONTRIBUTING file, provided that such  
&emsp;&emsp; approach does not conflict with this Charter. Any meetings of the TSC are  
&emsp;&emsp; intended to be open to the public, except where there is a reasonable need for  
&emsp;&emsp; privacy, and can be conducted electronically, via teleconference, or in person.  

&emsp;c.&ensp;TSC projects generally will involve Contributors and Committers. The TSC may  
&emsp;&emsp; adopt or modify roles so long as the roles are documented in the  
&emsp;&emsp; CONTRIBUTING file. Unless otherwise documented:  

&emsp;&emsp;&emsp;&emsp;i.&emsp;Contributors include anyone in the technical community that contributes  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; code, documentation, or other technical artifacts to the Project;  

&emsp;&emsp;&emsp;&emsp;ii.&emsp;Committers are Contributors who have earned the ability to modify  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; (“commit”) source code, documentation or other technical artifacts in the  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; Project’s repository; and  

&emsp;&emsp;&emsp;&emsp;iii.&emsp;A Contributor may become a Committer by a majority approval of  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; the existing Committers or at the discretion of the TSC. A Committer may be  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; removed by a majority approval of the other existing Committers, or at the  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; the discretion of the TSC.

&emsp;d.&ensp;Participation in the Project through becoming a Contributor and Committer is  
&emsp;&emsp; open to anyone so long as they abide by the terms of this Charter.  

&emsp;e.&ensp;The TSC may (1) establish workflow procedures for the submission, approval,  
&emsp;&emsp; and closure/archiving of projects, (2) set requirements for the promotion of  
&emsp;&emsp; Contributors to Committer status, as applicable, and (3) amend, adjust, refine  
&emsp;&emsp; and/or eliminate the roles of Contributors, and Committers, and create new roles,  
&emsp;&emsp; and publicly document any TSC roles, as it sees fit.  

&emsp;f.&ensp;The TSC may elect a TSC Chair, who will preside over meetings of the TSC and  
&emsp;&emsp; will serve until his or her resignation or replacement by the TSC.  

&emsp;g.&ensp;Responsibilities: The TSC will be responsible for all aspects of oversight relating  
&emsp;&emsp; to the Project, which may include:  

&emsp;&emsp;&emsp;&emsp;i.&emsp;coordinating the technical direction of the Project;  

&emsp;&emsp;&emsp;&emsp;ii.&emsp;approving project or system proposals (including, but not limited  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; to, incubation, deprecation, and changes to a sub-project’s scope);  

&emsp;&emsp;&emsp;&emsp;ii.&emsp;organizing sub-projects and removing projects;  

&emsp;&emsp;&emsp;&emsp;iv.&emsp;creating sub-committees or working groups to focus on cross-project  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; technical issues and requirements;  

&emsp;&emsp;&emsp;&emsp;v.&emsp;appointing representatives to work with other open source or open  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; standards communities;  

&emsp;&emsp;&emsp;&emsp;vi.&emsp;establishing community norms, workflows, issuing releases, and security  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; issue reporting policies;  

&emsp;&emsp;&emsp;&emsp;vii.&ensp;approving and implementing policies and processes for contributing (to be  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; published in the CONTRIBUTING file) and coordinating with the Series  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; Manager or its designee to resolve matters or concerns that may arise as  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; set forth in Section 7 of this Charter;  

&emsp;&emsp;&emsp;&emsp;viii.&ensp;discussions, seeking consensus, and where necessary, voting on technical  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; matters relating to the code base that affect multiple projects;  

&emsp;&emsp;&emsp;&emsp;ix.&emsp;coordinating any marketing, events, or communications regarding the  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; Project; and  

&emsp;&emsp;&emsp;&emsp;x.&emsp;ensuring that the Project (x) is developed and maintained in a professional  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; manner consistent with maintaining a cohesive community, while also  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; maintaining the goodwill and esteem of [entity] and other partner  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; organizations in the open source software community, and (y) respects the  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; rights of all trademark owners, including any branding and trademark  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; usage guidelines.

**3. TSC Voting**  

&emsp;a.&ensp;Although the Project aims to operate as a consensus-based community, if any  
&emsp;&emsp; TSC decision requires a vote to move the Project forward, the voting members of  
&emsp;&emsp; the TSC will vote on a one vote per voting member basis.  

&emsp;b.&ensp;At least fifty percent of all voting members of the TSC must be present at a TSC  
&emsp;&emsp; meeting in order to establish a quorum. The TSC may continue to meet if a  
&emsp;&emsp; quorum is not met, but will be prevented from making any decisions at any such  
&emsp;&emsp; meeting.  

&emsp;c.&ensp;Except as provided in Section 7.c. and 8.a, decisions by vote at a meeting require  
&emsp;&emsp; a majority vote of those in attendance, provided a quorum is met. Decisions made  
&emsp;&emsp; by electronic vote without a meeting require a majority vote of all voting  
&emsp;&emsp; members of the TSC.  

&emsp;d.&ensp;In the event a vote cannot be resolved by the TSC, any voting member of the TSC  
&emsp;&emsp; may refer the matter to the Series Manager or its designee for assistance in  
&emsp;&emsp; reaching a resolution.  

**4. Compliance with Policies**  

&emsp;a.&ensp;The TSC may adopt a code of conduct (“CoC”) for the Project, which is subject to  
&emsp;&emsp; approval by DreamWorks. Contributors to the Project will comply with the CoC.  

&emsp;b.&ensp;When amending or adopting any policy applicable to the Project, the TSC will  
&emsp;&emsp; publish such policy, as to be amended or adopted, on its web site at least 30 days  
&emsp;&emsp; prior to such policy taking effect.  

&emsp;c.&ensp;All participants must allow open participation from any individual or organization  
&emsp;&emsp; meeting the requirements for contributing under this Charter and any policies  
&emsp;&emsp; adopted for all participants by the TSC, regardless of competitive interests. Put  
&emsp;&emsp; another way, the Project community must not seek to exclude any participant  
&emsp;&emsp; based on any criteria, requirement, or reason other than those that are reasonable  
&emsp;&emsp; and applied on a non-discriminatory basis to all participants in the Project  
&emsp;&emsp; community.  

&emsp;d.&ensp;The Project will operate in a transparent, open, collaborative, and ethical manner  
&emsp;&emsp; at all times. The output of all Project discussions, proposals, timelines, decisions,  
&emsp;&emsp; and status should be made open and easily visible to all.  

&emsp;d.&ensp;Any violations of the CoC or the requirements above should be reported to  
&emsp;&emsp; DreamWorks.  

**5. Project Assets**  

&emsp;a.&ensp;DreamWorks will hold title to all trade or service marks used by the Project  
&emsp;&emsp; (“Project Trademarks”), whether based on common law or registered rights. Any  
&emsp;&emsp; new Project Trademarks will be transferred and assigned to DreamWorks to hold  
&emsp;&emsp; on behalf of the Project. Any use of any Project Trademarks by participants in the  
&emsp;&emsp; Project will be in accordance with the license from DreamWorks and inure to the  
&emsp;&emsp; benefit of DreamWorks.  

&emsp;b.&ensp;The Project will develop and own all Project GitHub and social media accounts,  
&emsp;&emsp; and domain name registrations created by the Project community.  


**6. Intellectual Property Policy**  

&emsp;a.&ensp;Participants acknowledge that the copyright in all new contributions will be  
&emsp;&emsp; retained by the copyright holder as independent works of authorship and that no  
&emsp;&emsp; contributor or copyright holder will be required to assign copyrights to any other  
&emsp;&emsp; party.  

&emsp;b.&ensp;Except as described in Section 6.c., all code contributions to the Project are  
&emsp;&emsp; subject to the following:  

&emsp;&emsp;&emsp;&emsp;i.&emsp;All new inbound code contributions to the Project must be made using an  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; OSI-approved open source license specified for the Project within the  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; “LICENSE” file within the Project’s code repository (the “Project  
&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; License”).  

&emsp;&emsp;&emsp;&emsp;ii.&emsp;All new inbound code contributions must:  

&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;1.&emsp;Be made pursuant to a binding Project Contribution License  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; Agreement (the “CLA”) available on the Project’s web site; and  

&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;2.&emsp;Be accompanied by a Developer Certificate of Origin  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; (http://developercertificate.org) sign-off in the source code system  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; that is submitted through a TSC-approved contribution process  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; which will bind the authorized contributor and, if not self-  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; employed, their employer to the applicable license;  

&emsp;&emsp;&emsp;&emsp;iii.&emsp;All outbound code will be made available under the Project License  

&emsp;&emsp;&emsp;&emsp;iv.&emsp;Documentation will be received and made available by the Project under  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; the Creative Commons Attribution 4.0 International License (available at  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; http://creativecommons.org/licenses/by/4.0/).  

&emsp;&emsp;&emsp;&emsp;v.&emsp;The TSC may seek to integrate and contribute back elements of the  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; Project to other open source projects (“Upstream Projects”). In such cases, the  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; contributed elements will conform to all license requirements of the  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; Upstream Projects, including dependencies, leveraged by those elements.  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; Upstream Project code contributions not stored within the Project’s main  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; code repository will comply with the contribution process and license  
&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&ensp; terms for the applicable Upstream Project.  

&emsp;c.&ensp;If an alternative inbound or outbound license is required for compliance with the  
&emsp;&emsp; license for a leveraged open source project or is otherwise required to achieve the  
&emsp;&emsp; Project’s mission, the TSC (but only with DreamWorks’ approval) may approve  
&emsp;&emsp; the use of an alternative license for specific inbound or outbound contributions on  
&emsp;&emsp; an exception basis. Any exceptions must be limited in scope to what is required  
&emsp;&emsp; for such a purpose. To request an exception, please describe the contribution, the  
&emsp;&emsp; alternative open source license(s), and the justification for using an alternative  
&emsp;&emsp; open source license for the Project.  

&emsp;c.&ensp;Contributed files should contain license information, such as SPDX short form  
&emsp;&emsp; identifiers, indicating the open source license or licenses pertaining to the file.  

**7. Amendments**  

&emsp;a.&ensp;This charter may be amended by a two-thirds vote of the entire TSC, subject to  
&emsp;&emsp; reasonable approval by DreamWorks Animation L.L.C.
