% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pecs.R
\name{pecs}
\alias{pecs}
\alias{pecs.list}
\alias{pecs.PredictionSurv}
\title{Prediction Error Curves for PredictionSurv and LearnerSurv}
\usage{
pecs(x, measure = c("graf", "logloss"), times, n, eps = NULL, ...)

\method{pecs}{list}(
  x,
  measure = c("graf", "logloss"),
  times,
  n,
  eps = 0.001,
  task = NULL,
  row_ids = NULL,
  newdata = NULL,
  train_task = NULL,
  train_set = NULL,
  ...
)

\method{pecs}{PredictionSurv}(
  x,
  measure = c("graf", "logloss"),
  times,
  n,
  eps = 0.001,
  train_task = NULL,
  train_set = NULL,
  ...
)
}
\arguments{
\item{x}{(\link{PredictionSurv} or \code{list} of \link{LearnerSurv}s)}

\item{measure}{(\code{character(1)}) \cr
Either \code{"graf"} for \link{MeasureSurvGraf}, or \code{"logloss"} for \link{MeasureSurvIntLogloss}}

\item{times}{(\code{numeric()}) \cr
If provided then either a vector of time-points to evaluate \code{measure} or a range of
time-points.}

\item{n}{(\code{integer()}) \cr
If \code{times} is missing or given as a range, then \code{n} provide number of time-points to evaluate
\code{measure} over.}

\item{eps}{(\code{numeric()}) \cr
Small error value to prevent errors resulting from a log(0) or 1/0 calculation.
Default value is \code{1e-3}.}

\item{...}{Additional arguments.}

\item{task}{(\link{TaskSurv})}

\item{row_ids}{(\code{integer()}) \cr
Passed to \code{Learner$predict}.}

\item{newdata}{(\code{data.frame()}) \cr
If not missing \code{Learner$predict_newdata} is called instead of \code{Learner$predict}.}

\item{train_task}{(\link{TaskSurv}) \cr
If not NULL then passed to measures for computing estimate of censoring distribution on
training data.}

\item{train_set}{(\code{numeric()}) \cr
If not NULL then passed to measures for computing estimate of censoring distribution on
training data.}
}
\description{
Methods to plot prediction error curves (pecs) for either a \link{PredictionSurv} object
or a list of trained \link{LearnerSurv}s.
}
\details{
If \code{times} and \code{n} are missing then \code{measure} is evaluated over all observed time-points
from the \link{PredictionSurv} or \link{TaskSurv} object. If a range is provided for \code{times} without \code{n},
then all time-points between the range are returned.
}
\examples{
\dontshow{if (mlr3misc::require_namespaces(c("ggplot2"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
  # Prediction Error Curves for prediction object
  task = tsk("lung")
  learner = lrn("surv.coxph")
  p = learner$train(task)$predict(task)
  pecs(p)
  pecs(p, measure = "logloss", times = seq(0, 1000, 50)) +
    ggplot2::geom_point() +
    ggplot2::labs(title = "Prediction Error Curve for Cox PH", y = "ISLL")

  # Access underlying data
  x = pecs(p)
  x$data

  # Prediction Error Curves for fitted learners
  learners = lrns(c("surv.kaplan", "surv.coxph"))
  lapply(learners, function(x) x$train(task))
  pecs(learners, task = task, measure = "logloss", times = c(0, 1000), n = 100) +
    ggplot2::labs(y = "ISLL")
  pecs(learners, task = task, measure = "graf", times = c(0, 1000), n = 100) +
    ggplot2::labs(y = "ISBS")
\dontshow{\}) # examplesIf}
}
