% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpSurvAvg.R
\name{mlr_pipeops_survavg}
\alias{mlr_pipeops_survavg}
\alias{PipeOpSurvAvg}
\title{PipeOpSurvAvg}
\description{
Perform (weighted) prediction averaging from survival \link{PredictionSurv}s by connecting
\code{PipeOpSurvAvg} to multiple \link[mlr3pipelines:mlr_pipeops_learner]{PipeOpLearner} outputs.

The resulting prediction will aggregate any predict types that are contained within all inputs.
Any predict types missing from at least one input will be set to \code{NULL}. These are aggregated
as follows:
\itemize{
\item \code{"response"}, \code{"crank"}, and \code{"lp"} are all a weighted average from the incoming predictions.
\item \code{"distr"} is a \link[distr6:VectorDistribution]{distr6::VectorDistribution} containing \link[distr6:MixtureDistribution]{distr6::MixtureDistribution}s.
}

Weights can be set as a parameter; if none are provided, defaults to
equal weights for each prediction.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \link[mlr3pipelines:PipeOpEnsemble]{PipeOpEnsemble}
with a \link{PredictionSurv} for inputs and outputs.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

The parameters are the parameters inherited from the
\link[mlr3pipelines:PipeOpEnsemble]{PipeOpEnsemble}.
}

\section{Internals}{

Inherits from \link[mlr3pipelines:PipeOpEnsemble]{PipeOpEnsemble} by implementing the
\code{private$weighted_avg_predictions()} method.
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3pipelines)

  task = tsk("rats")
  p1 = lrn("surv.coxph")$train(task)$predict(task)
  p2 = lrn("surv.kaplan")$train(task)$predict(task)
  poc = po("survavg", param_vals = list(weights = c(0.2, 0.8)))
  poc$train(list(NULL)) # need to train first, even if nothing happens
  poc$predict(list(p1, p2))
}
\dontshow{\}) # examplesIf}
}
\seealso{
\link{pipeline_survaverager}

Other PipeOps: 
\code{\link{mlr_pipeops_trafopred_regrsurv_pem}},
\code{\link{mlr_pipeops_trafotask_survregr_pem}}
}
\concept{Ensembles}
\concept{PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpEnsemble]{mlr3pipelines::PipeOpEnsemble}} -> \code{PipeOpSurvAvg}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpSurvAvg-new}{\code{PipeOpSurvAvg$new()}}
\item \href{#method-PipeOpSurvAvg-clone}{\code{PipeOpSurvAvg$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpSurvAvg-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpSurvAvg-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpSurvAvg$new(innum = 0, id = "survavg", param_vals = list(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{innum}}{(\code{numeric(1)})\cr
Determines the number of input channels.
If \code{innum} is 0 (default), a vararg input channel is created that can take an arbitrary
number of inputs.}

\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}

\item{\code{...}}{(\code{ANY})\cr
Additional arguments passed to \link[mlr3pipelines:PipeOpEnsemble]{mlr3pipelines::PipeOpEnsemble}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpSurvAvg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpSurvAvg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpSurvAvg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
