% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpCrankCompositor.R
\name{mlr_pipeops_crankcompose}
\alias{mlr_pipeops_crankcompose}
\alias{PipeOpCrankCompositor}
\title{PipeOpCrankCompositor}
\description{
Uses a predicted \code{distr} in a \link{PredictionSurv} to estimate (or 'compose') a \code{crank} prediction.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops} or with the associated sugar
function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpCrankCompositor$new()
mlr_pipeops$get("crankcompose")
po("crankcompose")
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

\link{PipeOpCrankCompositor} has one input channel named \code{"input"}, which takes \code{NULL} during training and \link{PredictionSurv} during prediction.

\link{PipeOpCrankCompositor} has one output channel named \code{"output"}, producing \code{NULL} during training and a \link{PredictionSurv} during prediction.

The output during prediction is the \link{PredictionSurv} from the input but with the \code{crank} predict type overwritten by the given estimation method.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\itemize{
\item \code{method} :: \code{character(1)} \cr
Determines what method should be used to produce a continuous ranking from the distribution.
Currently only \code{mort} is supported, which is the sum of the cumulative hazard, also called \emph{expected/ensemble mortality}, see Ishwaran et al. (2008).
For more details, see \code{\link[=get_mortality]{get_mortality()}}.
\item \code{overwrite} :: \code{logical(1)} \cr
If \code{FALSE} (default) and the prediction already has a \code{crank} prediction, then the compositor returns the input prediction unchanged.
If \code{TRUE}, then the \code{crank} will be overwritten.
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
\dontrun{
  library(mlr3pipelines)
  task = tsk("rats")

  # change the crank prediction type of a Cox's model predictions
  pred = lrn("surv.coxph")$train(task)$predict(task)
  poc = po("crankcompose", param_vals = list(overwrite = TRUE))
  poc$train(list(NULL)) # need to train first, even if nothing happens
  poc$predict(list(pred))[[1L]]
}
\dontshow{\}) # examplesIf}
}
\references{
Sonabend, Raphael, Bender, Andreas, Vollmer, Sebastian (2022).
\dQuote{Avoiding C-hacking when evaluating survival distribution predictions with discrimination measures.}
\emph{Bioinformatics}.
ISSN 1367-4803, \doi{10.1093/BIOINFORMATICS/BTAC451}, \url{https://academic.oup.com/bioinformatics/advance-article/doi/10.1093/bioinformatics/btac451/6640155}.

Ishwaran, Hemant, Kogalur, B U, Blackstone, H E, Lauer, S M, others (2008).
\dQuote{Random survival forests.}
\emph{The Annals of applied statistics}, \bold{2}(3), 841--860.
}
\seealso{
\link{pipeline_crankcompositor}

Other survival compositors: 
\code{\link{mlr_pipeops_compose_breslow_distr}},
\code{\link{mlr_pipeops_distrcompose}},
\code{\link{mlr_pipeops_responsecompose}}
}
\concept{survival compositors}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpCrankCompositor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpCrankCompositor-new}{\code{PipeOpCrankCompositor$new()}}
\item \href{#method-PipeOpCrankCompositor-clone}{\code{PipeOpCrankCompositor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpCrankCompositor-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpCrankCompositor-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpCrankCompositor$new(id = "crankcompose", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpCrankCompositor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpCrankCompositor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpCrankCompositor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
