% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpBreslow.R
\name{mlr_pipeops_compose_breslow_distr}
\alias{mlr_pipeops_compose_breslow_distr}
\alias{PipeOpBreslow}
\title{Wrap a learner into a PipeOp with survival predictions estimated by the Breslow estimator}
\description{
Composes a survival distribution (\code{distr}) using the linear predictor
predictions (\code{lp}) from a given \link{LearnerSurv} during training and prediction,
utilizing the \link[=breslow]{breslow estimator}. The specified \code{learner} must be
capable of generating \code{lp}-type predictions (e.g., a Cox-type model).
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{Dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr_pipeops}
or with the associated sugar function \link[mlr3pipelines:po]{po()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpBreslow$new(learner)
mlr_pipeops$get("breslowcompose", learner)
po("breslowcompose", learner, breslow.overwrite = TRUE)
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

\link{PipeOpBreslow} is like a \link{LearnerSurv}.
It has one input channel, named \code{input} that takes a \link{TaskSurv} during training
and another \link{TaskSurv} during prediction.
\link{PipeOpBreslow} has one output channel named \code{output}, producing \code{NULL} during
training and a \link{PredictionSurv} during prediction.
}

\section{State}{

The \verb{$state} slot stores the \code{times} and \code{status} survival target variables of
the train \link{TaskSurv} as well as the \code{lp} predictions on the train set.
}

\section{Parameters}{

The parameters are:
\itemize{
\item \code{breslow.overwrite} :: \code{logical(1)} \cr
If \code{FALSE} (default) then the compositor does nothing and returns the
input \code{learner}'s \link{PredictionSurv}.
If \code{TRUE} or in the case that the input \code{learner} doesn't have \code{distr}
predictions, then the \code{distr} is overwritten with the \code{distr} composed
from \code{lp} and the train set information using \link{breslow}.
This is useful for changing the prediction \code{distr} from one model form to
another.
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3pipelines)
  task = tsk("rats")
  part = partition(task, ratio = 0.8)
  train_task = task$clone()$filter(part$train)
  test_task = task$clone()$filter(part$test)

  learner = lrn("surv.coxph") # learner with lp predictions
  b = po("breslowcompose", learner = learner, breslow.overwrite = TRUE)

  b$train(list(train_task))
  p = b$predict(list(test_task))[[1L]]
}
\dontshow{\}) # examplesIf}
}
\references{
Breslow N (1972).
\dQuote{Discussion of 'Regression Models and Life-Tables' by D.R. Cox.}
\emph{Journal of the Royal Statistical Society: Series B}, \bold{34}(2), 216-217.

Lin, Y. D (2007).
\dQuote{On the Breslow estimator.}
\emph{Lifetime Data Analysis}, \bold{13}(4), 471-480.
\doi{10.1007/s10985-007-9048-y}.
}
\seealso{
\link{pipeline_distrcompositor}

Other survival compositors: 
\code{\link{mlr_pipeops_crankcompose}},
\code{\link{mlr_pipeops_distrcompose}},
\code{\link{mlr_pipeops_responsecompose}}
}
\concept{survival compositors}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpBreslow}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
The input survival learner.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpBreslow-new}{\code{PipeOpBreslow$new()}}
\item \href{#method-PipeOpBreslow-clone}{\code{PipeOpBreslow$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpBreslow-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpBreslow-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpBreslow$new(learner, id = NULL, param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\link{LearnerSurv})\cr
Survival learner which must provide \code{lp}-type predictions}

\item{\code{id}}{(character(1))\cr
Identifier of the resulting object. If \code{NULL} (default), it will be set
as the \code{id} of the input \code{learner}.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpBreslow-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpBreslow-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpBreslow$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
