% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvRCLL.R
\name{mlr_measures_surv.rcll}
\alias{mlr_measures_surv.rcll}
\alias{MeasureSurvRCLL}
\title{Right-Censored Log Loss Survival Measure}
\description{
Calculates the right-censored log-likelihood (RCLL) or logarithmic loss,
introduced by Avati et al. (2020).
}
\details{
The observation-wise RCLL is defined by:

\deqn{L_{RCLL}(S_i, t_i, \delta_i) = -log[\delta_i f_i(t_i) + (1 - \delta_i) S_i(t_i)]}

where \eqn{\delta_i} is the censoring indicator, \eqn{f_i} the predicted probability
density function and \eqn{S_i} the predicted survival function for observation \eqn{i}.
RCLL is proper given that censoring and survival distribution are independent, see Rindt et al. (2022).
Simulation studies by Sonabend et al. (2024) provide strong empirical evidence
supporting the properness of this score.
See section \strong{Interpolation} for implementation details.

To get a single score across all \eqn{N} observations of the test set, we
return the average of the observation-wise scores:

\deqn{\sum_{i=1}^N L_{RCLL}(S_i, t_i, \delta_i) / N}
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:mlr_sugar]{msr()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{MeasureSurvRCLL$new()
mlr_measures$get("surv.rcll")
msr("surv.rcll")
}\if{html}{\out{</div>}}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   eps \tab numeric \tab 1e-06 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   ERV \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{distr}
}
}

\section{Parameter details}{

\itemize{
\item \code{eps} (\code{numeric(1)})\cr
Very small number to substitute near-zero values in order to prevent errors
in e.g. log(0) and/or division-by-zero calculations.
Default value is 1e-06.
}


\itemize{
\item \code{ERV} (\code{logical(1)})\cr
If \code{TRUE} then the Explained Residual Variation method is applied, which
means the score is standardized against a Kaplan-Meier baseline.
Default is \code{FALSE}.
}
}

\section{Interpolation}{


To evaluate scores involving subject-specific survival functions
\eqn{S_i(t)}, we perform \strong{linear interpolation} on the discrete survival
values provided in the prediction.
Duplicate survival values are removed prior to interpolation to ensure strict
monotonicity and non-negative density values.
Therefore we are left with the distinct survival time points
\eqn{t_0 < \cdots < t_n} and the corresponding survival values \eqn{S(t_j)}.

Interpolation is performed using base R’s \code{approx()} with \code{method = "linear"}
and \code{rule = 2}, ensuring:
\itemize{
\item \strong{Left extrapolation} (for \eqn{t < t_0}) assumes \eqn{S(0) = 1} and uses
the slope from \eqn{(0, 1)} to \eqn{(t_0, S(t_0))}.
\item \strong{Right extrapolation} (for \eqn{t > t_n}) uses the slope from the last
interval \eqn{(t_{n-1}, S(t_{n-1}))} to \eqn{(t_n, S(t_n))}, with results
truncated at 0 to preserve non-negativity.
}

This ensures a continuous, piecewise-linear survival function \eqn{S(t)} that
satisfies \eqn{S(0) = 1} and remains non-increasing and non-negative across
the entire domain.

The density at time point \eqn{t_k}, with \eqn{t_i \le t_k < t_{i+1}}, is
estimated as follows:

\deqn{
f_i(t_k) = -\frac{S_i(t_{i+1}) - S_i(t_i)}{t_{i+1} - t_i}
}

This corresponds to the (negative) slope of the \eqn{S_i(t)} between the closest
grid point after \eqn{t_i} and \eqn{t_i} itself.
}

\references{
Avati, Anand, Duan, Tony, Zhou, Sharon, Jung, Kenneth, Shah, H N, Ng, Y A (2020).
\dQuote{Countdown Regression: Sharp and Calibrated Survival Predictions.}
\emph{Proceedings of The 35th Uncertainty in Artificial Intelligence Conference}, \bold{115}(4), 145--155.
\url{https://proceedings.mlr.press/v115/avati20a.html}.

Rindt, David, Hu, Robert, Steinsaltz, David, Sejdinovic, Dino (2022).
\dQuote{Survival regression with proper scoring rules and monotonic neural networks.}
\emph{Proceedings of The 25th International Conference on Artificial Intelligence and Statistics}, \bold{151}(4), 1190--1205.
\url{https://proceedings.mlr.press/v151/rindt22a.html}.

Sonabend, Raphael, Zobolas, John, Kopper, Philipp, Burk, Lukas, Bender, Andreas (2024).
\dQuote{Examining properness in the external validation of survival models with squared and logarithmic losses.}
\url{https://arxiv.org/abs/2212.05260v3}.
}
\seealso{
Other survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.calib_index}},
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.cindex}},
\code{\link{mlr_measures_surv.dcalib}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.mae}},
\code{\link{mlr_measures_surv.mse}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.rmse}},
\code{\link{mlr_measures_surv.schmid}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}

Other Probabilistic survival measures: 
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.schmid}}

Other distr survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_index}},
\code{\link{mlr_measures_surv.dcalib}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.schmid}}
}
\concept{Probabilistic survival measures}
\concept{distr survival measures}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{MeasureSurvRCLL}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureSurvRCLL-new}{\code{MeasureSurvRCLL$new()}}
\item \href{#method-MeasureSurvRCLL-clone}{\code{MeasureSurvRCLL$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvRCLL-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvRCLL-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvRCLL$new(ERV = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ERV}}{(\code{logical(1)})\cr
Standardize measure against a Kaplan-Meier baseline
(Explained Residual Variation)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvRCLL-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvRCLL-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvRCLL$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
