% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerDensSpline.R
\name{mlr_learners_dens.spline}
\alias{mlr_learners_dens.spline}
\alias{LearnerDensSpline}
\title{Smoothing Splines Density Estimator}
\description{
Calls \code{\link[gss:ssden]{gss::ssden()}} and the result is coerced to a \link[distr6:Distribution]{distr6::Distribution}.
}
\section{Dictionary}{

This \link[mlr3:Learner]{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_learners]{mlr_learners} or with the associated sugar function \link[mlr3:mlr_sugar]{lrn()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{LearnerDensSpline$new()
mlr_learners$get("dens.spline")
lrn("dens.spline")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Type: "dens"
\item Predict Types: \verb{pdf, cdf}
\item Feature Types: \verb{integer, numeric}
\item Properties: \code{missings}
\item Packages: \CRANpkg{mlr3} \CRANpkg{mlr3proba} \CRANpkg{gss} \CRANpkg{distr6}
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3", "mlr3proba", "gss", "distr6"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Define the Learner
learner = lrn("dens.spline")
print(learner)

# Define a Task
task = tsk("faithful")

# Create train and test set
ids = partition(task)

# Train the learner on the training ids
learner$train(task, row_ids = ids$train)

print(learner$model)

# Make predictions for the test rows
predictions = learner$predict(task, row_ids = ids$test)

# Score the predictions
predictions$score()
\dontshow{\}) # examplesIf}
}
\references{
Gu, Chong, Wang, Jingyuan (2003).
\dQuote{Penalized likelihood density estimation: Direct cross-validation and scalable approximation.}
\emph{Statistica Sinica}, 811--826.
}
\seealso{
Other density estimators: 
\code{\link{mlr_learners_dens.hist}},
\code{\link{mlr_learners_dens.kde}},
\code{\link{mlr_learners_dens.kde_ks}},
\code{\link{mlr_learners_dens.locfit}},
\code{\link{mlr_learners_dens.logspline}},
\code{\link{mlr_learners_dens.mixed}},
\code{\link{mlr_learners_dens.nonpar}},
\code{\link{mlr_learners_dens.pen}},
\code{\link{mlr_learners_dens.plug}}
}
\concept{density estimators}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3proba:LearnerDens]{mlr3proba::LearnerDens}} -> \code{LearnerDensSpline}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerDensSpline-new}{\code{LearnerDensSpline$new()}}
\item \href{#method-LearnerDensSpline-clone}{\code{LearnerDensSpline$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="configure"><a href='../../mlr3/html/Learner.html#method-Learner-configure'><code>mlr3::Learner$configure()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="selected_features"><a href='../../mlr3/html/Learner.html#method-Learner-selected_features'><code>mlr3::Learner$selected_features()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerDensSpline-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerDensSpline-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerDensSpline$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerDensSpline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerDensSpline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerDensSpline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
