% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{mlr_graphs_survtoclassif_disctime}
\alias{mlr_graphs_survtoclassif_disctime}
\alias{pipeline_survtoclassif_disctime}
\title{Survival to Classification Reduction using Discrete Time Pipeline}
\usage{
pipeline_survtoclassif_disctime(
  learner,
  cut = NULL,
  max_time = NULL,
  graph_learner = FALSE
)
}
\arguments{
\item{learner}{\link[mlr3:LearnerClassif]{LearnerClassif}\cr
Classification learner to fit the transformed \link[mlr3:TaskClassif]{TaskClassif}.
\code{learner} must have \code{predict_type} of type \code{"prob"}.}

\item{cut}{(\code{numeric()})\cr
Split points, used to partition the data into intervals.
If unspecified, all unique event times will be used.
If \code{cut} is a single integer, it will be interpreted as the number of equidistant
intervals from 0 until the maximum event time.}

\item{max_time}{(\code{numeric(1)})\cr
If cut is unspecified, this will be the last possible event time.
All event times after max_time will be administratively censored at max_time.}

\item{graph_learner}{(\code{logical(1)})\cr
If \code{TRUE} returns wraps the \link[mlr3pipelines:Graph]{Graph} as a
\link[mlr3pipelines:mlr_learners_graph]{GraphLearner} otherwise (default) returns as a \code{Graph}.}
}
\value{
\link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or \link[mlr3pipelines:mlr_learners_graph]{mlr3pipelines::GraphLearner}
}
\description{
Wrapper around \link{PipeOpTaskSurvClassifDiscTime} and \link{PipeOpPredClassifSurvDiscTime} to simplify \link[mlr3pipelines:Graph]{Graph} creation.
}
\details{
The pipeline consists of the following steps:
\enumerate{
\item \link{PipeOpTaskSurvClassifDiscTime} Converts \link{TaskSurv} to a \link[mlr3:TaskClassif]{TaskClassif}.
\item A \link[mlr3:LearnerClassif]{LearnerClassif} is fit and predicted on the new \code{TaskClassif}.
\item \link{PipeOpPredClassifSurvDiscTime} transforms the resulting \link[mlr3:PredictionClassif]{PredictionClassif} to \link{PredictionSurv}.
\item Optionally: \link[mlr3pipelines:mlr_pipeops_modelmatrix]{PipeOpModelMatrix} is used to transform the formula of the task
before fitting the learner.
}
}
\section{Dictionary}{

This \link[mlr3pipelines:Graph]{Graph} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3pipelines:mlr_graphs]{mlr_graphs} or with the associated sugar function \link[mlr3pipelines:ppl]{ppl()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_graphs$get("survtoclassif_disctime")
ppl("survtoclassif_disctime")
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines", "mlr3learners"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3learners)
  library(mlr3pipelines)

  task = tsk("lung")
  part = partition(task)

  grlrn = ppl(
    "survtoclassif_disctime",
    learner = lrn("classif.log_reg"),
    cut = 4, # 4 equidistant time intervals
    graph_learner = TRUE
  )
  grlrn$train(task, row_ids = part$train)
  grlrn$predict(task, row_ids = part$test)
}
\dontshow{\}) # examplesIf}
}
\references{
Tutz, Gerhard, Schmid, Matthias (2016).
\emph{Modeling Discrete Time-to-Event Data},  series Springer Series in Statistics.
Springer International Publishing.
ISBN 978-3-319-28156-8 978-3-319-28158-2, \url{http://link.springer.com/10.1007/978-3-319-28158-2}.
}
\seealso{
Other pipelines: 
\code{\link{mlr_graphs_crankcompositor}},
\code{\link{mlr_graphs_distrcompositor}},
\code{\link{mlr_graphs_probregr}},
\code{\link{mlr_graphs_responsecompositor}},
\code{\link{mlr_graphs_survaverager}},
\code{\link{mlr_graphs_survbagging}},
\code{\link{mlr_graphs_survtoclassif_IPCW}},
\code{\link{mlr_graphs_survtoregr_pem}}
}
\concept{pipelines}
