% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{mlr_graphs_responsecompositor}
\alias{mlr_graphs_responsecompositor}
\alias{pipeline_responsecompositor}
\title{Estimate Survival Time/Response Predict Type Pipeline}
\usage{
pipeline_responsecompositor(
  learner,
  method = "rmst",
  tau = NULL,
  add_crank = FALSE,
  overwrite = FALSE,
  graph_learner = FALSE
)
}
\arguments{
\item{learner}{\verb{[mlr3::Learner]|[mlr3pipelines::PipeOp]|[mlr3pipelines::Graph]} \cr
Either a \code{Learner} which will be wrapped in \link[mlr3pipelines:mlr_pipeops_learner]{mlr3pipelines::PipeOpLearner}, a \code{PipeOp} which will
be wrapped in \link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or a \code{Graph} itself. Underlying \code{Learner} should be
\link{LearnerSurv}.}

\item{method}{(\code{character(1)})\cr
Determines what method should be used to produce a survival time (response) from the survival distribution.
Available methods are \code{"rmst"} and \code{"median"}, corresponding to the \emph{restricted mean survival time} and the \emph{median survival time} respectively.}

\item{tau}{(\code{numeric(1)})\cr
Determines the time point up to which we calculate the restricted mean survival time (works only for the \code{"rmst"} method).
If \code{NULL} (default), all the available time points in the predicted survival distribution will be used.}

\item{add_crank}{(\code{logical(1)})\cr
If \code{TRUE} then \code{crank} predict type will be set as \code{-response} (as higher survival times correspond to lower risk).
Works only if \code{overwrite} is \code{TRUE}.}

\item{overwrite}{(\code{logical(1)})\cr
If \code{FALSE} (default) and the prediction already has a \code{response} prediction, then the compositor returns the input prediction unchanged.
If \code{TRUE}, then the \code{response} (and the \code{crank}, if \code{add_crank} is \code{TRUE}) will be overwritten.}

\item{graph_learner}{(\code{logical(1)})\cr
If \code{TRUE} returns wraps the \link[mlr3pipelines:Graph]{Graph} as a
\link[mlr3pipelines:mlr_learners_graph]{GraphLearner} otherwise (default) returns as a \code{Graph}.}
}
\value{
\link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or \link[mlr3pipelines:mlr_learners_graph]{mlr3pipelines::GraphLearner}
}
\description{
Wrapper around \link{PipeOpResponseCompositor} to simplify \link[mlr3pipelines:Graph]{Graph} creation.
}
\section{Dictionary}{

This \link[mlr3pipelines:Graph]{Graph} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3pipelines:mlr_graphs]{mlr_graphs} or with the associated sugar function \link[mlr3pipelines:ppl]{ppl()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_graphs$get("responsecompositor")
ppl("responsecompositor")
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3pipelines)

  task = tsk("lung")
  part = partition(task)

  # add survival time prediction type to the predictions of a Cox model
  grlrn = ppl(
    "responsecompositor",
    learner = lrn("surv.coxph"),
    method = "rmst",
    overwrite = TRUE,
    graph_learner = TRUE
  )
  grlrn$train(task, part$train)
  grlrn$predict(task, part$test)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other pipelines: 
\code{\link{mlr_graphs_crankcompositor}},
\code{\link{mlr_graphs_distrcompositor}},
\code{\link{mlr_graphs_probregr}},
\code{\link{mlr_graphs_survaverager}},
\code{\link{mlr_graphs_survbagging}},
\code{\link{mlr_graphs_survtoclassif_IPCW}},
\code{\link{mlr_graphs_survtoclassif_disctime}},
\code{\link{mlr_graphs_survtoregr_pem}}
}
\concept{pipelines}
