% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{mlr_graphs_probregr}
\alias{mlr_graphs_probregr}
\alias{pipeline_probregr}
\title{Estimate Regression distr Predict Type Pipeline}
\usage{
pipeline_probregr(
  learner,
  learner_se = NULL,
  dist = "Uniform",
  graph_learner = FALSE
)
}
\arguments{
\item{learner}{\verb{[mlr3::Learner]|[mlr3pipelines::PipeOp]|[mlr3pipelines::Graph]} \cr
Either a \code{Learner} which will be wrapped in \link[mlr3pipelines:mlr_pipeops_learner]{mlr3pipelines::PipeOpLearner}, a \code{PipeOp} which will
be wrapped in \link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or a \code{Graph} itself. Underlying \code{Learner} should be
\link[mlr3:LearnerRegr]{LearnerRegr}.}

\item{learner_se}{\verb{[mlr3::Learner]|[mlr3pipelines::PipeOp]} \cr
Optional \link[mlr3:LearnerRegr]{LearnerRegr} with predict_type \code{se} to estimate the standard
error. If left \code{NULL} then \code{learner} must have \code{se} in predict_types.}

\item{dist}{(\code{character(1)})\cr
Location-scale distribution to use for composition.
Current possibilities are' \verb{"Cauchy", "Gumbel", "Laplace", "Logistic", "Normal", "Uniform"}. Default is \code{"Uniform"}.}

\item{graph_learner}{(\code{logical(1)})\cr
If \code{TRUE} returns wraps the \link[mlr3pipelines:Graph]{Graph} as a
\link[mlr3pipelines:mlr_learners_graph]{GraphLearner} otherwise (default) returns as a \code{Graph}.}
}
\value{
\link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or \link[mlr3pipelines:mlr_learners_graph]{mlr3pipelines::GraphLearner}
}
\description{
Wrapper around \link{PipeOpProbregr} to simplify \link[mlr3pipelines:Graph]{Graph} creation.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\section{Dictionary}{

This \link[mlr3pipelines:Graph]{Graph} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3pipelines:mlr_graphs]{mlr_graphs} or with the associated sugar function \link[mlr3pipelines:ppl]{ppl()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_graphs$get("probregr")
ppl("probregr")
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines", "rpart"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3pipelines)

  task = tsk("boston_housing")

  # method 1 - same learner for response and se
  pipe = ppl(
    "probregr",
    learner = lrn("regr.featureless", predict_type = "se"),
    dist = "Uniform"
  )
  pipe$train(task)
  pipe$predict(task)

  # method 2 - different learners for response and se
  pipe = ppl(
    "probregr",
    learner = lrn("regr.rpart"),
    learner_se = lrn("regr.featureless", predict_type = "se"),
    dist = "Normal"
  )
  pipe$train(task)
  pipe$predict(task)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other pipelines: 
\code{\link{mlr_graphs_crankcompositor}},
\code{\link{mlr_graphs_distrcompositor}},
\code{\link{mlr_graphs_responsecompositor}},
\code{\link{mlr_graphs_survaverager}},
\code{\link{mlr_graphs_survbagging}},
\code{\link{mlr_graphs_survtoclassif_IPCW}},
\code{\link{mlr_graphs_survtoclassif_disctime}},
\code{\link{mlr_graphs_survtoregr_pem}}
}
\concept{pipelines}
