% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.LearnerSurvCoxPH}
\alias{autoplot.LearnerSurvCoxPH}
\title{Plots for Cox Proportional Hazards Learner}
\usage{
\method{autoplot}{LearnerSurvCoxPH}(object, type = "ggforest", ...)
}
\arguments{
\item{object}{(\link{LearnerSurvCoxPH}).}

\item{type}{(character(1))\cr
Type of the plot. See description.}

\item{...}{Additional parameters passed down to \code{ggforest}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link{LearnerSurvCoxPH}.

The argument \code{type} controls what kind of plot is drawn.
The only possible choice right now is \code{"ggforest"} which is a Forest Plot,
using \link[survminer:ggforest]{ggforest}.
This plot displays the estimated hazard ratios (HRs) and their confidence
intervals (CIs) for different variables included in the trained model.
}
\examples{
\dontshow{if (mlr3misc::require_namespaces(c("ggplot2", "survminer"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(ggplot2)

task = tsk("lung")
learner = lrn("surv.coxph")
learner$train(task)
autoplot(learner)
\dontshow{\}) # examplesIf}
}
