% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task_surv.R
\name{as_task_surv}
\alias{as_task_surv}
\alias{as_task_surv.TaskSurv}
\alias{as_task_surv.data.frame}
\alias{as_task_surv.DataBackend}
\title{Convert to a Survival Task}
\usage{
as_task_surv(x, ...)

\method{as_task_surv}{TaskSurv}(x, clone = FALSE, ...)

\method{as_task_surv}{data.frame}(
  x,
  time = "time",
  event = "event",
  time2 = "time2",
  type = "right",
  id = deparse(substitute(x)),
  ...
)

\method{as_task_surv}{DataBackend}(
  x,
  time = "time",
  event = "event",
  time2,
  type = "right",
  id = deparse(substitute(x)),
  ...
)
}
\arguments{
\item{x}{(\code{any})\cr
Object to convert, e.g. a \code{data.frame()}.}

\item{...}{(\code{any})\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}

\item{time}{(\code{character(1)})\cr
Name of the column for event time if data is right censored, otherwise starting time if
interval censored.}

\item{event}{(\code{character(1)})\cr
Name of the column giving the event indicator.
If data is right censored then \code{0} means alive (no event) and \code{1} means dead (event).
If \code{type} is \code{"interval"} then \code{event} is ignored.}

\item{time2}{(\code{character(1)})\cr
Name of the column for ending time of the interval for interval censored data,
otherwise ignored.}

\item{type}{(\code{character(1)})\cr
The type of censoring. Can be \code{"right"} (default), \code{"left"} or \code{"interval"} censoring.}

\item{id}{(\code{character(1)})\cr
Id for the new task.
Defaults to the (deparsed and substituted) name of \code{x}.}
}
\description{
Convert object to a survival task (\link{TaskSurv}).
}
