test_that("autotest", {
  set.seed(1L)
  learner = lrn("dens.hist")
  expect_learner(learner)
  result = run_autotest(learner)
  expect_true(result, info = result$error)
})

test_that("pdf and cdf work", {
  x = c(0.2, 0.4, 0.6, 0.8, 1, 1.2, 1.4, 1.6)
  task = TaskDens$new(id = "task", x)
  lrn = lrn("dens.hist", breaks = 5)
  p = lrn$train(task)
  dist = p$model$dist

  expect_equal(dist$pdf(0), 0.5)
  expect_equal(dist$pdf(0.5), 0.5)
  expect_equal(dist$pdf(1.0), 0.75)
  expect_equal(dist$pdf(1.5), 0.25)
  expect_equal(dist$pdf(2.0), 0.25)
  expect_equal(dist$pdf(-1), 0)
  expect_equal(dist$pdf(3), 0)

  expect_equal(dist$cdf(0), 0)
  expect_equal(dist$cdf(0.5), 0.25)
  expect_equal(dist$cdf(1.0), 0.5)
  expect_equal(dist$cdf(1.5), 0.875)
  expect_equal(dist$cdf(2.0), 1)
  expect_equal(dist$cdf(-1), 0)
  expect_equal(dist$cdf(3), 1)
})
