% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task_zzz.R
\name{mlr_tasks_actg}
\alias{mlr_tasks_actg}
\title{ACTG 320 Survival Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskSurv}.
}
\description{
A survival task for the \link{actg} data set.
}
\section{Dictionary}{

This \link[mlr3:Task]{Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_tasks]{mlr_tasks} or with the associated sugar function \link[mlr3:mlr_sugar]{tsk()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("actg")
tsk("actg")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{surv}
\item Dimensions: 1151x13
\item Properties: -
\item Has Missings: \code{FALSE}
\item Target: \dQuote{time}, \dQuote{status}
\item Features: \dQuote{age}, \dQuote{cd4}, \dQuote{hemophil}, \dQuote{ivdrug}, \dQuote{karnof}, \dQuote{priorzdv}, \dQuote{raceth}, \dQuote{sexF}, \dQuote{strat2}, \dQuote{tx}, \dQuote{txgrp}
}
}

\section{Pre-processing}{

\itemize{
\item Column \code{sex} has been renamed to \code{sexF} and \code{censor} has been renamed to \code{status}.
\item Columns \code{id}, \code{time_d}, and \code{censor_d} have been removed so target is \code{time}
to AIDS diagnosis (in days).
}
}

\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Task]{Tasks}: \link[mlr3:mlr_tasks]{mlr3::mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[mlr3:Task]{Tasks} in the running session
}

Other Task: 
\code{\link{TaskDens}},
\code{\link{TaskSurv}},
\code{\link{mlr_tasks_faithful}},
\code{\link{mlr_tasks_gbcs}},
\code{\link{mlr_tasks_gbsg}},
\code{\link{mlr_tasks_grace}},
\code{\link{mlr_tasks_lung}},
\code{\link{mlr_tasks_mgus}},
\code{\link{mlr_tasks_precip}},
\code{\link{mlr_tasks_rats}},
\code{\link{mlr_tasks_veteran}},
\code{\link{mlr_tasks_whas}}
}
\concept{Task}
