% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvCalibrationBeta.R
\name{mlr_measures_surv.calib_beta}
\alias{mlr_measures_surv.calib_beta}
\alias{MeasureSurvCalibrationBeta}
\title{Van Houwelingen's Calibration Beta Survival Measure}
\description{
This calibration method fits the predicted linear predictor from a Cox PH
model as the only predictor in a new Cox PH model with the test data as
the response.
\deqn{h(t|x) = h_0(t)e^{\beta \times lp}}
where \eqn{lp} is the predicted linear predictor on the test data.

The model is well calibrated if the estimated \eqn{\hat{\beta}} coefficient
(returned score) is equal to 1.

\strong{Note}: Assumes fitted model is Cox PH (i.e. has an \code{lp} prediction type).
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:mlr_sugar]{msr()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{MeasureSurvCalibrationBeta$new()
mlr_measures$get("surv.calib_beta")
msr("surv.calib_beta")
}\if{html}{\out{</div>}}
}

\section{Parameters}{
\tabular{llll}{
   Id \tab Type \tab Default \tab Levels \cr
   se \tab logical \tab FALSE \tab TRUE, FALSE \cr
   method \tab character \tab ratio \tab ratio, diff \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{(-\infty, \infty)}{(-Inf, Inf)}
\item Minimize: \code{FALSE}
\item Required prediction: \code{lp}
}
}

\section{Parameter details}{

\itemize{
\item \code{se} (\code{logical(1)})\cr
If \code{TRUE} then return standard error of the measure which is the standard
error of the estimated coefficient \eqn{se_{\hat{\beta}}} from the Cox PH model.
If \code{FALSE} (default) then returns the estimated coefficient \eqn{\hat{\beta}}.
\item \code{method} (\code{character(1)})\cr
Returns \eqn{\hat{\beta}} if equal to \code{ratio} (default) and \eqn{|1-\hat{\beta}|}
if \code{diff}.
With \code{diff}, the output score can be minimized and for example be used for
tuning purposes.
This parameter takes effect only if \code{se} is \code{FALSE}.
}
}

\references{
Van Houwelingen, C. H (2000).
\dQuote{Validation, calibration, revision and combination of prognostic survival models.}
\emph{Statistics in Medicine}, \bold{19}(24), 3401--3415.
\doi{10.1002/1097-0258(20001230)19:24<3401::AID-SIM554>3.0.CO;2-2}.
}
\seealso{
Other survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_index}},
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.cindex}},
\code{\link{mlr_measures_surv.dcalib}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.mae}},
\code{\link{mlr_measures_surv.mse}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.rcll}},
\code{\link{mlr_measures_surv.rmse}},
\code{\link{mlr_measures_surv.schmid}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}

Other calibration survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_index}},
\code{\link{mlr_measures_surv.dcalib}}

Other lp survival measures: 
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}
}
\concept{calibration survival measures}
\concept{lp survival measures}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{MeasureSurvCalibrationBeta}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureSurvCalibrationBeta-new}{\code{MeasureSurvCalibrationBeta$new()}}
\item \href{#method-MeasureSurvCalibrationBeta-clone}{\code{MeasureSurvCalibrationBeta$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvCalibrationBeta-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvCalibrationBeta-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvCalibrationBeta$new(method = "ratio")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{defines which output score to return, see "Parameter
details" section.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvCalibrationBeta-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvCalibrationBeta-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvCalibrationBeta$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
