% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureRegrLogloss.R
\name{mlr_measures_regr.logloss}
\alias{mlr_measures_regr.logloss}
\alias{MeasureRegrLogloss}
\title{Log Loss Regression Measure}
\description{
Calculates the cross-entropy, or logarithmic (log), loss.
}
\details{
The Log Loss, in the context of probabilistic predictions, is defined as the negative log
probability density function, \eqn{f}, evaluated at the observed value, \eqn{y},
\deqn{L(f, y) = -\log(f(y))}{L(f, y) = -log(f(y))}
}
\section{Parameters}{
\tabular{llll}{
   Id \tab Type \tab Default \tab Range \cr
   eps \tab numeric \tab 1e-15 \tab \eqn{[0, 1]}{[0, 1]} \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{distr}
}
}

\section{Parameter details}{

\itemize{
\item \code{eps} (\code{numeric(1)})\cr
Very small number to substitute near-zero values in order to prevent errors
in e.g. log(0) and/or division-by-zero calculations.
Default value is 1e-15.
}
}

\concept{regression measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3:MeasureRegr]{mlr3::MeasureRegr}} -> \code{MeasureRegrLogloss}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureRegrLogloss-new}{\code{MeasureRegrLogloss$new()}}
\item \href{#method-MeasureRegrLogloss-clone}{\code{MeasureRegrLogloss$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureRegrLogloss-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureRegrLogloss-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureRegrLogloss$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureRegrLogloss-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureRegrLogloss-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureRegrLogloss$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
