% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerDensPenalized.R
\name{mlr_learners_dens.pen}
\alias{mlr_learners_dens.pen}
\alias{LearnerDensPenalized}
\title{Penalized Density Estimator}
\description{
Calls \code{\link[pendensity:pendensity]{pendensity::pendensity()}} and the result is coerced to a \link[distr6:Distribution]{distr6::Distribution}.
}
\details{
Density estimation using penalized B-splines with automatic selection of smoothing parameter.
}
\section{Dictionary}{

This \link[mlr3:Learner]{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_learners]{mlr_learners} or with the associated sugar function \link[mlr3:mlr_sugar]{lrn()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{LearnerDensPenalized$new()
mlr_learners$get("dens.pen")
lrn("dens.pen")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Type: "dens"
\item Predict Types: \verb{pdf, cdf}
\item Feature Types: \verb{integer, numeric}
\item Properties: \code{-}
\item Packages: \CRANpkg{mlr3} \CRANpkg{mlr3proba} \CRANpkg{pendensity} \CRANpkg{distr6}
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3", "mlr3proba", "pendensity", "distr6"), quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Define the Learner
learner = lrn("dens.pen")
print(learner)

# Define a Task
task = tsk("faithful")

# Create train and test set
ids = partition(task)

# Train the learner on the training ids
learner$train(task, row_ids = ids$train)

print(learner$model)

# Make predictions for the test rows
predictions = learner$predict(task, row_ids = ids$test)

# Score the predictions
predictions$score()
\dontshow{\}) # examplesIf}
}
\references{
Schellhase, Christian, Kauermann, Göran (2012).
\dQuote{Density estimation and comparison with a penalized mixture approach.}
\emph{Computational Statistics}, \bold{27}(4), 757--777.
}
\seealso{
Other density estimators: 
\code{\link{mlr_learners_dens.hist}},
\code{\link{mlr_learners_dens.kde}},
\code{\link{mlr_learners_dens.kde_ks}},
\code{\link{mlr_learners_dens.locfit}},
\code{\link{mlr_learners_dens.logspline}},
\code{\link{mlr_learners_dens.mixed}},
\code{\link{mlr_learners_dens.nonpar}},
\code{\link{mlr_learners_dens.plug}},
\code{\link{mlr_learners_dens.spline}}
}
\concept{density estimators}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3proba:LearnerDens]{mlr3proba::LearnerDens}} -> \code{LearnerDensPenalized}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerDensPenalized-new}{\code{LearnerDensPenalized$new()}}
\item \href{#method-LearnerDensPenalized-clone}{\code{LearnerDensPenalized$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="configure"><a href='../../mlr3/html/Learner.html#method-Learner-configure'><code>mlr3::Learner$configure()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="selected_features"><a href='../../mlr3/html/Learner.html#method-Learner-selected_features'><code>mlr3::Learner$selected_features()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerDensPenalized-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerDensPenalized-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerDensPenalized$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerDensPenalized-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerDensPenalized-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerDensPenalized$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
