% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_return.R
\name{get_mortality}
\alias{get_mortality}
\title{Calculate the expected mortality risks from a survival matrix}
\usage{
get_mortality(x)
}
\arguments{
\item{x}{(\code{matrix()}) \cr A survival matrix where rows are the
(predicted) observations and columns the time-points.
For more details, see \link{assert_surv_matrix}.}
}
\value{
a \code{numeric} vector of the mortality risk scores, one per row of the
input survival matrix.
}
\description{
Many methods can be used to reduce a discrete survival
distribution prediction (i.e. matrix) to a relative risk / ranking
prediction, see Sonabend et al. (2022).

This function calculates a relative risk score as the sum of the
predicted cumulative hazard function, also called \strong{ensemble/expected mortality}.
This risk score can be loosely interpreted as the expected number of deaths for
patients with similar characteristics, see Ishwaran et al. (2008) and has no
model or survival distribution assumptions.
}
\examples{
n = 10 # number of observations
k = 50 # time points

# Create the matrix with random values between 0 and 1
mat = matrix(runif(n * k, min = 0, max = 1), nrow = n, ncol = k)

# transform it to a survival matrix
surv_mat = t(apply(mat, 1L, function(row) sort(row, decreasing = TRUE)))
colnames(surv_mat) = 1:k # time points

# get mortality scores (the larger, the more risk)
mort = get_mortality(surv_mat)
mort

}
\references{
Sonabend, Raphael, Bender, Andreas, Vollmer, Sebastian (2022).
\dQuote{Avoiding C-hacking when evaluating survival distribution predictions with discrimination measures.}
\emph{Bioinformatics}.
ISSN 1367-4803, \doi{10.1093/BIOINFORMATICS/BTAC451}, \url{https://academic.oup.com/bioinformatics/advance-article/doi/10.1093/bioinformatics/btac451/6640155}.

Ishwaran, Hemant, Kogalur, B U, Blackstone, H E, Lauer, S M, others (2008).
\dQuote{Random survival forests.}
\emph{The Annals of applied statistics}, \bold{2}(3), 841--860.
}
