% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gbcs}
\alias{gbcs}
\title{German Breast Cancer Study (GBCS) Dataset}
\format{
\describe{
\item{id}{Identification Code}
\item{diagdate}{Date of diagnosis.}
\item{recdate}{Date of recurrence free survival.}
\item{deathdate}{Date of death.}
\item{age}{Age at diagnosis (years).}
\item{menopause}{Menopausal status. 1 = Yes, 0 = No.}
\item{hormone}{Hormone therapy. 1 = Yes. 0 = No.}
\item{size}{Tumor size (mm).}
\item{grade}{Tumor grade (1-3).}
\item{nodes}{Number of lymph nodes.}
\item{prog_recp}{Number of progesterone receptors.}
\item{estrg_recp}{Number of estrogen receptors.}
\item{rectime}{Time to recurrence (days).}
\item{censrec}{Recurrence status. 1 = Recurrence. 0 = Censored.}
\item{survtime}{Time to death (days).}
\item{censdead}{Censoring status. 1 = Death. 0 = Censored.}
}
}
\source{
\url{https://onlinelibrary.wiley.com/doi/book/10.1002/9780470258019}
}
\usage{
gbcs
}
\description{
gbcs dataset from Hosmer et al. (2008)
}
\references{
Hosmer, D.W. and Lemeshow, S. and May, S. (2008)
Applied Survival Analysis: Regression Modeling of Time to Event Data: Second
Edition, John Wiley and Sons Inc., New York, NY
}
\keyword{datasets}
