% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.TaskSurv}
\alias{autoplot.TaskSurv}
\title{Plot for Survival Tasks}
\usage{
\method{autoplot}{TaskSurv}(
  object,
  type = "target",
  theme = theme_minimal(),
  reverse = FALSE,
  ...
)
}
\arguments{
\item{object}{(\link{TaskSurv}).}

\item{type}{(\code{character(1)}):\cr
Type of the plot. See above for available choices.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{reverse}{(\code{logical()})\cr
If \code{TRUE} and \code{type = 'target'}, it plots the Kaplan-Meier curve of the
censoring distribution. Default is \code{FALSE}.}

\item{...}{(\code{any}):
Additional arguments.
\code{rhs} is passed down to \verb{$formula} of \link{TaskSurv} for stratification
for type \code{"target"}. Other arguments are passed to the respective underlying plot
functions.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link{TaskSurv}, depending on argument \code{type}:
\itemize{
\item \code{"target"}: Calls \code{\link[GGally:ggsurv]{GGally::ggsurv()}} on a \code{\link[survival:survfit]{survival::survfit()}} object.
This computes the \strong{Kaplan-Meier survival curve} for the observations if this task.
\item \code{"duo"}: Passes data and additional arguments down to \code{\link[GGally:ggduo]{GGally::ggduo()}}.
\code{columnsX} is target, \code{columnsY} is features.
\item \code{"pairs"}: Passes data and additional arguments down to
\code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Color is set to target column.
}
}
\examples{
\dontshow{if (mlr3misc::require_namespaces("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(ggplot2)

task = tsk("lung")
task$head()

autoplot(task) # KM
autoplot(task) # KM of the censoring distribution
autoplot(task, rhs = "sex")
autoplot(task, type = "duo")
\dontshow{\}) # examplesIf}
}
