% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskSurv_zzz.R
\name{mlr_tasks_rats}
\alias{mlr_tasks_rats}
\title{Rats Survival Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskSurv}.
}
\description{
A survival task for the \link{rats} data set.
}
\section{Dictionary}{

This \link{Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_tasks} or with the associated sugar function \code{\link[=tsk]{tsk()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("rats")
tsk("rats")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{surv}
\item Dimensions: 300x5
\item Properties: -
\item Has Missings: \code{FALSE}
\item Target: \dQuote{time}, \dQuote{status}
\item Features: \dQuote{litter}, \dQuote{rx}, \dQuote{sex}
}
}

\section{Pre-processing}{

\itemize{
\item Column \code{sex} has been converted to a \code{factor}, all others have been
converted to \code{integer}.
}
}

\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Task]{Tasks}: \link[mlr3:mlr_tasks]{mlr3::mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[=Task]{Tasks} in the running session
}

Other Task: 
\code{\link{TaskDens}},
\code{\link{TaskSurv}},
\code{\link{mlr_tasks_actg}},
\code{\link{mlr_tasks_faithful}},
\code{\link{mlr_tasks_gbcs}},
\code{\link{mlr_tasks_gbsg}},
\code{\link{mlr_tasks_grace}},
\code{\link{mlr_tasks_lung}},
\code{\link{mlr_tasks_mgus}},
\code{\link{mlr_tasks_pbc}},
\code{\link{mlr_tasks_precip}},
\code{\link{mlr_tasks_veteran}},
\code{\link{mlr_tasks_whas}}
}
\concept{Task}
