% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskGeneratorCoxed.R
\name{mlr_task_generators_coxed}
\alias{mlr_task_generators_coxed}
\alias{TaskGeneratorCoxed}
\title{Survival Task Generator for Package 'coxed'}
\description{
A \link[mlr3:TaskGenerator]{mlr3::TaskGenerator} calling \code{\link[coxed:sim.survdata]{coxed::sim.survdata()}}.

This generator creates a survival dataset using \CRANpkg{coxed}, and exposes
some parameters from the \code{sim.survdata()} function.
We don't include the parameters \code{X} (user-specified variables), \code{covariate},
\code{low}, \code{high}, \code{compare}, \code{beta} and \code{hazard.fun} for this generator.
The latter means that no user-specified hazard function can be used and the
generated datasets always use the \emph{flexible-hazard} method from the package.
}
\section{Dictionary}{

This \link{TaskGenerator} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_task_generators} or with the associated sugar function \code{\link[=tgen]{tgen()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_task_generators$get("coxed")
tgen("coxed")
}\if{html}{\out{</div>}}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   T \tab numeric \tab 100 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   type \tab character \tab none \tab none, tvc, tvbeta \tab - \cr
   knots \tab integer \tab 8 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   spline \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   xvars \tab integer \tab 3 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   mu \tab untyped \tab 0 \tab  \tab - \cr
   sd \tab untyped \tab 0.5 \tab  \tab - \cr
   censor \tab numeric \tab 0.1 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   censor.cond \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("coxed"), quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  library(mlr3)

  # time horizon = 365 days, censoring proportion = 60\%, 6 covariates normally
  # distributed with mean = 1 and sd = 2, independent censoring, no time-varying
  # effects
  gen = tgen("coxed", T = 365, type = "none", censor = 0.6, xvars = 6,
              mu = 1, sd = 2, censor.cond = FALSE)
  gen$generate(50)

  # same as above, but with time-varying coefficients (counting process format)
  gen$param_set$set_values(type = "tvc")
  gen$generate(50)
\dontshow{\}) # examplesIf}
}
\references{
Harden, J. J, Kropko, Jonathan (2019).
\dQuote{Simulating Duration Data for the Cox Model.}
\emph{Political Science Research and Methods}, \bold{7}(4), 921--928.
\doi{10.1017/PSRM.2018.19}.
}
\seealso{
\itemize{
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:TaskGenerator]{TaskGenerators}: \link[mlr3:mlr_task_generators]{mlr3::mlr_task_generators}
\item \code{as.data.table(mlr_task_generators)}  for a table of available \link[=TaskGenerator]{TaskGenerators} in the running session
}

Other TaskGenerator: 
\code{\link{mlr_task_generators_simdens}},
\code{\link{mlr_task_generators_simsurv}}
}
\concept{TaskGenerator}
\section{Super class}{
\code{\link[mlr3:TaskGenerator]{mlr3::TaskGenerator}} -> \code{TaskGeneratorCoxed}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TaskGeneratorCoxed-new}{\code{TaskGeneratorCoxed$new()}}
\item \href{#method-TaskGeneratorCoxed-help}{\code{TaskGeneratorCoxed$help()}}
\item \href{#method-TaskGeneratorCoxed-clone}{\code{TaskGeneratorCoxed$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="format"><a href='../../mlr3/html/TaskGenerator.html#method-TaskGenerator-format'><code>mlr3::TaskGenerator$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="generate"><a href='../../mlr3/html/TaskGenerator.html#method-TaskGenerator-generate'><code>mlr3::TaskGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="print"><a href='../../mlr3/html/TaskGenerator.html#method-TaskGenerator-print'><code>mlr3::TaskGenerator$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskGeneratorCoxed-new"></a>}}
\if{latex}{\out{\hypertarget{method-TaskGeneratorCoxed-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorCoxed$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskGeneratorCoxed-help"></a>}}
\if{latex}{\out{\hypertarget{method-TaskGeneratorCoxed-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorCoxed$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaskGeneratorCoxed-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TaskGeneratorCoxed-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorCoxed$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
