% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTaskSurvRegrPEM.R
\name{mlr_pipeops_trafotask_survregr_pem}
\alias{mlr_pipeops_trafotask_survregr_pem}
\alias{PipeOpTaskSurvRegrPEM}
\title{PipeOpTaskSurvRegrPEM}
\description{
Transform \link{TaskSurv} to \link[mlr3:TaskRegr]{TaskRegr} by dividing continuous
time into multiple time intervals for each observation.
This transformation creates a new target variable \code{pem_status} that indicates
whether an event occurred within each time interval.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops}
or with the associated sugar function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpTaskSurvRegrPEM$new()
mlr_pipeops$get("trafotask_survregr_pem")
po("trafotask_survregr_pem")
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

\link{PipeOpTaskSurvRegrPEM} has one input channel named "input", and two
output channels, one named "output" and the other "transformed_data".

During training, the "output" is the "input" \link{TaskSurv} transformed to a
\link[mlr3:TaskRegr]{TaskRegr}.
The target column is named \code{"pem_status"} and indicates whether an event occurred
in each time interval.
An additional numeric feature named \code{"tend"} contains the end time point of each interval.
Lastly, the "output" task has an offset column \code{"offset"}.
The offset, also referred to as \emph{exposure}, is the \strong{logarithm of time spent in interval} \eqn{j}, i.e. \eqn{log(t_j)}.
The "transformed_data" is an empty \link[data.table:data.table]{data.table}.

During prediction, the "input" \link{TaskSurv} is transformed to the "output"
\link[mlr3:TaskRegr]{TaskRegr} with \code{"pem_status"} as target, \code{"tend"} included as feature and
and the \code{"offset"} column which is assigned the offset \code{"col_role"}.
The "transformed_data" is a \link{data.table} with columns the \code{"pem_status"}
target of the "output" task, the \code{"id"} (original observation ids),
\code{"obs_times"} (observed times per \code{"id"}) and \code{"tend"} (end time of each interval).
This "transformed_data" is only meant to be used with the \link{PipeOpPredRegrSurvPEM}.
}

\section{State}{

The \verb{$state} contains information about the \code{cut} parameter used.
}

\section{Parameters}{

The parameters are
\itemize{
\item \code{cut :: numeric()}\cr
Split points, used to partition the data into intervals based on the \code{time} column.
If unspecified, all unique event times will be used.
If \code{cut} is a single integer, it will be interpreted as the number of equidistant
intervals from 0 until the maximum event time.
\item \code{max_time :: numeric(1)}\cr
If \code{cut} is unspecified, this will be the last possible event time.
All event times after \code{max_time} will be administratively censored at \code{max_time.}
Needs to be greater than the minimum event time in the given task.
}
}

\examples{
\dontshow{if ((mlr3misc::require_namespaces(c("mlr3pipelines", "mlr3extralearners"), quietly = TRUE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3learners)
  library(mlr3pipelines)

  task = tsk("lung")

  # transform the survival task to a regression task
  # all unique event times are used as cutpoints
  po_pem = po("trafotask_survregr_pem")
  task_regr = po_pem$train(list(task))[[1L]]

  # the end time points of the discrete time intervals
  unique(task_regr$data(cols = "tend")[[1L]])

  # train a regression learner that supports poisson regression
  # e.g. regr.gam
  # won't run unless learner can accept offset column role
  learner = lrn("regr.gam", formula = pem_status ~ s(age) + s(tend), family = "poisson")
  learner$train(task_regr)

  # e.g. regr.xgboost, note prior data processing steps
  learner = as_learner(
    po("modelmatrix", formula = ~ as.factor(tend) + .) \%>>\%
    lrn("regr.xgboost", objective = "count:poisson", nrounds = 100, eta = 0.1)
  )
  learner$train(task_regr)
  }
\dontshow{\}) # examplesIf}
}
\references{
Bender, Andreas, Groll, Andreas, Scheipl, Fabian (2018).
\dQuote{A generalized additive model approach to time-to-event analysis.}
\emph{Statistical Modelling}, \bold{18}(3-4), 299--321.
\url{https://doi.org/10.1177/1471082X17748083}.
}
\seealso{
\link{pipeline_survtoregr_pem}

Other PipeOps: 
\code{\link{mlr_pipeops_survavg}},
\code{\link{mlr_pipeops_trafopred_regrsurv_pem}}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_classifsurv_IPCW}},
\code{\link{mlr_pipeops_trafopred_classifsurv_disctime}},
\code{\link{mlr_pipeops_trafopred_regrsurv_pem}},
\code{\link{mlr_pipeops_trafotask_survclassif_IPCW}},
\code{\link{mlr_pipeops_trafotask_survclassif_disctime}}
}
\concept{PipeOps}
\concept{Transformation PipeOps}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpTaskSurvRegrPEM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpTaskSurvRegrPEM-new}{\code{PipeOpTaskSurvRegrPEM$new()}}
\item \href{#method-PipeOpTaskSurvRegrPEM-clone}{\code{PipeOpTaskSurvRegrPEM$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTaskSurvRegrPEM-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTaskSurvRegrPEM-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskSurvRegrPEM$new(id = "trafotask_survregr_pem")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTaskSurvRegrPEM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTaskSurvRegrPEM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskSurvRegrPEM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
