% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTaskSurvClassifIPCW.R
\name{mlr_pipeops_trafotask_survclassif_IPCW}
\alias{mlr_pipeops_trafotask_survclassif_IPCW}
\alias{PipeOpTaskSurvClassifIPCW}
\title{PipeOpTaskSurvClassifIPCW}
\description{
Transform \link{TaskSurv} to \link[mlr3:TaskClassif]{TaskClassif} using the \strong{I}nverse
\strong{P}robability of \strong{C}ensoring \strong{W}eights (IPCW) method by Vock et al. (2016).

Let \eqn{T_i} be the observed times (event or censoring) and \eqn{\delta_i}
the censoring indicators for each observation \eqn{i} in the training set.
The IPCW technique consists of two steps: first we estimate the censoring
distribution \eqn{\hat{G}(t)} using the Kaplan-Meier estimator from the
training data. Then we calculate the observation weights given a cutoff time
\eqn{\tau} as:

\deqn{\omega_i = 1/\hat{G}{(min(T_i,\tau))}}

Observations that are censored prior to \eqn{\tau} are assigned zero weights, i.e.
\eqn{\omega_i = 0}.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops}
or with the associated sugar function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpTaskSurvClassifIPCW$new()
mlr_pipeops$get("trafotask_survclassif_IPCW")
po("trafotask_survclassif_IPCW")
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

\link{PipeOpTaskSurvClassifIPCW} has one input channel named "input", and two
output channels, one named "output" and the other "data".

Training transforms the "input" \link{TaskSurv} to a \link[mlr3:TaskClassif]{TaskClassif},
which is the "output".
The target column is named \code{"status"} and indicates whether \strong{an event occurred}
\strong{before the cutoff time} \eqn{\tau} (\code{1} = yes, \code{0} = no).
The observed times column is removed from the "output" task.
The transformed task has the property \code{"weights"} (the \eqn{\omega_i}).
The "data" is \code{NULL}.

During prediction, the "input" \link{TaskSurv} is transformed to the "output"
\link[mlr3:TaskClassif]{TaskClassif} with \code{"status"} as target (again indicating
if the event occurred before the cutoff time).
The "data" is a \link{data.table} containing the observed \code{times} \eqn{T_i} and
censoring indicators/\code{status} \eqn{\delta_i} of each subject as well as the corresponding
\code{row_ids}.
This "data" is only meant to be used with the \link{PipeOpPredClassifSurvIPCW}.
}

\section{Parameters}{

The parameters are
\itemize{
\item \code{tau} :: \code{numeric()}\cr
Predefined time point for IPCW. Observations with time larger than \eqn{\tau} are censored.
Must be less or equal to the maximum event time.
\item \code{eps} :: \code{numeric()}\cr
Small value to replace \eqn{G(t) = 0} censoring probabilities to prevent
infinite weights (a warning is triggered if this happens).
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines", "mlr3learners"), quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3learners)
  library(mlr3pipelines)

  task = tsk("lung")

  # split task to train and test subtasks
  part = partition(task)
  task_train = task$clone()$filter(part$train)
  task_test = task$clone()$filter(part$test)

  # define IPCW pipeop
  po_ipcw = po("trafotask_survclassif_IPCW", tau = 365)

  # during training, output is a classification task with weights
  task_classif_train = po_ipcw$train(list(task_train))[[1]]
  task_classif_train

  # during prediction, output is a classification task (no weights)
  task_classif_test = po_ipcw$predict(list(task_test))[[1]]
  task_classif_test

  # train classif learner on the train task with weights
  learner = lrn("classif.rpart", predict_type = "prob")
  learner$train(task_classif_train)

  # predict using the test output task
  p = learner$predict(task_classif_test)

  # use classif measures for evaluation
  p$confusion
  p$score()
  p$score(msr("classif.auc"))
}
\dontshow{\}) # examplesIf}
}
\references{
Vock, M D, Wolfson, Julian, Bandyopadhyay, Sunayan, Adomavicius, Gediminas, Johnson, E P, Vazquez-Benitez, Gabriela, O'Connor, J P (2016).
\dQuote{Adapting machine learning techniques to censored time-to-event health record data: A general-purpose approach using inverse probability of censoring weighting.}
\emph{Journal of Biomedical Informatics}, \bold{61}, 119--131.
\doi{https://doi.org/10.1016/j.jbi.2016.03.009}, \url{https://www.sciencedirect.com/science/article/pii/S1532046416000496}.
}
\seealso{
\link{pipeline_survtoclassif_IPCW}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_classifsurv_IPCW}},
\code{\link{mlr_pipeops_trafopred_classifsurv_disctime}},
\code{\link{mlr_pipeops_trafopred_regrsurv_pem}},
\code{\link{mlr_pipeops_trafotask_survclassif_disctime}},
\code{\link{mlr_pipeops_trafotask_survregr_pem}}
}
\concept{Transformation PipeOps}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpTaskSurvClassifIPCW}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpTaskSurvClassifIPCW-new}{\code{PipeOpTaskSurvClassifIPCW$new()}}
\item \href{#method-PipeOpTaskSurvClassifIPCW-clone}{\code{PipeOpTaskSurvClassifIPCW$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTaskSurvClassifIPCW-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTaskSurvClassifIPCW-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskSurvClassifIPCW$new(id = "trafotask_survclassif_IPCW")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTaskSurvClassifIPCW-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTaskSurvClassifIPCW-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskSurvClassifIPCW$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
