% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpPredRegrSurvPEM.R
\name{mlr_pipeops_trafopred_regrsurv_pem}
\alias{mlr_pipeops_trafopred_regrsurv_pem}
\alias{PipeOpPredRegrSurvPEM}
\title{PipeOpPredRegrSurvPEM}
\description{
Transform \link{PredictionRegr} to \link{PredictionSurv}.
The predicted piece-wise constant hazards contained in \link{PredictionRegr} are transformed into survival probabilities and wrapped in a
\link{PredictionSurv} object.

We compute the survival probability from the predicted hazards using the following relation:
\deqn{S(t | \mathbf{x}) = \exp \left( - \int_{0}^{t} \lambda(s | \mathbf{x}) \, ds \right) = \exp \left( - \sum_{j = 1}^{J} \lambda(j | \mathbf{x}) d_j\,  \right),}
where \eqn{j = 1, \ldots, J} denotes the interval, \eqn{t} the time, and \eqn{d_j} the duration of interval \eqn{j}.

For a more detailed description of PEM, refer to \link{pipeline_survtoregr_pem} or the referred article.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops}
or with the associated sugar function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpPredRegrSurvPEM$new()
mlr_pipeops$get("trafopred_regrsurv_pem")
po("trafopred_regrsurv_pem")
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

The input consists of a \link{PredictionRegr} and a \link[data.table:data.table]{data.table}
containing the transformed data. The \link{PredictionRegr} is provided by the \link[mlr3:LearnerRegr]{mlr3::LearnerRegr},
while the \link{data.table} is generated by \link{PipeOpTaskSurvRegrPEM}.
The output is the input \link{PredictionRegr} transformed to a \link{PredictionSurv}.
Only works during prediction phase.
}

\references{
Bender, Andreas, Groll, Andreas, Scheipl, Fabian (2018).
\dQuote{A generalized additive model approach to time-to-event analysis.}
\emph{Statistical Modelling}, \bold{18}(3-4), 299--321.
\url{https://doi.org/10.1177/1471082X17748083}.
}
\seealso{
\link{pipeline_survtoregr_pem}

Other PipeOps: 
\code{\link{mlr_pipeops_survavg}},
\code{\link{mlr_pipeops_trafotask_survregr_pem}}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_classifsurv_IPCW}},
\code{\link{mlr_pipeops_trafopred_classifsurv_disctime}},
\code{\link{mlr_pipeops_trafotask_survclassif_IPCW}},
\code{\link{mlr_pipeops_trafotask_survclassif_disctime}},
\code{\link{mlr_pipeops_trafotask_survregr_pem}}
}
\concept{PipeOps}
\concept{Transformation PipeOps}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpPredRegrSurvPEM}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{predict_type}}{(\code{character(1)})\cr
Returns the active predict type of this PipeOp, which is \code{"crank"}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpPredRegrSurvPEM-new}{\code{PipeOpPredRegrSurvPEM$new()}}
\item \href{#method-PipeOpPredRegrSurvPEM-clone}{\code{PipeOpPredRegrSurvPEM$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpPredRegrSurvPEM-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpPredRegrSurvPEM-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpPredRegrSurvPEM$new(id = "trafopred_regrsurv_pem")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(character(1))\cr
Identifier of the resulting object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpPredRegrSurvPEM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpPredRegrSurvPEM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpPredRegrSurvPEM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
