% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpPredClassifSurvDiscTime.R
\name{mlr_pipeops_trafopred_classifsurv_disctime}
\alias{mlr_pipeops_trafopred_classifsurv_disctime}
\alias{PipeOpPredClassifSurvDiscTime}
\title{PipeOpPredClassifSurvDiscTime}
\description{
Transform \link{PredictionClassif} to \link{PredictionSurv} by converting
event probabilities of a pseudo status variable (discrete time hazards)
to survival probabilities using the product rule (Tutz et al. 2016):

\deqn{P_k = p_k\cdot ... \cdot p_1}

Where:
\itemize{
\item We assume that continuous time is divided into time intervals
\eqn{[0, t_1), [t_1, t_2), ..., [t_n, \infty)}
\item \eqn{P_k = P(T > t_k)} is the survival probability at time \eqn{t_k}
\item \eqn{h_k} is the discrete-time hazard (classifier prediction), i.e. the
conditional probability for an event in the \eqn{k}-interval.
\item \eqn{p_k = 1 - h_k = P(T \ge t_k | T \ge t_{k-1})}
}
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops}
or with the associated sugar function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpPredClassifSurvDiscTime$new()
mlr_pipeops$get("trafopred_classifsurv_disctime")
po("trafopred_classifsurv_disctime")
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

The input is a \link{PredictionClassif} and a \link[data.table:data.table]{data.table}
with the transformed data both generated by \link{PipeOpTaskSurvClassifDiscTime}.
The output is the input \link{PredictionClassif} transformed to a \link{PredictionSurv}.
Only works during prediction phase.
}

\references{
Tutz, Gerhard, Schmid, Matthias (2016).
\emph{Modeling Discrete Time-to-Event Data},  series Springer Series in Statistics.
Springer International Publishing.
ISBN 978-3-319-28156-8 978-3-319-28158-2, \url{http://link.springer.com/10.1007/978-3-319-28158-2}.
}
\seealso{
\link{pipeline_survtoclassif_disctime}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_classifsurv_IPCW}},
\code{\link{mlr_pipeops_trafopred_regrsurv_pem}},
\code{\link{mlr_pipeops_trafotask_survclassif_IPCW}},
\code{\link{mlr_pipeops_trafotask_survclassif_disctime}},
\code{\link{mlr_pipeops_trafotask_survregr_pem}}
}
\concept{Transformation PipeOps}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpPredClassifSurvDiscTime}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{predict_type}}{(\code{character(1)})\cr
Returns the active predict type of this PipeOp, which is \code{"crank"}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpPredClassifSurvDiscTime-new}{\code{PipeOpPredClassifSurvDiscTime$new()}}
\item \href{#method-PipeOpPredClassifSurvDiscTime-clone}{\code{PipeOpPredClassifSurvDiscTime$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpPredClassifSurvDiscTime-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpPredClassifSurvDiscTime-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpPredClassifSurvDiscTime$new(id = "trafopred_classifsurv_disctime")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(character(1))\cr
Identifier of the resulting object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpPredClassifSurvDiscTime-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpPredClassifSurvDiscTime-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpPredClassifSurvDiscTime$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
