% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpProbregrCompositor.R
\name{mlr_pipeops_compose_probregr}
\alias{mlr_pipeops_compose_probregr}
\alias{PipeOpProbregr}
\title{PipeOpProbregr}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Combines a predicted \code{response} and \code{se} from \link{PredictionRegr} with a specified probability
distribution to estimate (or 'compose') a \code{distr} prediction.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops} or with the associated sugar
function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpProbregr$new()
mlr_pipeops$get("compose_probregr")
po("compose_probregr")
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

\link{PipeOpProbregr} has two input channels named \code{"input_response"} and \code{"input_se"},
which take \code{NULL} during training and two \link{PredictionRegr}s during prediction, these should
respectively contain the \code{response} and \code{se} return type, the same object can be passed twice.

The output during prediction is a \link{PredictionRegr} with the "response" from \code{input_response},
the "se" from \code{input_se} and a "distr" created from combining the two.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\itemize{
\item \code{dist} :: \code{character(1)} \cr
Location-scale distribution to use for composition. Current choices are
\code{"Uniform"} (default), \code{"Normal"}, \code{"Cauchy"}, \code{"Gumbel"}, \code{"Laplace"},
\code{"Logistic"}. All implemented via \link{distr6}.
}
}

\section{Internals}{

The composition is created by substituting the \code{response} and \code{se} predictions into the
distribution location and scale parameters respectively.
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines", "rpart"), quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3pipelines)
  set.seed(1)
  task = tsk("boston_housing")

  # Option 1: Use a learner that can predict se
  learn = lrn("regr.featureless", predict_type = "se")
  pred = learn$train(task)$predict(task)
  poc = po("compose_probregr")
  poc$predict(list(pred, pred))[[1]]

  # Option 2: Use two learners, one for response and the other for se
  learn_response = lrn("regr.rpart")
  learn_se = lrn("regr.featureless", predict_type = "se")
  pred_response = learn_response$train(task)$predict(task)
  pred_se = learn_se$train(task)$predict(task)
  poc = po("compose_probregr")
  poc$predict(list(pred_response, pred_se))[[1]]
}
\dontshow{\}) # examplesIf}
}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpProbregr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpProbregr-new}{\code{PipeOpProbregr$new()}}
\item \href{#method-PipeOpProbregr-clone}{\code{PipeOpProbregr$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpProbregr-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpProbregr-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpProbregr$new(id = "compose_probregr", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpProbregr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpProbregr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpProbregr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
