% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.TaskDens}
\alias{autoplot.TaskDens}
\title{Plot for Density Tasks}
\usage{
\method{autoplot}{TaskDens}(object, type = "dens", theme = theme_minimal(), ...)
}
\arguments{
\item{object}{(\link{TaskDens}).}

\item{type}{(\code{character(1)}):
Type of the plot. Available choices:
\itemize{
\item \code{"dens"}: histogram density estimator (default) with \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}}.
\item \code{"freq"}: histogram frequency plot with \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}}.
\item \code{"overlay"}: histogram with overlaid density plot with \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}} and
\code{\link[ggplot2:geom_density]{ggplot2::geom_density()}}.
\item \code{"freqpoly"}: frequency polygon plot with \link[ggplot2:geom_histogram]{ggplot2::geom_freqpoly}.
}}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(\code{any}):
Additional arguments, possibly passed down to the underlying plot functions.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link{TaskDens}.
}
\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3viz", "ggplot2"), quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(mlr3)
library(mlr3proba)
library(mlr3viz)
library(ggplot2)
task = tsk("precip")
task$head()

autoplot(task, bins = 15)
autoplot(task, type = "freq", bins = 15)
autoplot(task, type = "overlay", bins = 15)
autoplot(task, type = "freqpoly", bins = 15)
\dontshow{\}) # examplesIf}
}
