% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_surv_matrix}
\alias{assert_surv_matrix}
\title{Assert survival matrix}
\usage{
assert_surv_matrix(x)
}
\arguments{
\item{x}{(\code{matrix()})\cr
A matrix of (predicted) survival probabilities.
Rows are observations, columns are (increasing) time points.}
}
\value{
if the assertion fails an error occurs, otherwise \code{NULL} is returned
invisibly.
}
\description{
Asserts if the given input matrix is a (discrete) survival
probabilities matrix using \link{Rcpp} code.
The following checks are performed:
\enumerate{
\item All values are probabilities, i.e. \eqn{S(t) \in [0,1]}
\item Column names correspond to time-points and should therefore be coercable to
\code{numeric} and increasing
\item Per row/observation, the survival probabilities decrease non-strictly, i.e.
\eqn{S(t) \ge S(t+1)}
}
}
\examples{
x = matrix(data = c(1,0.6,0.4,0.8,0.8,0.7), nrow = 2, ncol = 3, byrow = TRUE)
colnames(x) = c(12, 34, 42)
x

assert_surv_matrix(x)

}
