% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionSurv.R
\name{PredictionSurv}
\alias{PredictionSurv}
\title{Prediction Object for Survival}
\description{
This object stores the predictions returned by a learner of class \link{LearnerSurv}.

The \code{task_type} is set to \code{"surv"}.

For accessing survival and hazard functions, as well as other complex methods
from a \link{PredictionSurv} object, see public methods on \code{\link[distr6:ExoticStatistics]{distr6::ExoticStatistics()}}
and example below.
}
\examples{
library(mlr3)
task = tsk("rats")
learner = lrn("surv.kaplan")
p = learner$train(task, row_ids = 1:26)$predict(task, row_ids = 27:30)
head(as.data.table(p))

p$distr # distr6::Matdist class (test obs x time points)

# survival probabilities of the 4 test rats at two time points
p$distr$survival(c(20, 100))
}
\seealso{
Other Prediction: 
\code{\link{PredictionDens}}
}
\concept{Prediction}
\section{Super class}{
\code{\link[mlr3:Prediction]{mlr3::Prediction}} -> \code{PredictionSurv}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{truth}}{(\code{Surv})\cr
True (observed) outcome.}

\item{\code{crank}}{(\code{numeric()})\cr
Access the stored predicted continuous ranking.}

\item{\code{distr}}{(\link[distr6:Matdist]{distr6::Matdist}|\link[distr6:Arrdist]{distr6::Arrdist}|\link[distr6:VectorDistribution]{distr6::VectorDistribution})\cr
Convert the stored survival array or matrix to a survival distribution.}

\item{\code{lp}}{(\code{numeric()})\cr
Access the stored predicted linear predictor.}

\item{\code{response}}{(\code{numeric()})\cr
Access the stored predicted survival time.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PredictionSurv-new}{\code{PredictionSurv$new()}}
\item \href{#method-PredictionSurv-clone}{\code{PredictionSurv$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="filter"><a href='../../mlr3/html/Prediction.html#method-Prediction-filter'><code>mlr3::Prediction$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="format"><a href='../../mlr3/html/Prediction.html#method-Prediction-format'><code>mlr3::Prediction$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="help"><a href='../../mlr3/html/Prediction.html#method-Prediction-help'><code>mlr3::Prediction$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="obs_loss"><a href='../../mlr3/html/Prediction.html#method-Prediction-obs_loss'><code>mlr3::Prediction$obs_loss()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="print"><a href='../../mlr3/html/Prediction.html#method-Prediction-print'><code>mlr3::Prediction$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="score"><a href='../../mlr3/html/Prediction.html#method-Prediction-score'><code>mlr3::Prediction$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictionSurv-new"></a>}}
\if{latex}{\out{\hypertarget{method-PredictionSurv-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionSurv$new(
  task = NULL,
  row_ids = task$row_ids,
  truth = task$truth(),
  crank = NULL,
  distr = NULL,
  lp = NULL,
  response = NULL,
  check = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link{TaskSurv})\cr
Task, used to extract defaults for \code{row_ids} and \code{truth}.}

\item{\code{row_ids}}{(\code{integer()})\cr
Row ids of the predicted observations, i.e. the row ids of the test set.}

\item{\code{truth}}{(\code{survival::Surv()})\cr
True (observed) response.}

\item{\code{crank}}{(\code{numeric()})\cr
Numeric vector of predicted continuous rankings (or relative risks). One element for each
observation in the test set. For a pair of continuous ranks, a higher rank indicates that
the observation is more likely to experience the event.}

\item{\code{distr}}{(\verb{matrix()|[distr6::Arrdist]|[distr6::Matdist]|[distr6::VectorDistribution]})\cr
Either a matrix of predicted survival probabilities, a \link[distr6:VectorDistribution]{distr6::VectorDistribution},
a \link[distr6:Matdist]{distr6::Matdist} or an \link[distr6:Arrdist]{distr6::Arrdist}.
If a matrix/array then column names must be given and correspond to survival times.
Rows of matrix correspond to individual predictions. It is advised that the
first column should be time \code{0} with all entries \code{1} and the last
with all entries \code{0}. If a \code{VectorDistribution} then each distribution in the vector
should correspond to a predicted survival distribution.}

\item{\code{lp}}{(\code{numeric()})\cr
Numeric vector of linear predictor scores. One element for each observation in the test
set. \eqn{lp = X\beta} where \eqn{X} is a matrix of covariates and \eqn{\beta} is a vector
of estimated coefficients.}

\item{\code{response}}{(\code{numeric()})\cr
Numeric vector of predicted survival times.
One element for each observation in the test set.}

\item{\code{check}}{(\code{logical(1)})\cr
If \code{TRUE}, performs argument checks and predict type conversions.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Upon \strong{initialization}, if the \code{distr} input is a \link[distr6:Distribution]{Distribution},
we try to coerce it either to a survival matrix or a survival array and store it
in the \verb{$data$distr} slot for internal use.

If the stored \verb{$data$distr} is a \link[distr6:Distribution]{Distribution} object,
the active field \verb{$distr} (\strong{external user API}) returns it without modification.
Otherwise, if \verb{$data$distr} is a survival matrix or array, \verb{$distr}
constructs a distribution out of the \verb{$data$distr} object, which will be a
\link[distr6:Matdist]{Matdist} or \link[distr6:Arrdist]{Arrdist} respectively.

Note that if a survival 3d array is stored in \verb{$data$distr}, the \verb{$distr}
field returns an \link[distr6:Arrdist]{Arrdist} initialized with \code{which.curve = 0.5}
by default (i.e. the median curve). This means that measures that require
a \code{distr} prediction like \link{MeasureSurvGraf}, \link{MeasureSurvRCLL}, etc.
will use the median survival probabilities.
Note that it is possible to manually change \code{which.curve} after construction
of the predicted distribution but we advise against this as it may lead to
inconsistent results.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictionSurv-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PredictionSurv-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionSurv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
