% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureDens.R
\name{MeasureDens}
\alias{MeasureDens}
\title{Density Measure}
\description{
This measure specializes \link[mlr3:Measure]{Measure} for survival problems.
\itemize{
\item \code{task_type} is set to \code{"dens"}.
\item Possible values for \code{predict_type} are \code{"pdf"} and \code{"cdf"}.
}

Predefined measures can be found in the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_measures]{mlr3::mlr_measures}.
}
\seealso{
Default density measures: \code{\link[=mlr_measures_dens.logloss]{dens.logloss}}

Other Measure: 
\code{\link{MeasureSurv}}
}
\concept{Measure}
\section{Super class}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{MeasureDens}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureDens-new}{\code{MeasureDens$new()}}
\item \href{#method-MeasureDens-clone}{\code{MeasureDens$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureDens-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureDens-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureDens$new(
  id,
  param_set = ps(),
  range,
  minimize = NA,
  aggregator = NULL,
  properties = character(),
  predict_type = "pdf",
  task_properties = character(),
  packages = character(),
  label = NA_character_,
  man = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of hyperparameters.}

\item{\code{range}}{(\code{numeric(2)})\cr
Feasible range for this measure as \code{c(lower_bound, upper_bound)}.
Both bounds may be infinite.}

\item{\code{minimize}}{(\code{logical(1)})\cr
Set to \code{TRUE} if good predictions correspond to small values,
and to \code{FALSE} if good predictions correspond to large values.
If set to \code{NA} (default), tuning this measure is not possible.}

\item{\code{aggregator}}{(\verb{function(x)})\cr
Function to aggregate individual performance scores \code{x} where \code{x} is a numeric vector.
If \code{NULL}, defaults to \code{\link[=mean]{mean()}}.}

\item{\code{properties}}{(\code{character()})\cr
Properties of the measure.
Must be a subset of \link[=mlr_reflections]{mlr_reflections$measure_properties}.
Supported by \code{mlr3}:
\itemize{
\item \code{"requires_task"} (requires the complete \link{Task}),
\item \code{"requires_learner"} (requires the trained \link{Learner}),
\item \code{"requires_train_set"} (requires the training indices from the \link{Resampling}), and
\item \code{"na_score"} (the measure is expected to occasionally return \code{NA} or \code{NaN}).
}}

\item{\code{predict_type}}{(\code{character(1)})\cr
Required predict type of the \link{Learner}.
Possible values are stored in \link[=mlr_reflections]{mlr_reflections$learner_predict_types}.}

\item{\code{task_properties}}{(\code{character()})\cr
Required task properties, see \link{Task}.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled by the constructor if at least one of the packages is not installed,
but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureDens-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureDens-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureDens$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
