% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{whas}
\alias{whas}
\title{Worcester Heart Attack Study (WHAS) Dataset}
\format{
\describe{
\item{id}{Identification Code}
\item{age}{Age (per chart) (years).}
\item{sex}{Sex. 0 = Male. 1 = Female.}
\item{cpk}{Peak cardiac enzyme (iu).}
\item{sho}{Cardiogenic shock complications. 1 = Yes. 0 = No.}
\item{chf}{Left heart failure complications. 1 = Yes. 0 = No.}
\item{miord}{MI Order. 1 = Recurrent. 0 = First.}
\item{mitype}{MI Type. 1 = Q-wave. 2 = Not Q-wave. 3 = Indeterminate.}
\item{year}{Cohort year.}
\item{yrgrp}{Grouped cohort year.}
\item{lenstay}{Days in hospital.}
\item{dstat}{Discharge status from hospital. 1 = Dead. 0 = Alive.}
\item{lenfol}{Total length of follow-up from hospital admission (days).}
\item{fstat}{Status as of last follow-up. 1 = Dead. 0 = Alive.}
}
}
\source{
\url{https://onlinelibrary.wiley.com/doi/book/10.1002/9780470258019}
}
\usage{
whas
}
\description{
whas dataset from Hosmer et al. (2008)
}
\references{
Hosmer, D.W. and Lemeshow, S. and May, S. (2008)
Applied Survival Analysis: Regression Modeling of Time to Event Data: Second
Edition, John Wiley and Sons Inc., New York, NY
}
\keyword{datasets}
