% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_probregr.R
\name{plot_probregr}
\alias{plot_probregr}
\title{Visualise probabilistic regression distribution predictions}
\usage{
plot_probregr(
  p,
  n,
  type = c("point", "line", "both", "none"),
  which_plot = c("random", "top"),
  rm_zero = TRUE,
  ...
)
}
\arguments{
\item{p}{(\link{PredictionRegr}) \cr With at least column \code{distr}.}

\item{n}{(\code{integer(1)}) \cr Number of predictions to plot.}

\item{type}{(\code{character(1)}) \cr One of \code{"point"} (default), \code{"line"}, \code{"both"}, \code{"none"}.}

\item{which_plot}{(\code{character(1)}) \cr One of \code{"random"} (default) or \code{"top"}. See details.}

\item{rm_zero}{(\code{logical(1)}) \cr If \code{TRUE} (default) does not plot points where \code{f(x) = 0}.}

\item{...}{Unused}
}
\description{
Plots probability density functions from \code{n} predicted probability
distributions.
}
\details{
\code{type}:
\itemize{
\item \code{"point"} (default) - Truth plotted as point (truth, predicted_pdf(truth))
\item \code{"line"} - Truth plotted as vertical line intercepting x-axis at the truth.
\item \code{"both"} - Plots both the above options.
\item \code{"none"} - Truth not plotted (default if \code{p$truth} is missing).
}

\code{which_plot}:
\itemize{
\item "random"\verb{(default) - Random selection of}n` distributions are plotted.
\item "top"\code{- Top}n` distributions are plotted.
}

It is unlikely the plot will be interpretable when \verb{n >> 5}.
}
\examples{
\dontrun{
library(mlr3verse)
task = tsk("boston_housing")
pipe = as_learner(ppl("probregr", lrn("regr.ranger"), dist = "Normal"))
p = pipe$train(task)$predict(task)
plot_probregr(p, 10, "point", "top")
}
}
