% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskSurv_zzz.R
\name{mlr_tasks_gbsg}
\alias{mlr_tasks_gbsg}
\title{German Breast Cancer Study Survival Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskSurv}.
}
\description{
A survival task for the \link{gbsg} data set.
}
\section{Dictionary}{

This \link{Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_tasks} or with the associated sugar function \code{\link[=tsk]{tsk()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("gbsg")
tsk("gbsg")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{surv}
\item Dimensions: 686x10
\item Properties: -
\item Has Missings: \code{FALSE}
\item Target: \dQuote{time}, \dQuote{status}
\item Features: \dQuote{age}, \dQuote{er}, \dQuote{grade}, \dQuote{hormon}, \dQuote{meno}, \dQuote{nodes}, \dQuote{pgr}, \dQuote{size}
}
}

\section{Pre-processing}{

\itemize{
\item Removed column \code{pid}.
\item Column \code{meno} has been converted to \code{factor} and 0/1 values have been
replaced with \code{premenopausal} and \code{postmenopausal} respectively.
\item Column \code{hormon} has been converted to \code{factor} and 0/1 values have been
replaced with \code{no} and \code{yes} respectively.
\item Column \code{grade} has been converted to \code{factor}.
\item Renamed target column \code{rfstime} to \code{time}.
}
}

\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Task]{Tasks}: \link[mlr3:mlr_tasks]{mlr3::mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[=Task]{Tasks} in the running session
}

Other Task: 
\code{\link{TaskDens}},
\code{\link{TaskSurv}},
\code{\link{mlr_tasks_actg}},
\code{\link{mlr_tasks_faithful}},
\code{\link{mlr_tasks_gbcs}},
\code{\link{mlr_tasks_grace}},
\code{\link{mlr_tasks_lung}},
\code{\link{mlr_tasks_mgus}},
\code{\link{mlr_tasks_pbc}},
\code{\link{mlr_tasks_precip}},
\code{\link{mlr_tasks_rats}},
\code{\link{mlr_tasks_unemployment}},
\code{\link{mlr_tasks_veteran}},
\code{\link{mlr_tasks_whas}}
}
\concept{Task}
