% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTaskSurvClassifDiscTime.R
\name{mlr_pipeops_trafotask_survclassif_disctime}
\alias{mlr_pipeops_trafotask_survclassif_disctime}
\alias{PipeOpTaskSurvClassifDiscTime}
\title{PipeOpTaskSurvClassifDiscTime}
\description{
Transform \link{TaskSurv} to \link[mlr3:TaskClassif]{TaskClassif} by dividing continuous
time into multiple time intervals for each observation.
This transformation creates a new target variable \code{disc_status} that indicates
whether an event occurred within each time interval.
This approach facilitates survival analysis within a classification framework
using discrete time intervals (Tutz et al. 2016).
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops}
or with the associated sugar function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpTaskSurvClassifDiscTime$new()
mlr_pipeops$get("trafotask_survclassif_disctime")
po("trafotask_survclassif_disctime")
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

\link{PipeOpTaskSurvClassifDiscTime} has one input channel named "input", and two
output channels, one named "output" and the other "transformed_data".

During training, the "output" is the "input" \link{TaskSurv} transformed to a
\link[mlr3:TaskClassif]{TaskClassif}.
The target column is named \code{"disc_status"} and indicates whether an event occurred
in each time interval.
An additional feature named \code{"tend"} contains the end time point of each interval.
Lastly, the "output" task has a column with the original observation ids,
under the role \code{"original_ids"}.
The "transformed_data" is an empty \link[data.table:data.table]{data.table}.

During prediction, the "input" \link{TaskSurv} is transformed to the "output"
\link[mlr3:TaskClassif]{TaskClassif} with \code{"disc_status"} as target and the \code{"tend"}
feature included.
The "transformed_data" is a \link{data.table} with columns the \code{"disc_status"}
target of the "output" task, the \code{"id"} (original observation ids),
\code{"obs_times"} (observed times per \code{"id"}) and \code{"tend"} (end time of each interval).
This "transformed_data" is only meant to be used with the \link{PipeOpPredClassifSurvDiscTime}.
}

\section{State}{

The \verb{$state} contains information about the \code{cut} parameter used.
}

\section{Parameters}{

The parameters are
\itemize{
\item \code{cut :: numeric()}\cr
Split points, used to partition the data into intervals based on the \code{time} column.
If unspecified, all unique event times will be used.
If \code{cut} is a single integer, it will be interpreted as the number of equidistant
intervals from 0 until the maximum event time.
\item \code{max_time :: numeric(1)}\cr
If \code{cut} is unspecified, this will be the last possible event time.
All event times after \code{max_time} will be administratively censored at \code{max_time.}
Needs to be greater than the minimum event time in the given task.
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines", "mlr3learners"), quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3learners)
  library(mlr3pipelines)

  task = tsk("lung")

  # transform the survival task to a classification task
  # all unique event times are used as cutpoints
  po_disc = po("trafotask_survclassif_disctime")
  task_classif = po_disc$train(list(task))[[1L]]

  # the end time points of the discrete time intervals
  unique(task_classif$data(cols = "tend"))[[1L]]

  # train a classification learner
  learner = lrn("classif.log_reg", predict_type = "prob")
  learner$train(task_classif)
}
\dontshow{\}) # examplesIf}
}
\references{
Tutz, Gerhard, Schmid, Matthias (2016).
\emph{Modeling Discrete Time-to-Event Data},  series Springer Series in Statistics.
Springer International Publishing.
ISBN 978-3-319-28156-8 978-3-319-28158-2, \url{http://link.springer.com/10.1007/978-3-319-28158-2}.
}
\seealso{
\link{pipeline_survtoclassif_disctime}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_classifsurv_IPCW}},
\code{\link{mlr_pipeops_trafopred_classifsurv_disctime}},
\code{\link{mlr_pipeops_trafotask_survclassif_IPCW}}
}
\concept{Transformation PipeOps}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpTaskSurvClassifDiscTime}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpTaskSurvClassifDiscTime-new}{\code{PipeOpTaskSurvClassifDiscTime$new()}}
\item \href{#method-PipeOpTaskSurvClassifDiscTime-clone}{\code{PipeOpTaskSurvClassifDiscTime$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTaskSurvClassifDiscTime-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTaskSurvClassifDiscTime-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskSurvClassifDiscTime$new(id = "trafotask_survclassif_disctime")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTaskSurvClassifDiscTime-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTaskSurvClassifDiscTime-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskSurvClassifDiscTime$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
