% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpResponseCompositor.R
\name{mlr_pipeops_responsecompose}
\alias{mlr_pipeops_responsecompose}
\alias{PipeOpResponseCompositor}
\title{PipeOpResponseCompositor}
\description{
Uses a predicted survival distribution (\code{distr}) in a \link{PredictionSurv} to estimate (or 'compose') an expected survival time (\code{response}) prediction.
Practically, this \code{PipeOp} summarizes an observation's survival curve/distribution to a single number which can be either the restricted mean survival time or the median survival time.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops} or with the associated sugar
function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpResponseCompositor$new()
mlr_pipeops$get("responsecompose")
po("responsecompose")
}\if{html}{\out{</div>}}
}

\section{Input and Output Channels}{

\link{PipeOpResponseCompositor} has one input channel named \code{"input"}, which takes
\code{NULL} during training and \link{PredictionSurv} during prediction.

\link{PipeOpResponseCompositor} has one output channel named \code{"output"}, producing \code{NULL} during training
and a \link{PredictionSurv} during prediction.

The output during prediction is the \link{PredictionSurv} from the input but with the \code{response}
predict type overwritten by the given method.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\itemize{
\item \code{method} :: \code{character(1)} \cr
Determines what method should be used to produce a survival time (response) from the survival distribution.
Available methods are \code{"rmst"} and \code{"median"}, corresponding to the \emph{restricted mean survival time} and the \emph{median survival time} respectively.
\item \code{tau} :: \code{numeric(1)} \cr
Determines the time point up to which we calculate the restricted mean survival time (works only for the \code{"rmst"} method).
If \code{NULL} (default), all the available time points in the predicted survival distribution will be used.
}
\itemize{
\item \code{add_crank} :: \code{logical(1)} \cr
If \code{TRUE} then \code{crank} predict type will be set as \code{-response} (as higher survival times correspond to lower risk).
Works only if \code{overwrite} is \code{TRUE}.
\item \code{overwrite} :: \code{logical(1)} \cr
If \code{FALSE} (default) and the prediction already has a \code{response} prediction, then the compositor returns the input prediction unchanged.
If \code{TRUE}, then the \code{response} (and the \code{crank}, if \code{add_crank} is \code{TRUE}) will be overwritten.
}
}

\section{Internals}{

The restricted mean survival time is the default/preferred method and is calculated as follows:
\deqn{T_{i,rmst} \approx \sum_{t_j \in [0,\tau]} (t_j - t_{j-1}) S_i(t_j)}

where \eqn{T} is the expected survival time, \eqn{\tau} is the time cutoff/horizon and \eqn{S_i(t_j)} are the predicted survival probabilities of observation \eqn{i} for all the \eqn{t_j} time points.

The \eqn{T_{i,median}} survival time is just the first time point for which the survival probability is less than \eqn{0.5}.
If no such time point exists (e.g. when the survival distribution is not proper due to high censoring) we return the last time point.
This is \strong{not a good estimate to use in general}, only a reasonable substitute in such cases.
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines"), quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  library(mlr3pipelines)
  task = tsk("rats")

  # add survival time prediction type to the predictions of a Cox model
  # Median survival time as response
  pred = lrn("surv.coxph")$train(task)$predict(task)
  por = po("responsecompose", param_vals = list(method = "median", overwrite = TRUE))
  por$predict(list(pred))[[1L]]
  # mostly improper survival distributions, "median" sets the survival time
  # to the last time point

  # RMST (default) as response, while also changing the `crank` to `-response`
  por = po("responsecompose", param_vals = list(overwrite = TRUE, add_crank = TRUE))
  por$predict(list(pred))[[1L]]
}
\dontshow{\}) # examplesIf}
}
\references{
Zhao, Lihui, Claggett, Brian, Tian, Lu, Uno, Hajime, Pfeffer, A. M, Solomon, D. S, Trippa, Lorenzo, Wei, J. L (2016).
\dQuote{On the restricted mean survival time curve in survival analysis.}
\emph{Biometrics}, \bold{72}(1), 215--221.
ISSN 1541-0420, \doi{10.1111/BIOM.12384}, \url{https://onlinelibrary.wiley.com/doi/full/10.1111/biom.12384}.
}
\seealso{
\link{pipeline_responsecompositor}

Other survival compositors: 
\code{\link{mlr_pipeops_compose_breslow_distr}},
\code{\link{mlr_pipeops_crankcompose}},
\code{\link{mlr_pipeops_distrcompose}}
}
\concept{survival compositors}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpResponseCompositor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpResponseCompositor-new}{\code{PipeOpResponseCompositor$new()}}
\item \href{#method-PipeOpResponseCompositor-clone}{\code{PipeOpResponseCompositor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpResponseCompositor-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpResponseCompositor-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpResponseCompositor$new(id = "responsecompose", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpResponseCompositor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpResponseCompositor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpResponseCompositor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
