% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvSongTNR.R
\name{mlr_measures_surv.song_tnr}
\alias{mlr_measures_surv.song_tnr}
\alias{MeasureSurvSongTNR}
\title{Song and Zhou's TNR Survival Measure}
\description{
Calls \code{\link[survAUC:AUC.Song_Zhou]{survAUC::spec.sh()}}.

Assumes Cox PH model specification.

\code{times} and \code{lp_thresh} are arbitrarily set to \code{0} to prevent crashing, these
should be further specified.
}
\details{
All measures implemented from \CRANpkg{survAUC} should be used with
care, we are aware of problems in implementation that sometimes cause fatal
errors in R.
In future updates some of these measures may be re-written and implemented
directly in \code{mlr3proba}.
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:mlr_sugar]{msr()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{MeasureSurvSongTNR$new()
mlr_measures$get("surv.song_tnr")
msr("surv.song_tnr")
}\if{html}{\out{</div>}}
}

\section{Parameters}{
\tabular{llll}{
   Id \tab Type \tab Default \tab Range \cr
   times \tab numeric \tab - \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   lp_thresh \tab numeric \tab 0 \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{lp}
}
}

\section{Parameter details}{

\itemize{
\item \code{times} (\code{numeric()})\cr
If \code{integrated == TRUE} then a vector of time-points over which to integrate the score.
If \code{integrated == FALSE} then a single time point at which to return the score.
}


\itemize{
\item \code{lp_thresh} (\code{numeric(1)})\cr
Determines the cutoff threshold of the linear predictor in the
calculation of the TPR/TNR scores.
}
}

\references{
Song, Xiao, Zhou, Xiao-Hua (2008).
\dQuote{A semiparametric approach for the covariate specific ROC curve with survival outcome.}
\emph{Statistica Sinica}, \bold{18}(3), 947--65.
\url{https://www.jstor.org/stable/24308524}.
}
\seealso{
Other survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.cindex}},
\code{\link{mlr_measures_surv.dcalib}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.mae}},
\code{\link{mlr_measures_surv.mse}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.rcll}},
\code{\link{mlr_measures_surv.rmse}},
\code{\link{mlr_measures_surv.schmid}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}

Other AUC survival measures: 
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}}

Other lp survival measures: 
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}
}
\concept{AUC survival measures}
\concept{lp survival measures}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{\link[mlr3proba:MeasureSurvAUC]{mlr3proba::MeasureSurvAUC}} -> \code{MeasureSurvSongTNR}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureSurvSongTNR-new}{\code{MeasureSurvSongTNR$new()}}
\item \href{#method-MeasureSurvSongTNR-clone}{\code{MeasureSurvSongTNR$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3proba" data-topic="MeasureSurv" data-id="print"><a href='../../mlr3proba/html/MeasureSurv.html#method-MeasureSurv-print'><code>mlr3proba::MeasureSurv$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvSongTNR-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvSongTNR-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvSongTNR$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvSongTNR-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvSongTNR-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvSongTNR$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
