% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvDCalibration.R
\name{mlr_measures_surv.dcalib}
\alias{mlr_measures_surv.dcalib}
\alias{MeasureSurvDCalibration}
\title{D-Calibration Survival Measure}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This calibration method is defined by calculating the following statistic:
\deqn{s = B/n \sum_i (P_i - n/B)^2}
where \eqn{B} is number of 'buckets' (that equally divide \eqn{[0,1]} into intervals),
\eqn{n} is the number of predictions, and \eqn{P_i} is the observed proportion
of observations in the \eqn{i}th interval. An observation is assigned to the
\eqn{i}th bucket, if its predicted survival probability at the time of event
falls within the corresponding interval.
This statistic assumes that censoring time is independent of death time.

A model is well D-calibrated if \eqn{s \sim Unif(B)}, tested with \code{chisq.test}
(\eqn{p > 0.05} if well-calibrated, i.e. higher p-values are preferred).
Model \eqn{i} is better calibrated than model \eqn{j} if \eqn{s(i) < s(j)},
meaning that \emph{lower values} of this measure are preferred.
}
\details{
This measure can either return the test statistic or the p-value from the \code{chisq.test}.
The former is useful for model comparison whereas the latter is useful for determining if a model
is well-calibrated. If \code{chisq = FALSE} and \code{s} is the predicted value then you can manually
compute the p.value with \code{pchisq(s, B - 1, lower.tail = FALSE)}.

\strong{NOTE}: This measure is still experimental both theoretically and in implementation. Results
should therefore only be taken as an indicator of performance and not for
conclusive judgements about model calibration.
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:mlr_sugar]{msr()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{MeasureSurvDCalibration$new()
mlr_measures$get("surv.dcalib")
msr("surv.dcalib")
}\if{html}{\out{</div>}}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   B \tab integer \tab 10 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   chisq \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   truncate \tab numeric \tab Inf \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{distr}
}
}

\section{Parameter details}{

\itemize{
\item \code{B} (\code{integer(1)}) \cr
Number of buckets to test for uniform predictions over.
Default of \code{10} is recommended by Haider et al. (2020).
Changing this parameter affects \code{truncate}.
\item \code{chisq} (\code{logical(1)}) \cr
If \code{TRUE} returns the p-value of the corresponding chisq.test instead of the measure.
Default is \code{FALSE} and returns the statistic \code{s}.
You can manually get the p-value by executing \code{pchisq(s, B - 1, lower.tail = FALSE)}.
The null hypothesis is that the model is D-calibrated.
\item \code{truncate} (\code{double(1)}) \cr
This parameter controls the upper bound of the output statistic, when \code{chisq} is \code{FALSE}.
We use \code{truncate = Inf} by default but values between \eqn{10-16} are sufficient
for most purposes, which correspond to p-values of \eqn{0.35-0.06} for the \code{chisq.test} using
the default \eqn{B = 10} buckets.
Values \eqn{B > 10} translate to even lower p-values and thus less D-calibrated models.
If the number of buckets \eqn{B} changes, you probably will want to
change the \code{truncate} value as well to correspond to the same p-value significance.
Note that truncation may severely limit automated tuning with this measure.
}
}

\references{
Haider, Humza, Hoehn, Bret, Davis, Sarah, Greiner, Russell (2020).
\dQuote{Effective Ways to Build and Evaluate Individual Survival Distributions.}
\emph{Journal of Machine Learning Research}, \bold{21}(85), 1--63.
\url{https://jmlr.org/papers/v21/18-772.html}.
}
\seealso{
Other survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.cindex}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.mae}},
\code{\link{mlr_measures_surv.mse}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.rcll}},
\code{\link{mlr_measures_surv.rmse}},
\code{\link{mlr_measures_surv.schmid}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}

Other calibration survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_beta}}

Other distr survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.rcll}},
\code{\link{mlr_measures_surv.schmid}}
}
\concept{calibration survival measures}
\concept{distr survival measures}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{MeasureSurvDCalibration}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureSurvDCalibration-new}{\code{MeasureSurvDCalibration$new()}}
\item \href{#method-MeasureSurvDCalibration-clone}{\code{MeasureSurvDCalibration$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3proba" data-topic="MeasureSurv" data-id="print"><a href='../../mlr3proba/html/MeasureSurv.html#method-MeasureSurv-print'><code>mlr3proba::MeasureSurv$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvDCalibration-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvDCalibration-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvDCalibration$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvDCalibration-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvDCalibration-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvDCalibration$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
