% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvCalibrationAlpha.R
\name{mlr_measures_surv.calib_alpha}
\alias{mlr_measures_surv.calib_alpha}
\alias{MeasureSurvCalibrationAlpha}
\title{Van Houwelingen's Calibration Alpha Survival Measure}
\description{
This calibration method is defined by estimating
\deqn{\hat{\alpha} = \sum \delta_i / \sum H_i(T_i)}
where \eqn{\delta} is the observed censoring indicator from the test data,
\eqn{H_i} is the predicted cumulative hazard, and \eqn{T_i} is the observed
survival time (event or censoring).

The standard error is given by
\deqn{\hat{\alpha_{se}} = exp(1/\sqrt{\sum \delta_i})}

The model is well calibrated if the estimated \eqn{\hat{\alpha}} coefficient
(returned score) is equal to 1.
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:mlr_sugar]{msr()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{MeasureSurvCalibrationAlpha$new()
mlr_measures$get("surv.calib_alpha")
msr("surv.calib_alpha")
}\if{html}{\out{</div>}}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   eps \tab numeric \tab 0.001 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   se \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   method \tab character \tab ratio \tab ratio, diff \tab - \cr
   truncate \tab numeric \tab Inf \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{(-\infty, \infty)}{(-Inf, Inf)}
\item Minimize: \code{FALSE}
\item Required prediction: \code{distr}
}
}

\section{Parameter details}{

\itemize{
\item \code{eps} (\code{numeric(1)})\cr
Very small number to substitute zero values in order to prevent errors
in e.g. log(0) and/or division-by-zero calculations.
Default value is 0.001.
}


\itemize{
\item \code{se} (\code{logical(1)})\cr
If \code{TRUE} then return standard error of the measure, otherwise the score
itself (default).
\item \code{method} (\code{character(1)})\cr
Returns \eqn{\hat{\alpha}} if equal to \code{ratio} (default) and
\eqn{|1-\hat{\alpha}|} if equal to \code{diff}.
With \code{diff}, the output score can be minimized and for example be used for
tuning purposes. This parameter takes effect only if \code{se} is \code{FALSE}.
\item \code{truncate} (\code{double(1)}) \cr
This parameter controls the upper bound of the output score.
We use \code{truncate = Inf} by default (so no truncation) and it's up to the user
\strong{to set this up reasonably} given the chosen \code{method}.
Note that truncation may severely limit automated tuning with this measure
using \code{method = diff}.
}
}

\references{
Van Houwelingen, C. H (2000).
\dQuote{Validation, calibration, revision and combination of prognostic survival models.}
\emph{Statistics in Medicine}, \bold{19}(24), 3401--3415.
\doi{10.1002/1097-0258(20001230)19:24<3401::AID-SIM554>3.0.CO;2-2}.
}
\seealso{
Other survival measures: 
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.cindex}},
\code{\link{mlr_measures_surv.dcalib}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.mae}},
\code{\link{mlr_measures_surv.mse}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.rcll}},
\code{\link{mlr_measures_surv.rmse}},
\code{\link{mlr_measures_surv.schmid}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}

Other calibration survival measures: 
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.dcalib}}

Other distr survival measures: 
\code{\link{mlr_measures_surv.dcalib}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.rcll}},
\code{\link{mlr_measures_surv.schmid}}
}
\concept{calibration survival measures}
\concept{distr survival measures}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{MeasureSurvCalibrationAlpha}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureSurvCalibrationAlpha-new}{\code{MeasureSurvCalibrationAlpha$new()}}
\item \href{#method-MeasureSurvCalibrationAlpha-clone}{\code{MeasureSurvCalibrationAlpha$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3proba" data-topic="MeasureSurv" data-id="print"><a href='../../mlr3proba/html/MeasureSurv.html#method-MeasureSurv-print'><code>mlr3proba::MeasureSurv$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvCalibrationAlpha-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvCalibrationAlpha-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvCalibrationAlpha$new(method = "ratio")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{defines which output score to return, see "Parameter
details" section.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureSurvCalibrationAlpha-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureSurvCalibrationAlpha-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvCalibrationAlpha$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
