% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvCoxPH.R
\name{mlr_learners_surv.coxph}
\alias{mlr_learners_surv.coxph}
\alias{LearnerSurvCoxPH}
\title{Cox Proportional Hazards Survival Learner}
\description{
Calls \code{\link[survival:coxph]{survival::coxph()}}.
\itemize{
\item lp is predicted by \code{\link[survival:predict.coxph]{survival::predict.coxph()}}
\item distr is predicted by \code{\link[survival:survfit.coxph]{survival::survfit.coxph()}}
\item \code{crank} is identical to \code{lp}
}
}
\section{Dictionary}{

This \link[mlr3:Learner]{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_learners]{mlr_learners} or with the associated sugar function \link[mlr3:mlr_sugar]{lrn()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{LearnerSurvCoxPH$new()
mlr_learners$get("surv.coxph")
lrn("surv.coxph")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{surv}
\item Predict Types: \dQuote{crank}, \dQuote{distr}, \dQuote{lp}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{factor}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3proba}, \CRANpkg{survival}, \CRANpkg{distr6}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   ties \tab character \tab efron \tab efron, breslow, exact \tab - \cr
   singular.ok \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   type \tab character \tab efron \tab efron, aalen, kalbfleisch-prentice \tab - \cr
   stype \tab integer \tab 2 \tab  \tab \eqn{[1, 2]}{[1, 2]} \cr
}
}

\references{
Cox DR (1972).
\dQuote{Regression Models and Life-Tables.}
\emph{Journal of the Royal Statistical Society: Series B (Methodological)}, \bold{34}(2), 187--202.
\doi{10.1111/j.2517-6161.1972.tb00899.x}.
}
\seealso{
Other survival learners: 
\code{\link{mlr_learners_surv.kaplan}},
\code{\link{mlr_learners_surv.rpart}}
}
\concept{survival learners}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3proba:LearnerSurv]{mlr3proba::LearnerSurv}} -> \code{LearnerSurvCoxPH}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerSurvCoxPH-new}{\code{LearnerSurvCoxPH$new()}}
\item \href{#method-LearnerSurvCoxPH-clone}{\code{LearnerSurvCoxPH$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerSurvCoxPH-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerSurvCoxPH-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvCoxPH$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerSurvCoxPH-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerSurvCoxPH-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvCoxPH$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
