% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerDensKDE.R
\name{mlr_learners_dens.kde}
\alias{mlr_learners_dens.kde}
\alias{LearnerDensKDE}
\title{Kernel Density Estimator}
\description{
Calls kernels implemented in \link{distr6} and the result is coerced to a \link[distr6:Distribution]{distr6::Distribution}.
}
\details{
The default bandwidth uses Silverman's rule-of-thumb for Gaussian kernels, however for
non-Gaussian kernels it is recommended to use \CRANpkg{mlr3tuning} to tune the bandwidth with
cross-validation. Other density learners can be used for automated bandwidth selection.
The default kernel is Epanechnikov (chosen to reduce dependencies).
}
\section{Dictionary}{

This \link[mlr3:Learner]{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_learners]{mlr_learners} or with the associated sugar function \link[mlr3:mlr_sugar]{lrn()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{LearnerDensKDE$new()
mlr_learners$get("dens.kde")
lrn("dens.kde")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Type: "dens"
\item Predict Types: \verb{pdf, distr}
\item Feature Types: \verb{integer, numeric}
\item Properties: \code{missings}
\item Packages: \CRANpkg{mlr3} \CRANpkg{mlr3proba} \CRANpkg{distr6}
}
}

\references{
Silverman, W. B (1986).
\emph{Density Estimation for Statistics and Data Analysis}.
Chapman & Hall, London.
}
\seealso{
Other density estimators: 
\code{\link{mlr_learners_dens.hist}}
}
\concept{density estimators}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3proba:LearnerDens]{mlr3proba::LearnerDens}} -> \code{LearnerDensKDE}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerDensKDE-new}{\code{LearnerDensKDE$new()}}
\item \href{#method-LearnerDensKDE-clone}{\code{LearnerDensKDE$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerDensKDE-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerDensKDE-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerDensKDE$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerDensKDE-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerDensKDE-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerDensKDE$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
